/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.operator.RetryPolicy;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.assertions.AggregationFunction;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.AdaptiveReorderPartitionedJoin;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.RuleAssert;
import io.trino.sql.planner.iterative.rule.test.RuleTester;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.junit.jupiter.api.Test;

public class TestAdaptiveReorderPartitionedJoin
extends BaseRuleTest {
    public TestAdaptiveReorderPartitionedJoin() {
        super(new Plugin[0]);
    }

    @Test
    public void testReorderPartitionedJoin() {
        this.assertWithoutPartialAgg(2.0E10, 1.0E10).matches(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("buildSymbol", "probeSymbol").distributionType(JoinNode.DistributionType.PARTITIONED).left(PlanMatchPattern.remoteSource((List<PlanFragmentId>)ImmutableList.of((Object)new PlanFragmentId("2")), (List<String>)ImmutableList.of((Object)"buildSymbol", (Object)"symbol1"), ExchangeNode.Type.REPARTITION)).right(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of((Object)"probeSymbol"), Optional.of(ImmutableList.of((Object)ImmutableList.of((Object)"probeSymbol", (Object)"symbol2"))), PlanMatchPattern.remoteSource((List<PlanFragmentId>)ImmutableList.of((Object)new PlanFragmentId("1")), (List<String>)ImmutableList.of((Object)"probeSymbol", (Object)"symbol2"), ExchangeNode.Type.REPARTITION)))));
        this.assertWithPartialAgg(2.0E10, 1.0E10).matches(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("buildSymbol", "probeSymbol").distributionType(JoinNode.DistributionType.PARTITIONED).left(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), AggregationNode.Step.PARTIAL, PlanMatchPattern.remoteSource((List<PlanFragmentId>)ImmutableList.of((Object)new PlanFragmentId("2")), (List<String>)ImmutableList.of((Object)"buildSymbol", (Object)"symbol1"), ExchangeNode.Type.REPARTITION))).right(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of((Object)"probeSymbol"), Optional.of(ImmutableList.of((Object)ImmutableList.of((Object)"probeSymbol", (Object)"symbol2"))), PlanMatchPattern.remoteSource((List<PlanFragmentId>)ImmutableList.of((Object)new PlanFragmentId("1")), (List<String>)ImmutableList.of((Object)"probeSymbol", (Object)"symbol2"), ExchangeNode.Type.REPARTITION)))));
    }

    @Test
    public void testReorderPartitionedJoinWithMultipleSources() {
        this.assertWithPartialAggAndMultipleSources(2.0E10, 1.0E10).matches(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("buildSymbol", "probeSymbol").distributionType(JoinNode.DistributionType.PARTITIONED).left(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), AggregationNode.Step.PARTIAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, Optional.of(ExchangeNode.Type.REPARTITION), Optional.of(SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION), (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of(), Optional.of(ImmutableList.of((Object)ImmutableList.of((Object)"buildSymbol1", (Object)"symbol11"), (Object)ImmutableList.of((Object)"buildSymbol2", (Object)"symbol12"))), (List<String>)ImmutableList.of((Object)"buildSymbol", (Object)"symbol1"), Optional.empty(), PlanMatchPattern.remoteSource((List<PlanFragmentId>)ImmutableList.of((Object)new PlanFragmentId("3")), (List<String>)ImmutableList.of((Object)"buildSymbol1", (Object)"symbol11"), ExchangeNode.Type.REPARTITION), PlanMatchPattern.remoteSource((List<PlanFragmentId>)ImmutableList.of((Object)new PlanFragmentId("4")), (List<String>)ImmutableList.of((Object)"buildSymbol2", (Object)"symbol12"), ExchangeNode.Type.REPARTITION)))).right(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, Optional.of(ExchangeNode.Type.REPARTITION), Optional.of(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION), (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of((Object)"probeSymbol"), Optional.of(ImmutableList.of((Object)ImmutableList.of((Object)"probeSymbol1", (Object)"symbol21"), (Object)ImmutableList.of((Object)"probeSymbol2", (Object)"symbol22"))), (List<String>)ImmutableList.of((Object)"probeSymbol", (Object)"symbol2"), Optional.empty(), PlanMatchPattern.remoteSource((List<PlanFragmentId>)ImmutableList.of((Object)new PlanFragmentId("1")), (List<String>)ImmutableList.of((Object)"probeSymbol1", (Object)"symbol21"), ExchangeNode.Type.REPARTITION), PlanMatchPattern.remoteSource((List<PlanFragmentId>)ImmutableList.of((Object)new PlanFragmentId("2")), (List<String>)ImmutableList.of((Object)"probeSymbol2", (Object)"symbol22"), ExchangeNode.Type.REPARTITION)))));
        this.assertWithoutPartialAggAndMultipleSources(2.0E10, 1.0E10).matches(PlanMatchPattern.join(JoinType.INNER, builder -> builder.equiCriteria("buildSymbol", "probeSymbol").distributionType(JoinNode.DistributionType.PARTITIONED).left(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, Optional.of(ExchangeNode.Type.REPARTITION), Optional.of(SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION), (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of(), Optional.of(ImmutableList.of((Object)ImmutableList.of((Object)"buildSymbol1", (Object)"symbol11"), (Object)ImmutableList.of((Object)"buildSymbol2", (Object)"symbol12"))), (List<String>)ImmutableList.of((Object)"buildSymbol", (Object)"symbol1"), Optional.empty(), PlanMatchPattern.remoteSource((List<PlanFragmentId>)ImmutableList.of((Object)new PlanFragmentId("3")), (List<String>)ImmutableList.of((Object)"buildSymbol1", (Object)"symbol11"), ExchangeNode.Type.REPARTITION), PlanMatchPattern.remoteSource((List<PlanFragmentId>)ImmutableList.of((Object)new PlanFragmentId("4")), (List<String>)ImmutableList.of((Object)"buildSymbol2", (Object)"symbol12"), ExchangeNode.Type.REPARTITION))).right(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, Optional.of(ExchangeNode.Type.REPARTITION), Optional.of(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION), (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of((Object)"probeSymbol"), Optional.of(ImmutableList.of((Object)ImmutableList.of((Object)"probeSymbol1", (Object)"symbol21"), (Object)ImmutableList.of((Object)"probeSymbol2", (Object)"symbol22"))), (List<String>)ImmutableList.of((Object)"probeSymbol", (Object)"symbol2"), Optional.empty(), PlanMatchPattern.remoteSource((List<PlanFragmentId>)ImmutableList.of((Object)new PlanFragmentId("1")), (List<String>)ImmutableList.of((Object)"probeSymbol1", (Object)"symbol21"), ExchangeNode.Type.REPARTITION), PlanMatchPattern.remoteSource((List<PlanFragmentId>)ImmutableList.of((Object)new PlanFragmentId("2")), (List<String>)ImmutableList.of((Object)"probeSymbol2", (Object)"symbol22"), ExchangeNode.Type.REPARTITION)))));
    }

    @Test
    public void testNoChangesWhenBuildSourceIsSmaller() {
        this.assertWithPartialAgg(1.0E10, 2.0E10).doesNotFire();
        this.assertWithoutPartialAgg(1.0E10, 2.0E10).doesNotFire();
    }

    @Test
    public void testNoChangesWhenBuildSideIsBelowMinSizeLimit() {
        this.assertWithPartialAgg(1.0E8, 1000000.0).doesNotFire();
        this.assertWithoutPartialAgg(1.0E8, 1000000.0).doesNotFire();
    }

    @Test
    public void testNoChangesWhenEitherBuildOrProbeSideIsNan() {
        this.assertWithoutPartialAgg(Double.NaN, 1.0E10).doesNotFire();
        this.assertWithoutPartialAgg(2.0E10, Double.NaN).doesNotFire();
        this.assertWithoutPartialAgg(Double.NaN, Double.NaN).doesNotFire();
    }

    private RuleAssert assertWithPartialAgg(double buildRowCount, double probeRowCount) {
        RuleTester ruleTester = this.tester();
        String buildRemoteSourceId = "buildRemoteSourceId";
        String probeRemoteSourceId = "probeRemoteSourceId";
        return ruleTester.assertThat((Rule<?>)new AdaptiveReorderPartitionedJoin(ruleTester.getMetadata())).setSystemProperty("retry_policy", RetryPolicy.TASK.name()).overrideStats("buildRemoteSourceId", PlanNodeStatsEstimate.builder().setOutputRowCount(buildRowCount).build()).overrideStats("probeRemoteSourceId", PlanNodeStatsEstimate.builder().setOutputRowCount(probeRowCount).build()).on(p -> {
            Symbol buildSymbol = p.symbol("buildSymbol", (Type)BigintType.BIGINT);
            Symbol symbol1 = p.symbol("symbol1", (Type)BigintType.BIGINT);
            Symbol probeSymbol = p.symbol("probeSymbol", (Type)BigintType.BIGINT);
            Symbol symbol2 = p.symbol("symbol2", (Type)BigintType.BIGINT);
            return p.join(JoinType.INNER, JoinNode.DistributionType.PARTITIONED, (PlanNode)p.remoteSource(new PlanNodeId(probeRemoteSourceId), (List<PlanFragmentId>)ImmutableList.of((Object)new PlanFragmentId("1")), (List<Symbol>)ImmutableList.of((Object)probeSymbol, (Object)symbol2), Optional.empty(), ExchangeNode.Type.REPARTITION, RetryPolicy.TASK), (PlanNode)p.aggregation(ab -> ab.step(AggregationNode.Step.PARTIAL).singleGroupingSet(buildSymbol, symbol1).source((PlanNode)p.exchange(builder -> builder.addInputsSet(buildSymbol, symbol1).addSource((PlanNode)p.remoteSource(new PlanNodeId(buildRemoteSourceId), (List<PlanFragmentId>)ImmutableList.of((Object)new PlanFragmentId("2")), (List<Symbol>)ImmutableList.of((Object)buildSymbol, (Object)symbol1), Optional.empty(), ExchangeNode.Type.REPARTITION, RetryPolicy.TASK)).fixedHashDistributionPartitioningScheme((List<Symbol>)ImmutableList.of((Object)buildSymbol, (Object)symbol1), (List<Symbol>)ImmutableList.of((Object)buildSymbol)).type(ExchangeNode.Type.REPARTITION).scope(ExchangeNode.Scope.LOCAL)))), new JoinNode.EquiJoinClause(probeSymbol, buildSymbol));
        });
    }

    private RuleAssert assertWithPartialAggAndMultipleSources(double buildRowCount, double probeRowCount) {
        RuleTester ruleTester = this.tester();
        String buildRemoteSourceA = "buildRemoteSourceA";
        String buildRemoteSourceB = "buildRemoteSourceB";
        String probeRemoteSourceA = "probeRemoteSourceA";
        String probeRemoteSourceB = "probeRemoteSourceB";
        return ruleTester.assertThat((Rule<?>)new AdaptiveReorderPartitionedJoin(ruleTester.getMetadata())).setSystemProperty("retry_policy", RetryPolicy.TASK.name()).overrideStats("buildRemoteSourceA", PlanNodeStatsEstimate.builder().setOutputRowCount(buildRowCount).build()).overrideStats("buildRemoteSourceB", PlanNodeStatsEstimate.builder().setOutputRowCount(buildRowCount).build()).overrideStats("probeRemoteSourceA", PlanNodeStatsEstimate.builder().setOutputRowCount(probeRowCount).build()).overrideStats("probeRemoteSourceB", PlanNodeStatsEstimate.builder().setOutputRowCount(probeRowCount).build()).on(p -> {
            Symbol buildSymbol = p.symbol("buildSymbol", (Type)BigintType.BIGINT);
            Symbol symbol1 = p.symbol("symbol1", (Type)BigintType.BIGINT);
            Symbol buildSymbol1 = p.symbol("buildSymbol1", (Type)BigintType.BIGINT);
            Symbol symbol11 = p.symbol("symbol11", (Type)BigintType.BIGINT);
            Symbol buildSymbol2 = p.symbol("buildSymbol2", (Type)BigintType.BIGINT);
            Symbol symbol12 = p.symbol("symbol12", (Type)BigintType.BIGINT);
            Symbol probeSymbol = p.symbol("probeSymbol", (Type)BigintType.BIGINT);
            Symbol symbol2 = p.symbol("symbol2", (Type)BigintType.BIGINT);
            Symbol probeSymbol1 = p.symbol("probeSymbol1", (Type)BigintType.BIGINT);
            Symbol symbol21 = p.symbol("symbol21", (Type)BigintType.BIGINT);
            Symbol probeSymbol2 = p.symbol("probeSymbol2", (Type)BigintType.BIGINT);
            Symbol symbol22 = p.symbol("symbol22", (Type)BigintType.BIGINT);
            return p.join(JoinType.INNER, JoinNode.DistributionType.PARTITIONED, (PlanNode)p.exchange(builder -> builder.addSource((PlanNode)p.remoteSource(new PlanNodeId(probeRemoteSourceA), (List<PlanFragmentId>)ImmutableList.of((Object)new PlanFragmentId("1")), (List<Symbol>)ImmutableList.of((Object)probeSymbol1, (Object)symbol21), Optional.empty(), ExchangeNode.Type.REPARTITION, RetryPolicy.TASK)).addInputsSet((List<Symbol>)ImmutableList.of((Object)probeSymbol1, (Object)symbol21)).addSource((PlanNode)p.remoteSource(new PlanNodeId(probeRemoteSourceB), (List<PlanFragmentId>)ImmutableList.of((Object)new PlanFragmentId("2")), (List<Symbol>)ImmutableList.of((Object)probeSymbol2, (Object)symbol22), Optional.empty(), ExchangeNode.Type.REPARTITION, RetryPolicy.TASK)).addInputsSet((List<Symbol>)ImmutableList.of((Object)probeSymbol2, (Object)symbol22)).fixedArbitraryDistributionPartitioningScheme((List<Symbol>)ImmutableList.of((Object)probeSymbol, (Object)symbol2), 2).type(ExchangeNode.Type.REPARTITION).scope(ExchangeNode.Scope.LOCAL)), (PlanNode)p.aggregation(ab -> ab.step(AggregationNode.Step.PARTIAL).singleGroupingSet(buildSymbol, symbol1).source((PlanNode)p.exchange(builder -> builder.addSource((PlanNode)p.remoteSource(new PlanNodeId(buildRemoteSourceA), (List<PlanFragmentId>)ImmutableList.of((Object)new PlanFragmentId("3")), (List<Symbol>)ImmutableList.of((Object)buildSymbol1, (Object)symbol11), Optional.empty(), ExchangeNode.Type.REPARTITION, RetryPolicy.TASK)).addInputsSet((List<Symbol>)ImmutableList.of((Object)buildSymbol1, (Object)symbol11)).addSource((PlanNode)p.remoteSource(new PlanNodeId(buildRemoteSourceB), (List<PlanFragmentId>)ImmutableList.of((Object)new PlanFragmentId("4")), (List<Symbol>)ImmutableList.of((Object)buildSymbol2, (Object)symbol12), Optional.empty(), ExchangeNode.Type.REPARTITION, RetryPolicy.TASK)).addInputsSet((List<Symbol>)ImmutableList.of((Object)buildSymbol2, (Object)symbol12)).fixedHashDistributionPartitioningScheme((List<Symbol>)ImmutableList.of((Object)buildSymbol, (Object)symbol1), (List<Symbol>)ImmutableList.of((Object)buildSymbol)).type(ExchangeNode.Type.REPARTITION).scope(ExchangeNode.Scope.LOCAL)))), new JoinNode.EquiJoinClause(probeSymbol, buildSymbol));
        });
    }

    private RuleAssert assertWithoutPartialAggAndMultipleSources(double buildRowCount, double probeRowCount) {
        RuleTester ruleTester = this.tester();
        String buildRemoteSourceA = "buildRemoteSourceA";
        String buildRemoteSourceB = "buildRemoteSourceB";
        String probeRemoteSourceA = "probeRemoteSourceA";
        String probeRemoteSourceB = "probeRemoteSourceB";
        return ruleTester.assertThat((Rule<?>)new AdaptiveReorderPartitionedJoin(ruleTester.getMetadata())).setSystemProperty("retry_policy", RetryPolicy.TASK.name()).overrideStats("buildRemoteSourceA", PlanNodeStatsEstimate.builder().setOutputRowCount(buildRowCount).build()).overrideStats("buildRemoteSourceB", PlanNodeStatsEstimate.builder().setOutputRowCount(buildRowCount).build()).overrideStats("probeRemoteSourceA", PlanNodeStatsEstimate.builder().setOutputRowCount(probeRowCount).build()).overrideStats("probeRemoteSourceB", PlanNodeStatsEstimate.builder().setOutputRowCount(probeRowCount).build()).on(p -> {
            Symbol buildSymbol = p.symbol("buildSymbol", (Type)BigintType.BIGINT);
            Symbol symbol1 = p.symbol("symbol1", (Type)BigintType.BIGINT);
            Symbol buildSymbol1 = p.symbol("buildSymbol1", (Type)BigintType.BIGINT);
            Symbol symbol11 = p.symbol("symbol11", (Type)BigintType.BIGINT);
            Symbol buildSymbol2 = p.symbol("buildSymbol2", (Type)BigintType.BIGINT);
            Symbol symbol12 = p.symbol("symbol12", (Type)BigintType.BIGINT);
            Symbol probeSymbol = p.symbol("probeSymbol", (Type)BigintType.BIGINT);
            Symbol symbol2 = p.symbol("symbol2", (Type)BigintType.BIGINT);
            Symbol probeSymbol1 = p.symbol("probeSymbol1", (Type)BigintType.BIGINT);
            Symbol symbol21 = p.symbol("symbol21", (Type)BigintType.BIGINT);
            Symbol probeSymbol2 = p.symbol("probeSymbol2", (Type)BigintType.BIGINT);
            Symbol symbol22 = p.symbol("symbol22", (Type)BigintType.BIGINT);
            return p.join(JoinType.INNER, JoinNode.DistributionType.PARTITIONED, (PlanNode)p.exchange(builder -> builder.addSource((PlanNode)p.remoteSource(new PlanNodeId(probeRemoteSourceA), (List<PlanFragmentId>)ImmutableList.of((Object)new PlanFragmentId("1")), (List<Symbol>)ImmutableList.of((Object)probeSymbol1, (Object)symbol21), Optional.empty(), ExchangeNode.Type.REPARTITION, RetryPolicy.TASK)).addInputsSet((List<Symbol>)ImmutableList.of((Object)probeSymbol1, (Object)symbol21)).addSource((PlanNode)p.remoteSource(new PlanNodeId(probeRemoteSourceB), (List<PlanFragmentId>)ImmutableList.of((Object)new PlanFragmentId("2")), (List<Symbol>)ImmutableList.of((Object)probeSymbol2, (Object)symbol22), Optional.empty(), ExchangeNode.Type.REPARTITION, RetryPolicy.TASK)).addInputsSet((List<Symbol>)ImmutableList.of((Object)probeSymbol2, (Object)symbol22)).fixedArbitraryDistributionPartitioningScheme((List<Symbol>)ImmutableList.of((Object)probeSymbol, (Object)symbol2), 2).type(ExchangeNode.Type.REPARTITION).scope(ExchangeNode.Scope.LOCAL)), (PlanNode)p.exchange(builder -> builder.addSource((PlanNode)p.remoteSource(new PlanNodeId(buildRemoteSourceA), (List<PlanFragmentId>)ImmutableList.of((Object)new PlanFragmentId("3")), (List<Symbol>)ImmutableList.of((Object)buildSymbol1, (Object)symbol11), Optional.empty(), ExchangeNode.Type.REPARTITION, RetryPolicy.TASK)).addInputsSet((List<Symbol>)ImmutableList.of((Object)buildSymbol1, (Object)symbol11)).addSource((PlanNode)p.remoteSource(new PlanNodeId(buildRemoteSourceB), (List<PlanFragmentId>)ImmutableList.of((Object)new PlanFragmentId("4")), (List<Symbol>)ImmutableList.of((Object)buildSymbol2, (Object)symbol12), Optional.empty(), ExchangeNode.Type.REPARTITION, RetryPolicy.TASK)).addInputsSet((List<Symbol>)ImmutableList.of((Object)buildSymbol2, (Object)symbol12)).fixedHashDistributionPartitioningScheme((List<Symbol>)ImmutableList.of((Object)buildSymbol, (Object)symbol1), (List<Symbol>)ImmutableList.of((Object)buildSymbol)).type(ExchangeNode.Type.REPARTITION).scope(ExchangeNode.Scope.LOCAL)), new JoinNode.EquiJoinClause(probeSymbol, buildSymbol));
        });
    }

    private RuleAssert assertWithoutPartialAgg(double buildRowCount, double probeRowCount) {
        RuleTester ruleTester = this.tester();
        String buildRemoteSourceId = "buildRemoteSourceId";
        String probeRemoteSourceId = "probeRemoteSourceId";
        return ruleTester.assertThat((Rule<?>)new AdaptiveReorderPartitionedJoin(ruleTester.getMetadata())).setSystemProperty("retry_policy", RetryPolicy.TASK.name()).overrideStats("buildRemoteSourceId", PlanNodeStatsEstimate.builder().setOutputRowCount(buildRowCount).build()).overrideStats("probeRemoteSourceId", PlanNodeStatsEstimate.builder().setOutputRowCount(probeRowCount).build()).on(p -> {
            Symbol buildSymbol = p.symbol("buildSymbol", (Type)BigintType.BIGINT);
            Symbol symbol1 = p.symbol("symbol1", (Type)BigintType.BIGINT);
            Symbol probeSymbol = p.symbol("probeSymbol", (Type)BigintType.BIGINT);
            Symbol symbol2 = p.symbol("symbol2", (Type)BigintType.BIGINT);
            return p.join(JoinType.INNER, JoinNode.DistributionType.PARTITIONED, (PlanNode)p.remoteSource(new PlanNodeId(probeRemoteSourceId), (List<PlanFragmentId>)ImmutableList.of((Object)new PlanFragmentId("1")), (List<Symbol>)ImmutableList.of((Object)probeSymbol, (Object)symbol2), Optional.empty(), ExchangeNode.Type.REPARTITION, RetryPolicy.TASK), (PlanNode)p.exchange(builder -> builder.addInputsSet(buildSymbol, symbol1).addSource((PlanNode)p.remoteSource(new PlanNodeId(buildRemoteSourceId), (List<PlanFragmentId>)ImmutableList.of((Object)new PlanFragmentId("2")), (List<Symbol>)ImmutableList.of((Object)buildSymbol, (Object)symbol1), Optional.empty(), ExchangeNode.Type.REPARTITION, RetryPolicy.TASK)).fixedHashDistributionPartitioningScheme((List<Symbol>)ImmutableList.of((Object)buildSymbol, (Object)symbol1), (List<Symbol>)ImmutableList.of((Object)buildSymbol)).type(ExchangeNode.Type.REPARTITION).scope(ExchangeNode.Scope.LOCAL)), new JoinNode.EquiJoinClause(probeSymbol, buildSymbol));
        });
    }
}

