/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.SystemSessionProperties;
import io.trino.cost.CostProvider;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.StatsProvider;
import io.trino.cost.SymbolStatsEstimate;
import io.trino.cost.TaskCountEstimator;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.AbstractMockMetadata;
import io.trino.metadata.Metadata;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.OptimizerConfig;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.iterative.Lookup;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.DistinctAggregationStrategyChooser;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.testing.TestingHandles;
import io.trino.testing.TestingSession;
import io.trino.testing.TransactionBuilder;
import io.trino.transaction.TestingTransactionManager;
import io.trino.transaction.TransactionManager;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestDistinctAggregationStrategyChooser {
    private static final int NODE_COUNT = 6;
    private static final TaskCountEstimator TASK_COUNT_ESTIMATOR = new TaskCountEstimator(() -> 6);
    private static final TestingFunctionResolution functionResolution = new TestingFunctionResolution();
    private TestingTransactionManager transactionManager;
    private Metadata metadata;

    @BeforeAll
    public final void setUp() {
        this.transactionManager = new TestingTransactionManager();
        this.metadata = new AbstractMockMetadata(this){

            @Override
            public boolean allowSplittingReadIntoMultipleSubQueries(Session session, TableHandle tableHandle) {
                return true;
            }
        };
    }

    @Test
    public void testSingleStepPreferredForHighCardinalitySingleGroupByKey() {
        DistinctAggregationStrategyChooser aggregationStrategyChooser = DistinctAggregationStrategyChooser.createDistinctAggregationStrategyChooser((TaskCountEstimator)TASK_COUNT_ESTIMATOR, (Metadata)this.metadata);
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        Symbol groupingKey = symbolAllocator.newSymbol("groupingKey", (Type)BigintType.BIGINT);
        PlanNode source = TestDistinctAggregationStrategyChooser.tableScan();
        AggregationNode aggregationNode = TestDistinctAggregationStrategyChooser.aggregationWithTwoDistinctAggregations((List<Symbol>)ImmutableList.of((Object)groupingKey), source, symbolAllocator);
        Rule.Context context = TestDistinctAggregationStrategyChooser.context((Map<PlanNode, PlanNodeStatsEstimate>)ImmutableMap.of((Object)source, (Object)new PlanNodeStatsEstimate(1000000.0, (Map)ImmutableMap.of((Object)groupingKey, (Object)SymbolStatsEstimate.builder().setDistinctValuesCount(1000000.0).build()))), symbolAllocator);
        TestDistinctAggregationStrategyChooser.assertShouldUseSingleStep(aggregationStrategyChooser, aggregationNode, context.getSession(), context.getStatsProvider(), context.getLookup());
    }

    @Test
    public void testSingleStepPreferredForHighCardinalityMultipleGroupByKeys() {
        DistinctAggregationStrategyChooser aggregationStrategyChooser = DistinctAggregationStrategyChooser.createDistinctAggregationStrategyChooser((TaskCountEstimator)TASK_COUNT_ESTIMATOR, (Metadata)this.metadata);
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        Symbol lowCardinalityGroupingKey = symbolAllocator.newSymbol("lowCardinalityGroupingKey", (Type)BigintType.BIGINT);
        Symbol highCardinalityGroupingKey = symbolAllocator.newSymbol("highCardinalityGroupingKey", (Type)BigintType.BIGINT);
        PlanNode source = TestDistinctAggregationStrategyChooser.tableScan();
        AggregationNode aggregationNode = TestDistinctAggregationStrategyChooser.aggregationWithTwoDistinctAggregations((List<Symbol>)ImmutableList.of((Object)lowCardinalityGroupingKey, (Object)highCardinalityGroupingKey), source, symbolAllocator);
        Rule.Context context = TestDistinctAggregationStrategyChooser.context((Map<PlanNode, PlanNodeStatsEstimate>)ImmutableMap.of((Object)source, (Object)new PlanNodeStatsEstimate(1000000.0, (Map)ImmutableMap.of((Object)lowCardinalityGroupingKey, (Object)SymbolStatsEstimate.builder().setDistinctValuesCount(10.0).build(), (Object)highCardinalityGroupingKey, (Object)SymbolStatsEstimate.builder().setDistinctValuesCount(1000000.0).build()))), symbolAllocator);
        TestDistinctAggregationStrategyChooser.assertShouldUseSingleStep(aggregationStrategyChooser, aggregationNode, context.getSession(), context.getStatsProvider(), context.getLookup());
    }

    @Test
    public void testPreAggregatePreferredForLowCardinality2GroupByKeys() {
        DistinctAggregationStrategyChooser aggregationStrategyChooser = DistinctAggregationStrategyChooser.createDistinctAggregationStrategyChooser((TaskCountEstimator)TASK_COUNT_ESTIMATOR, (Metadata)this.metadata);
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        ImmutableList groupingKeys = ImmutableList.of((Object)symbolAllocator.newSymbol("key1", (Type)BigintType.BIGINT), (Object)symbolAllocator.newSymbol("key2", (Type)BigintType.BIGINT));
        PlanNode source = TestDistinctAggregationStrategyChooser.tableScan();
        AggregationNode aggregationNode = TestDistinctAggregationStrategyChooser.aggregationWithTwoDistinctAggregations((List<Symbol>)groupingKeys, source, symbolAllocator);
        Rule.Context context = TestDistinctAggregationStrategyChooser.context((Map<PlanNode, PlanNodeStatsEstimate>)ImmutableMap.of((Object)source, (Object)new PlanNodeStatsEstimate(1000000.0, (Map)groupingKeys.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), symbol -> SymbolStatsEstimate.builder().setDistinctValuesCount(10.0).build())))), new SymbolAllocator());
        Assertions.assertThat((boolean)aggregationStrategyChooser.shouldUsePreAggregate(aggregationNode, context.getSession(), context.getStatsProvider(), context.getLookup())).isTrue();
        Assertions.assertThat((boolean)aggregationStrategyChooser.shouldAddMarkDistinct(aggregationNode, context.getSession(), context.getStatsProvider(), context.getLookup())).isFalse();
    }

    @Test
    public void testPreAggregatePreferredForUnknownStatisticsAnd2GroupByKeys() {
        DistinctAggregationStrategyChooser aggregationStrategyChooser = DistinctAggregationStrategyChooser.createDistinctAggregationStrategyChooser((TaskCountEstimator)TASK_COUNT_ESTIMATOR, (Metadata)this.metadata);
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        ImmutableList groupingKeys = ImmutableList.of((Object)symbolAllocator.newSymbol("key1", (Type)BigintType.BIGINT), (Object)symbolAllocator.newSymbol("key2", (Type)BigintType.BIGINT));
        PlanNode source = TestDistinctAggregationStrategyChooser.tableScan();
        AggregationNode aggregationNode = TestDistinctAggregationStrategyChooser.aggregationWithTwoDistinctAggregations((List<Symbol>)groupingKeys, source, symbolAllocator);
        Rule.Context context = TestDistinctAggregationStrategyChooser.context((Map<PlanNode, PlanNodeStatsEstimate>)ImmutableMap.of(), new SymbolAllocator());
        Assertions.assertThat((boolean)aggregationStrategyChooser.shouldUsePreAggregate(aggregationNode, context.getSession(), context.getStatsProvider(), context.getLookup())).isTrue();
        Assertions.assertThat((boolean)aggregationStrategyChooser.shouldAddMarkDistinct(aggregationNode, context.getSession(), context.getStatsProvider(), context.getLookup())).isFalse();
    }

    @Test
    public void testPreAggregatePreferredForMediumCardinalitySingleGroupByKey() {
        DistinctAggregationStrategyChooser aggregationStrategyChooser = DistinctAggregationStrategyChooser.createDistinctAggregationStrategyChooser((TaskCountEstimator)TASK_COUNT_ESTIMATOR, (Metadata)this.metadata);
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        Symbol groupingKey = symbolAllocator.newSymbol("groupingKey", (Type)BigintType.BIGINT);
        PlanNode source = TestDistinctAggregationStrategyChooser.tableScan();
        AggregationNode aggregationNode = TestDistinctAggregationStrategyChooser.aggregationWithTwoDistinctAggregations((List<Symbol>)ImmutableList.of((Object)groupingKey), source, symbolAllocator);
        Rule.Context context = TestDistinctAggregationStrategyChooser.context((Map<PlanNode, PlanNodeStatsEstimate>)ImmutableMap.of((Object)source, (Object)new PlanNodeStatsEstimate((double)(6 * SystemSessionProperties.getTaskConcurrency((Session)SessionTestUtils.TEST_SESSION) * 10), (Map)ImmutableMap.of((Object)groupingKey, (Object)SymbolStatsEstimate.builder().setDistinctValuesCount((double)(6 * SystemSessionProperties.getTaskConcurrency((Session)SessionTestUtils.TEST_SESSION) * 10)).build()))), symbolAllocator);
        Assertions.assertThat((boolean)aggregationStrategyChooser.shouldUsePreAggregate(aggregationNode, context.getSession(), context.getStatsProvider(), context.getLookup())).isTrue();
    }

    @Test
    public void testSingleStepPreferredForMediumCardinality3GroupByKeys() {
        DistinctAggregationStrategyChooser aggregationStrategyChooser = DistinctAggregationStrategyChooser.createDistinctAggregationStrategyChooser((TaskCountEstimator)TASK_COUNT_ESTIMATOR, (Metadata)this.metadata);
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        ImmutableList groupingKeys = ImmutableList.of((Object)symbolAllocator.newSymbol("key1", (Type)BigintType.BIGINT), (Object)symbolAllocator.newSymbol("key2", (Type)BigintType.BIGINT), (Object)symbolAllocator.newSymbol("key3", (Type)BigintType.BIGINT));
        PlanNode source = TestDistinctAggregationStrategyChooser.tableScan();
        AggregationNode aggregationNode = TestDistinctAggregationStrategyChooser.aggregationWithTwoDistinctAggregations((List<Symbol>)groupingKeys, source, symbolAllocator);
        Rule.Context context = TestDistinctAggregationStrategyChooser.context((Map<PlanNode, PlanNodeStatsEstimate>)ImmutableMap.of((Object)source, (Object)new PlanNodeStatsEstimate((double)(6 * SystemSessionProperties.getTaskConcurrency((Session)SessionTestUtils.TEST_SESSION) * 10), (Map)groupingKeys.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), symbol -> SymbolStatsEstimate.builder().setDistinctValuesCount((double)(6 * SystemSessionProperties.getTaskConcurrency((Session)SessionTestUtils.TEST_SESSION) * 10)).build())))), symbolAllocator);
        TestDistinctAggregationStrategyChooser.assertShouldUseSingleStep(aggregationStrategyChooser, aggregationNode, context.getSession(), context.getStatsProvider(), context.getLookup());
    }

    @Test
    public void testSplitToSubqueriesPreferredForGlobalAggregation() {
        DistinctAggregationStrategyChooser aggregationStrategyChooser = DistinctAggregationStrategyChooser.createDistinctAggregationStrategyChooser((TaskCountEstimator)TASK_COUNT_ESTIMATOR, (Metadata)this.metadata);
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        PlanNode source = TestDistinctAggregationStrategyChooser.tableScan();
        AggregationNode aggregationNode = TestDistinctAggregationStrategyChooser.aggregationWithTwoDistinctAggregations((List<Symbol>)ImmutableList.of(), source, symbolAllocator);
        Assertions.assertThat((boolean)this.inTransaction(session -> {
            Rule.Context context = TestDistinctAggregationStrategyChooser.context((Map<PlanNode, PlanNodeStatsEstimate>)ImmutableMap.of((Object)source, (Object)new PlanNodeStatsEstimate(1000000.0, (Map)ImmutableMap.of())), session, symbolAllocator);
            return aggregationStrategyChooser.shouldSplitToSubqueries(aggregationNode, context.getSession(), context.getStatsProvider(), context.getLookup());
        })).isTrue();
    }

    @Test
    public void testMarkDistinctPreferredForLowCardinality3GroupByKeys() {
        DistinctAggregationStrategyChooser aggregationStrategyChooser = DistinctAggregationStrategyChooser.createDistinctAggregationStrategyChooser((TaskCountEstimator)TASK_COUNT_ESTIMATOR, (Metadata)this.metadata);
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        ImmutableList groupingKeys = ImmutableList.of((Object)symbolAllocator.newSymbol("key1", (Type)BigintType.BIGINT), (Object)symbolAllocator.newSymbol("key2", (Type)BigintType.BIGINT), (Object)symbolAllocator.newSymbol("key3", (Type)BigintType.BIGINT));
        PlanNode source = TestDistinctAggregationStrategyChooser.tableScan();
        AggregationNode aggregationNode = TestDistinctAggregationStrategyChooser.aggregationWithTwoDistinctAggregations((List<Symbol>)groupingKeys, source, symbolAllocator);
        Rule.Context context = TestDistinctAggregationStrategyChooser.context((Map<PlanNode, PlanNodeStatsEstimate>)ImmutableMap.of((Object)source, (Object)new PlanNodeStatsEstimate(1000000.0, (Map)groupingKeys.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), symbol -> SymbolStatsEstimate.builder().setDistinctValuesCount(10.0).build())))), new SymbolAllocator());
        Assertions.assertThat((boolean)aggregationStrategyChooser.shouldAddMarkDistinct(aggregationNode, context.getSession(), context.getStatsProvider(), context.getLookup())).isTrue();
    }

    @Test
    public void testMarkDistinctPreferredForUnknownStatisticsAnd3GroupByKeys() {
        DistinctAggregationStrategyChooser aggregationStrategyChooser = DistinctAggregationStrategyChooser.createDistinctAggregationStrategyChooser((TaskCountEstimator)TASK_COUNT_ESTIMATOR, (Metadata)this.metadata);
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        ImmutableList groupingKeys = ImmutableList.of((Object)symbolAllocator.newSymbol("key1", (Type)BigintType.BIGINT), (Object)symbolAllocator.newSymbol("key2", (Type)BigintType.BIGINT), (Object)symbolAllocator.newSymbol("key3", (Type)BigintType.BIGINT));
        PlanNode source = TestDistinctAggregationStrategyChooser.tableScan();
        AggregationNode aggregationNode = TestDistinctAggregationStrategyChooser.aggregationWithTwoDistinctAggregations((List<Symbol>)groupingKeys, source, symbolAllocator);
        Assertions.assertThat((boolean)this.inTransaction(session -> {
            Rule.Context context = TestDistinctAggregationStrategyChooser.context((Map<PlanNode, PlanNodeStatsEstimate>)ImmutableMap.of(), session, symbolAllocator);
            return aggregationStrategyChooser.shouldAddMarkDistinct(aggregationNode, context.getSession(), context.getStatsProvider(), context.getLookup());
        })).isTrue();
    }

    @Test
    public void testChoiceForcedByTheSessionProperty() {
        int clusterThreadCount = 6 * SystemSessionProperties.getTaskConcurrency((Session)SessionTestUtils.TEST_SESSION);
        DistinctAggregationStrategyChooser aggregationStrategyChooser = DistinctAggregationStrategyChooser.createDistinctAggregationStrategyChooser((TaskCountEstimator)TASK_COUNT_ESTIMATOR, (Metadata)this.metadata);
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        Symbol groupingKey = symbolAllocator.newSymbol("groupingKey", (Type)BigintType.BIGINT);
        TableScanNode source = new TableScanNode(new PlanNodeId("source"), TestingHandles.TEST_TABLE_HANDLE, (List)ImmutableList.of(), (Map)ImmutableMap.of(), TupleDomain.all(), Optional.empty(), false, Optional.empty());
        AggregationNode aggregationNode = TestDistinctAggregationStrategyChooser.aggregationWithTwoDistinctAggregations((List<Symbol>)ImmutableList.of((Object)groupingKey), (PlanNode)source, symbolAllocator);
        Assertions.assertThat((boolean)this.inTransaction(TestingSession.testSessionBuilder().setSystemProperty("distinct_aggregations_strategy", OptimizerConfig.DistinctAggregationsStrategy.MARK_DISTINCT.name()).build(), session -> {
            Rule.Context context = TestDistinctAggregationStrategyChooser.context((Map<PlanNode, PlanNodeStatsEstimate>)ImmutableMap.of((Object)source, (Object)new PlanNodeStatsEstimate((double)(1000 * clusterThreadCount), (Map)ImmutableMap.of((Object)groupingKey, (Object)SymbolStatsEstimate.builder().setDistinctValuesCount((double)(1000 * clusterThreadCount)).build()))), session, symbolAllocator);
            return aggregationStrategyChooser.shouldAddMarkDistinct(aggregationNode, context.getSession(), context.getStatsProvider(), context.getLookup());
        })).isTrue();
        Assertions.assertThat((boolean)this.inTransaction(TestingSession.testSessionBuilder().setSystemProperty("distinct_aggregations_strategy", OptimizerConfig.DistinctAggregationsStrategy.PRE_AGGREGATE.name()).build(), session -> {
            Rule.Context context = TestDistinctAggregationStrategyChooser.context((Map<PlanNode, PlanNodeStatsEstimate>)ImmutableMap.of((Object)source, (Object)new PlanNodeStatsEstimate((double)(1000 * clusterThreadCount), (Map)ImmutableMap.of((Object)groupingKey, (Object)SymbolStatsEstimate.builder().setDistinctValuesCount((double)(1000 * clusterThreadCount)).build()))), session, symbolAllocator);
            return aggregationStrategyChooser.shouldUsePreAggregate(aggregationNode, context.getSession(), context.getStatsProvider(), context.getLookup());
        })).isTrue();
        Rule.Context smallNdvContext = TestDistinctAggregationStrategyChooser.context((Map<PlanNode, PlanNodeStatsEstimate>)ImmutableMap.of((Object)source, (Object)new PlanNodeStatsEstimate((double)(1000 * clusterThreadCount), (Map)ImmutableMap.of((Object)groupingKey, (Object)SymbolStatsEstimate.builder().setDistinctValuesCount((double)(1000 * clusterThreadCount)).build()))), TestingSession.testSessionBuilder().setSystemProperty("distinct_aggregations_strategy", OptimizerConfig.DistinctAggregationsStrategy.SINGLE_STEP.name()).build(), symbolAllocator);
        TestDistinctAggregationStrategyChooser.assertShouldUseSingleStep(aggregationStrategyChooser, aggregationNode, smallNdvContext.getSession(), smallNdvContext.getStatsProvider(), smallNdvContext.getLookup());
        Assertions.assertThat((boolean)this.inTransaction(TestingSession.testSessionBuilder().setSystemProperty("distinct_aggregations_strategy", OptimizerConfig.DistinctAggregationsStrategy.SPLIT_TO_SUBQUERIES.name()).build(), session -> {
            Rule.Context context = TestDistinctAggregationStrategyChooser.context((Map<PlanNode, PlanNodeStatsEstimate>)ImmutableMap.of((Object)source, (Object)new PlanNodeStatsEstimate((double)(1000 * clusterThreadCount), (Map)ImmutableMap.of((Object)groupingKey, (Object)SymbolStatsEstimate.builder().setDistinctValuesCount((double)(1000 * clusterThreadCount)).build()))), session, symbolAllocator);
            return aggregationStrategyChooser.shouldSplitToSubqueries(aggregationNode, context.getSession(), context.getStatsProvider(), context.getLookup());
        })).isTrue();
    }

    private <T> T inTransaction(Function<Session, T> callback) {
        return this.inTransaction(SessionTestUtils.TEST_SESSION, callback);
    }

    private <T> T inTransaction(Session session, Function<Session, T> callback) {
        return (T)TransactionBuilder.transaction((TransactionManager)this.transactionManager, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl()).execute(session, callback);
    }

    private static PlanNode tableScan() {
        return new TableScanNode(new PlanNodeId("source"), TestingHandles.TEST_TABLE_HANDLE, (List)ImmutableList.of(), (Map)ImmutableMap.of(), TupleDomain.all(), Optional.empty(), false, Optional.empty());
    }

    private static AggregationNode aggregationWithTwoDistinctAggregations(List<Symbol> groupingKeys, PlanNode source, SymbolAllocator symbolAllocator) {
        return AggregationNode.singleAggregation((PlanNodeId)new PlanNodeId("aggregation"), (PlanNode)source, TestDistinctAggregationStrategyChooser.twoDistinctAggregations(symbolAllocator), (AggregationNode.GroupingSetDescriptor)AggregationNode.singleGroupingSet(groupingKeys));
    }

    private static Map<Symbol, AggregationNode.Aggregation> twoDistinctAggregations(SymbolAllocator symbolAllocator) {
        return ImmutableMap.of((Object)symbolAllocator.newSymbol("output1", (Type)BigintType.BIGINT), (Object)new AggregationNode.Aggregation(functionResolution.resolveFunction("sum", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT})), (List)ImmutableList.of((Object)symbolAllocator.newSymbol("input1", (Type)BigintType.BIGINT).toSymbolReference()), true, Optional.empty(), Optional.empty(), Optional.empty()), (Object)symbolAllocator.newSymbol("output2", (Type)BigintType.BIGINT), (Object)new AggregationNode.Aggregation(functionResolution.resolveFunction("sum", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT})), (List)ImmutableList.of((Object)symbolAllocator.newSymbol("input2", (Type)BigintType.BIGINT).toSymbolReference()), true, Optional.empty(), Optional.empty(), Optional.empty()));
    }

    private static void assertShouldUseSingleStep(DistinctAggregationStrategyChooser aggregationStrategyChooser, AggregationNode aggregationNode, Session session, StatsProvider statsProvider, Lookup lookup) {
        Assertions.assertThat((boolean)aggregationStrategyChooser.shouldAddMarkDistinct(aggregationNode, session, statsProvider, lookup)).isFalse();
        Assertions.assertThat((boolean)aggregationStrategyChooser.shouldUsePreAggregate(aggregationNode, session, statsProvider, lookup)).isFalse();
    }

    private static Rule.Context context(Map<PlanNode, PlanNodeStatsEstimate> stats, SymbolAllocator symbolAllocator) {
        return TestDistinctAggregationStrategyChooser.context(stats, SessionTestUtils.TEST_SESSION, symbolAllocator);
    }

    private static Rule.Context context(final Map<PlanNode, PlanNodeStatsEstimate> stats, final Session session, final SymbolAllocator symbolAllocator) {
        final PlanNodeIdAllocator planNodeIdAllocator = new PlanNodeIdAllocator();
        return new Rule.Context(){

            public Lookup getLookup() {
                return Lookup.noLookup();
            }

            public PlanNodeIdAllocator getIdAllocator() {
                return planNodeIdAllocator;
            }

            public SymbolAllocator getSymbolAllocator() {
                return symbolAllocator;
            }

            public Session getSession() {
                return session;
            }

            public StatsProvider getStatsProvider() {
                return node -> stats.getOrDefault(node, PlanNodeStatsEstimate.unknown());
            }

            public CostProvider getCostProvider() {
                throw new UnsupportedOperationException();
            }

            public void checkTimeoutNotExhausted() {
                throw new UnsupportedOperationException();
            }

            public WarningCollector getWarningCollector() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

