/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.GatherPartialTopN;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TopNNode;
import io.trino.sql.tree.SortItem;
import java.util.List;
import org.junit.jupiter.api.Test;

public class TestGatherPartialTopN
extends BaseRuleTest {
    public TestGatherPartialTopN() {
        super(new Plugin[0]);
    }

    @Test
    public void testPartialTopNGather() {
        this.tester().assertThat((Rule<?>)new GatherPartialTopN()).on(p -> {
            Symbol orderBy = p.symbol("a");
            return p.exchange(exchange -> exchange.scope(ExchangeNode.Scope.REMOTE).singleDistributionPartitioningScheme(orderBy).addInputsSet(orderBy).addSource((PlanNode)p.topN(10L, (List<Symbol>)ImmutableList.of((Object)orderBy), TopNNode.Step.PARTIAL, (PlanNode)p.values(orderBy))));
        }).matches(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, PlanMatchPattern.topN(10L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("a", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), TopNNode.Step.PARTIAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.topN(10L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("a", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), TopNNode.Step.PARTIAL, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION, PlanMatchPattern.topN(10L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("a", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), TopNNode.Step.PARTIAL, PlanMatchPattern.values("a"))))))));
    }

    @Test
    public void testRuleDoesNotFireTwice() {
        this.tester().assertThat((Rule<?>)new GatherPartialTopN()).on(p -> {
            Symbol orderBy = p.symbol("a");
            return p.exchange(exchange -> exchange.scope(ExchangeNode.Scope.REMOTE).singleDistributionPartitioningScheme(orderBy).addInputsSet(orderBy).addSource((PlanNode)p.topN(10L, (List<Symbol>)ImmutableList.of((Object)orderBy), TopNNode.Step.PARTIAL, (PlanNode)p.exchange(localExchange -> localExchange.scope(ExchangeNode.Scope.LOCAL).type(ExchangeNode.Type.GATHER).singleDistributionPartitioningScheme(orderBy).addInputsSet(orderBy).addSource((PlanNode)p.topN(10L, (List<Symbol>)ImmutableList.of((Object)orderBy), TopNNode.Step.PARTIAL, (PlanNode)p.values(orderBy)))))));
        }).doesNotFire();
    }
}

