/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.Plugin;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FieldReference;
import io.trino.sql.ir.Lambda;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.InlineProjections;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.type.FunctionType;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestInlineProjections
extends BaseRuleTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction ADD_INTEGER = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final ResolvedFunction SUBTRACT_INTEGER = FUNCTIONS.resolveOperator(OperatorType.SUBTRACT, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final ResolvedFunction MULTIPLY_INTEGER = FUNCTIONS.resolveOperator(OperatorType.MULTIPLY, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));
    private static final ResolvedFunction ADD_DECIMAL_8_4 = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)DecimalType.createDecimalType((int)8, (int)4), (Object)DecimalType.createDecimalType((int)8, (int)4)));
    private static final ResolvedFunction MULTIPLY_DECIMAL_8_4 = FUNCTIONS.resolveOperator(OperatorType.MULTIPLY, (List<? extends Type>)ImmutableList.of((Object)DecimalType.createDecimalType((int)8, (int)4), (Object)DecimalType.createDecimalType((int)8, (int)4)));
    private static final RowType MSG_TYPE = RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("x"), (Type)IntegerType.INTEGER), (Object)new RowType.Field(Optional.of("y"), (Type)IntegerType.INTEGER)));

    public TestInlineProjections() {
        super(new Plugin[0]);
    }

    @Test
    public void test() {
        this.tester().assertThat((Rule<?>)new InlineProjections()).on(p -> p.project(Assignments.builder().put(p.symbol("identity", (Type)IntegerType.INTEGER), (Expression)new Reference((Type)IntegerType.INTEGER, "symbol")).put(p.symbol("multi_complex_1", (Type)IntegerType.INTEGER), (Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "complex"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)))).put(p.symbol("multi_complex_2", (Type)IntegerType.INTEGER), (Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "complex"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L)))).put(p.symbol("multi_literal_1", (Type)IntegerType.INTEGER), (Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "literal"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)))).put(p.symbol("multi_literal_2", (Type)IntegerType.INTEGER), (Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "literal"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L)))).put(p.symbol("single_complex", (Type)IntegerType.INTEGER), (Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "complex_2"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L)))).put(p.symbol("msg_xx", (Type)IntegerType.INTEGER), (Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "z"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)))).put(p.symbol("multi_symbol_reference", (Type)IntegerType.INTEGER), (Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "v"), (Object)new Reference((Type)IntegerType.INTEGER, "v")))).build(), (PlanNode)p.project(Assignments.builder().put(p.symbol("symbol", (Type)IntegerType.INTEGER), (Expression)new Reference((Type)IntegerType.INTEGER, "x")).put(p.symbol("complex", (Type)IntegerType.INTEGER), (Expression)new Call(MULTIPLY_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "x"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L)))).put(p.symbol("literal", (Type)IntegerType.INTEGER), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)).put(p.symbol("complex_2", (Type)IntegerType.INTEGER), (Expression)new Call(SUBTRACT_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "x"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)))).put(p.symbol("z", ((RowType.Field)MSG_TYPE.getFields().get(0)).getType()), (Expression)new FieldReference((Expression)new Reference((Type)MSG_TYPE, "msg"), 0)).put(p.symbol("v", (Type)IntegerType.INTEGER), (Expression)new Reference((Type)IntegerType.INTEGER, "x")).build(), (PlanNode)p.values(p.symbol("x", (Type)IntegerType.INTEGER), p.symbol("msg", (Type)MSG_TYPE))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"out1", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)IntegerType.INTEGER, "x"))).put((Object)"out2", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "y"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))))).put((Object)"out3", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "y"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L))))).put((Object)"out4", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))))).put((Object)"out5", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L))))).put((Object)"out6", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Call(SUBTRACT_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "x"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L))))).put((Object)"out8", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "z"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))))).put((Object)"out10", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "x"), (Object)new Reference((Type)IntegerType.INTEGER, "x"))))).buildOrThrow(), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"x", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)IntegerType.INTEGER, "x")), (Object)"y", (Object)PlanMatchPattern.expression((Expression)new Call(MULTIPLY_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "x"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L)))), (Object)"z", (Object)PlanMatchPattern.expression((Expression)new FieldReference((Expression)new Reference((Type)MSG_TYPE, "msg"), 0))), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"x", (Object)0, (Object)"msg", (Object)1)))));
    }

    @Test
    public void testInlineEffectivelyLiteral() {
        this.tester().assertThat((Rule<?>)new InlineProjections()).on(p -> p.project(Assignments.builder().put(p.symbol("decimal_multiplication", (Type)DecimalType.createDecimalType((int)16, (int)8)), (Expression)new Call(MULTIPLY_DECIMAL_8_4, (List)ImmutableList.of((Object)new Reference((Type)DecimalType.createDecimalType((int)8, (int)4), "decimal_literal"), (Object)new Reference((Type)DecimalType.createDecimalType((int)8, (int)4), "decimal_literal")))).put(p.symbol("decimal_addition", (Type)DecimalType.createDecimalType((int)9, (int)4)), (Expression)new Call(ADD_DECIMAL_8_4, (List)ImmutableList.of((Object)new Reference((Type)DecimalType.createDecimalType((int)8, (int)4), "decimal_literal"), (Object)new Reference((Type)DecimalType.createDecimalType((int)8, (int)4), "decimal_literal")))).build(), (PlanNode)p.project(Assignments.builder().put(p.symbol("decimal_literal", (Type)DecimalType.createDecimalType((int)8, (int)4)), (Expression)new Constant((Type)DecimalType.createDecimalType((int)8, (int)4), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("12.5")))).build(), (PlanNode)p.values(p.symbol("x"))))).matches(PlanMatchPattern.project(Map.of("decimal_multiplication", PlanMatchPattern.expression((Expression)new Call(MULTIPLY_DECIMAL_8_4, (List)ImmutableList.of((Object)new Constant((Type)DecimalType.createDecimalType((int)8, (int)4), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("12.5"))), (Object)new Constant((Type)DecimalType.createDecimalType((int)8, (int)4), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("12.5")))))), "decimal_addition", PlanMatchPattern.expression((Expression)new Call(ADD_DECIMAL_8_4, (List)ImmutableList.of((Object)new Constant((Type)DecimalType.createDecimalType((int)8, (int)4), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("12.5"))), (Object)new Constant((Type)DecimalType.createDecimalType((int)8, (int)4), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("12.5"))))))), PlanMatchPattern.values(Map.of("x", 0))));
    }

    @Test
    public void testEliminatesIdentityProjection() {
        this.tester().assertThat((Rule<?>)new InlineProjections()).on(p -> p.project(Assignments.builder().put(p.symbol("single_complex", (Type)IntegerType.INTEGER), (Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "complex"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L)))).build(), (PlanNode)p.project(Assignments.builder().put(p.symbol("complex", (Type)IntegerType.INTEGER), (Expression)new Call(SUBTRACT_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "x"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)))).build(), (PlanNode)p.values(p.symbol("x", (Type)IntegerType.INTEGER))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"out1", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Call(SUBTRACT_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "x"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L))), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L))))), PlanMatchPattern.values("x")));
    }

    @Test
    public void testInlineLambda() {
        this.tester().assertThat((Rule<?>)new InlineProjections()).on(p -> p.project(Assignments.of((Symbol)p.symbol("complex", (Type)IntegerType.INTEGER), (Expression)new Reference((Type)IntegerType.INTEGER, "complex"), (Symbol)p.symbol("output", (Type)new FunctionType((List)ImmutableList.of((Object)BigintType.BIGINT), (Type)IntegerType.INTEGER)), (Expression)new Lambda((List)ImmutableList.of((Object)p.symbol("arg")), (Expression)new Call(ADD_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "arg"), (Object)new Reference((Type)IntegerType.INTEGER, "complex"))))), (PlanNode)p.project(Assignments.builder().put(p.symbol("complex", (Type)IntegerType.INTEGER), (Expression)new Call(SUBTRACT_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "x"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)))).build(), (PlanNode)p.values(p.symbol("x", (Type)IntegerType.INTEGER))))).doesNotFire();
    }

    @Test
    public void testIdentityProjections() {
        this.tester().assertThat((Rule<?>)new InlineProjections()).on(p -> p.project(Assignments.of((Symbol)p.symbol("output"), (Expression)new Reference((Type)BigintType.BIGINT, "value")), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("value")}), (PlanNode)p.values(p.symbol("value"))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new InlineProjections()).on(p -> p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("x")}), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("x"), p.symbol("y")}), (PlanNode)p.values(p.symbol("x"), p.symbol("y"))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"x", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "x"))), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"x", (Object)0, (Object)"y", (Object)1))));
    }

    @Test
    public void testSubqueryProjections() {
        this.tester().assertThat((Rule<?>)new InlineProjections()).on(p -> p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("fromOuterScope"), p.symbol("value")}), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("value")}), (PlanNode)p.values(p.symbol("value"))))).matches(PlanMatchPattern.project(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"value", (Object)0))));
        this.tester().assertThat((Rule<?>)new InlineProjections()).on(p -> p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("fromOuterScope"), p.symbol("value_1", (Type)IntegerType.INTEGER)}), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("value_1", (Type)IntegerType.INTEGER), (Expression)new Call(SUBTRACT_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "value"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)))), (PlanNode)p.values(p.symbol("value"))))).matches(PlanMatchPattern.project(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"value", (Object)0))));
    }
}

