/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.testing.Closeables;
import io.trino.Session;
import io.trino.cost.CachingCostProvider;
import io.trino.cost.CachingStatsProvider;
import io.trino.cost.CachingTableStatsProvider;
import io.trino.cost.CostComparator;
import io.trino.cost.CostProvider;
import io.trino.cost.PlanCostEstimate;
import io.trino.cost.RuntimeInfoProvider;
import io.trino.cost.StatsProvider;
import io.trino.cost.TableStatsProvider;
import io.trino.execution.warnings.WarningCollector;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Expression;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.iterative.Lookup;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ReorderJoins;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.testing.PlanTester;
import io.trino.testing.TestingSession;
import java.io.Closeable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestJoinEnumerator {
    private PlanTester planTester;

    @BeforeAll
    public void setUp() {
        this.planTester = PlanTester.create((Session)TestingSession.testSessionBuilder().build());
    }

    @AfterAll
    public void tearDown() {
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.planTester});
        this.planTester = null;
    }

    @Test
    public void testGeneratePartitions() {
        Assertions.assertThat((Collection)ReorderJoins.JoinEnumerator.generatePartitions((int)4)).isEqualTo((Object)ImmutableSet.of((Object)ImmutableSet.of((Object)0), (Object)ImmutableSet.of((Object)0, (Object)1), (Object)ImmutableSet.of((Object)0, (Object)2), (Object)ImmutableSet.of((Object)0, (Object)3), (Object)ImmutableSet.of((Object)0, (Object)1, (Object)2), (Object)ImmutableSet.of((Object)0, (Object)1, (Object)3), (Object[])new ImmutableSet[]{ImmutableSet.of((Object)0, (Object)2, (Object)3)}));
        Assertions.assertThat((Collection)ReorderJoins.JoinEnumerator.generatePartitions((int)3)).isEqualTo((Object)ImmutableSet.of((Object)ImmutableSet.of((Object)0), (Object)ImmutableSet.of((Object)0, (Object)1), (Object)ImmutableSet.of((Object)0, (Object)2)));
    }

    @Test
    public void testDoesNotCreateJoinWhenPartitionedOnCrossJoin() {
        PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
        PlanBuilder p = new PlanBuilder(idAllocator, this.planTester.getPlannerContext(), this.planTester.getDefaultSession());
        Symbol a1 = p.symbol("A1");
        Symbol b1 = p.symbol("B1");
        ReorderJoins.MultiJoinNode multiJoinNode = new ReorderJoins.MultiJoinNode(new LinkedHashSet(ImmutableList.of((Object)p.values(a1), (Object)p.values(b1))), (Expression)Booleans.TRUE, (List)ImmutableList.of((Object)a1, (Object)b1), false);
        ReorderJoins.JoinEnumerator joinEnumerator = new ReorderJoins.JoinEnumerator(new CostComparator(1.0, 1.0, 1.0), multiJoinNode.getFilter(), this.createContext(), this.planTester.getPlannerContext());
        ReorderJoins.JoinEnumerationResult actual = joinEnumerator.createJoinAccordingToPartitioning(multiJoinNode.getSources(), (Set)ImmutableSet.copyOf((Collection)multiJoinNode.getOutputSymbols()), (Set)ImmutableSet.of((Object)0));
        Assertions.assertThat((Optional)actual.getPlanNode()).isEmpty();
        Assertions.assertThat((Object)actual.getCost()).isEqualTo((Object)PlanCostEstimate.infinite());
    }

    private Rule.Context createContext() {
        final PlanNodeIdAllocator planNodeIdAllocator = new PlanNodeIdAllocator();
        final SymbolAllocator symbolAllocator = new SymbolAllocator();
        final CachingStatsProvider statsProvider = new CachingStatsProvider(this.planTester.getStatsCalculator(), Optional.empty(), Lookup.noLookup(), this.planTester.getDefaultSession(), (TableStatsProvider)new CachingTableStatsProvider(this.planTester.getPlannerContext().getMetadata(), this.planTester.getDefaultSession()), RuntimeInfoProvider.noImplementation());
        final CachingCostProvider costProvider = new CachingCostProvider(this.planTester.getCostCalculator(), (StatsProvider)statsProvider, Optional.empty(), this.planTester.getDefaultSession());
        return new Rule.Context(){
            final /* synthetic */ TestJoinEnumerator this$0;
            {
                this.this$0 = this$0;
            }

            public Lookup getLookup() {
                return Lookup.noLookup();
            }

            public PlanNodeIdAllocator getIdAllocator() {
                return planNodeIdAllocator;
            }

            public SymbolAllocator getSymbolAllocator() {
                return symbolAllocator;
            }

            public Session getSession() {
                return this.this$0.planTester.getDefaultSession();
            }

            public StatsProvider getStatsProvider() {
                return statsProvider;
            }

            public CostProvider getCostProvider() {
                return costProvider;
            }

            public void checkTimeoutNotExhausted() {
            }

            public WarningCollector getWarningCollector() {
                return WarningCollector.NOOP;
            }
        };
    }
}

