/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.AggregationFunction;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneAggregationSourceColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.junit.jupiter.api.Test;

public class TestPruneAggregationSourceColumns
extends BaseRuleTest {
    public TestPruneAggregationSourceColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testNotAllInputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneAggregationSourceColumns()).on(p -> this.buildAggregation((PlanBuilder)p, (Predicate<Symbol>)Predicates.alwaysTrue())).matches(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("key"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("avg"), PlanMatchPattern.aggregationFunction("avg", (List<String>)ImmutableList.of((Object)"input"))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"mask"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"input", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "input")), (Object)"key", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "key")), (Object)"keyHash", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "keyHash")), (Object)"mask", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BooleanType.BOOLEAN, "mask"))), PlanMatchPattern.values("input", "key", "keyHash", "mask", "unused"))));
    }

    @Test
    public void testAllInputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneAggregationSourceColumns()).on(p -> this.buildAggregation((PlanBuilder)p, symbol -> !symbol.name().equals("unused"))).doesNotFire();
    }

    private AggregationNode buildAggregation(PlanBuilder planBuilder, Predicate<Symbol> sourceSymbolFilter) {
        Symbol avg = planBuilder.symbol("avg");
        Symbol input = planBuilder.symbol("input");
        Symbol key = planBuilder.symbol("key");
        Symbol keyHash = planBuilder.symbol("keyHash");
        Symbol mask = planBuilder.symbol("mask");
        Symbol unused = planBuilder.symbol("unused");
        ImmutableList sourceSymbols = ImmutableList.of((Object)input, (Object)key, (Object)keyHash, (Object)mask, (Object)unused);
        return planBuilder.aggregation(arg_0 -> TestPruneAggregationSourceColumns.lambda$buildAggregation$3(key, avg, mask, keyHash, planBuilder, (List)sourceSymbols, sourceSymbolFilter, arg_0));
    }

    private static /* synthetic */ void lambda$buildAggregation$3(Symbol key, Symbol avg, Symbol mask, Symbol keyHash, PlanBuilder planBuilder, List sourceSymbols, Predicate sourceSymbolFilter, PlanBuilder.AggregationBuilder aggregationBuilder) {
        aggregationBuilder.singleGroupingSet(key).addAggregation(avg, PlanBuilder.aggregation("avg", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), mask).hashSymbol(keyHash).source((PlanNode)planBuilder.values((List)sourceSymbols.stream().filter(sourceSymbolFilter).collect(ImmutableList.toImmutableList()), (List<List<Expression>>)ImmutableList.of()));
    }
}

