/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.spi.Plugin;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.AggregationFunction;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneOrderByInAggregation;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.SortItem;
import io.trino.type.UnknownType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestPruneOrderByInAggregation
extends BaseRuleTest {
    private static final Metadata METADATA = MetadataManager.createTestMetadataManager();

    public TestPruneOrderByInAggregation() {
        super(new Plugin[0]);
    }

    @Test
    public void testBasics() {
        this.tester().assertThat((Rule<?>)new PruneOrderByInAggregation(METADATA)).on(this::buildAggregation).matches(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("key"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("avg"), PlanMatchPattern.aggregationFunction("avg", (List<String>)ImmutableList.of((Object)"input")), Optional.of("array_agg"), PlanMatchPattern.aggregationFunction("array_agg", (List<String>)ImmutableList.of((Object)"input"), (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("input", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST)))), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"mask"), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.values("input", "key", "keyHash", "mask")));
    }

    private AggregationNode buildAggregation(PlanBuilder planBuilder) {
        Symbol avg = planBuilder.symbol("avg");
        Symbol arrayAgg = planBuilder.symbol("array_agg");
        Symbol input = planBuilder.symbol("input");
        Symbol key = planBuilder.symbol("key");
        Symbol keyHash = planBuilder.symbol("keyHash");
        Symbol mask = planBuilder.symbol("mask");
        ImmutableList sourceSymbols = ImmutableList.of((Object)input, (Object)key, (Object)keyHash, (Object)mask);
        return planBuilder.aggregation(arg_0 -> TestPruneOrderByInAggregation.lambda$buildAggregation$0(key, avg, mask, arrayAgg, keyHash, planBuilder, (List)sourceSymbols, arg_0));
    }

    private static /* synthetic */ void lambda$buildAggregation$0(Symbol key, Symbol avg, Symbol mask, Symbol arrayAgg, Symbol keyHash, PlanBuilder planBuilder, List sourceSymbols, PlanBuilder.AggregationBuilder aggregationBuilder) {
        aggregationBuilder.singleGroupingSet(key).addAggregation(avg, PlanBuilder.aggregation("avg", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input")), new OrderingScheme((List)ImmutableList.of((Object)new Symbol((Type)UnknownType.UNKNOWN, "input")), (Map)ImmutableMap.of((Object)new Symbol((Type)UnknownType.UNKNOWN, "input"), (Object)SortOrder.ASC_NULLS_LAST))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), mask).addAggregation(arrayAgg, PlanBuilder.aggregation("array_agg", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "input")), new OrderingScheme((List)ImmutableList.of((Object)new Symbol((Type)UnknownType.UNKNOWN, "input")), (Map)ImmutableMap.of((Object)new Symbol((Type)UnknownType.UNKNOWN, "input"), (Object)SortOrder.ASC_NULLS_LAST))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), mask).hashSymbol(keyHash).source((PlanNode)planBuilder.values(sourceSymbols, (List<List<Expression>>)ImmutableList.of()));
    }
}

