/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneTableFunctionProcessorSourceColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableFunctionNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestPruneTableFunctionProcessorSourceColumns
extends BaseRuleTest {
    public TestPruneTableFunctionProcessorSourceColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testPruneUnreferencedSymbol() {
        this.tester().assertThat((Rule<?>)new PruneTableFunctionProcessorSourceColumns()).on(p -> {
            Symbol proper = p.symbol("proper");
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            Symbol unreferenced = p.symbol("unreferenced");
            Symbol hash = p.symbol("hash");
            Symbol marker = p.symbol("marker");
            return p.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs(proper).passThroughSpecifications(new TableFunctionNode.PassThroughSpecification(true, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(a, false)))).requiredSymbols((List<List<Symbol>>)ImmutableList.of((Object)ImmutableList.of((Object)b))).markerSymbols((Map<Symbol, Symbol>)ImmutableMap.of((Object)a, (Object)marker, (Object)b, (Object)marker, (Object)c, (Object)marker, (Object)d, (Object)marker, (Object)unreferenced, (Object)marker)).specification(new DataOrganizationSpecification((List)ImmutableList.of((Object)c), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)d), (Map)ImmutableMap.of((Object)d, (Object)SortOrder.ASC_NULLS_FIRST))))).hashSymbol(hash).source((PlanNode)p.values(a, b, c, d, unreferenced, hash, marker)));
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").properOutputs((List<String>)ImmutableList.of((Object)"proper")).passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"a"))).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"b"))).markerSymbols((Map<String, String>)ImmutableMap.of((Object)"a", (Object)"marker", (Object)"b", (Object)"marker", (Object)"c", (Object)"marker", (Object)"d", (Object)"marker")).specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of((Object)"d"), (Map<String, SortOrder>)ImmutableMap.of((Object)"d", (Object)SortOrder.ASC_NULLS_FIRST))).hashSymbol("hash"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "a")), (Object)"b", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "b")), (Object)"c", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "c")), (Object)"d", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "d")), (Object)"hash", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "hash")), (Object)"marker", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "marker"))), PlanMatchPattern.values("a", "b", "c", "d", "unreferenced", "hash", "marker"))));
    }

    @Test
    public void testPruneUnusedMarkerSymbol() {
        this.tester().assertThat((Rule<?>)new PruneTableFunctionProcessorSourceColumns()).on(p -> {
            Symbol unreferenced = p.symbol("unreferenced");
            Symbol marker = p.symbol("marker");
            return p.tableFunctionProcessor(builder -> builder.name("test_function").markerSymbols((Map<Symbol, Symbol>)ImmutableMap.of((Object)unreferenced, (Object)marker)).source((PlanNode)p.values(unreferenced, marker)));
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").markerSymbols((Map<String, String>)ImmutableMap.of()), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.values("unreferenced", "marker"))));
    }

    @Test
    public void testMultipleSources() {
        this.tester().assertThat((Rule<?>)new PruneTableFunctionProcessorSourceColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            Symbol e = p.symbol("e");
            Symbol f = p.symbol("f");
            Symbol marker1 = p.symbol("marker1");
            Symbol marker2 = p.symbol("marker2");
            Symbol marker3 = p.symbol("marker3");
            Symbol unreferenced = p.symbol("unreferenced");
            return p.tableFunctionProcessor(builder -> builder.name("test_function").passThroughSpecifications(new TableFunctionNode.PassThroughSpecification(true, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(a, false))), new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(c, true))), new TableFunctionNode.PassThroughSpecification(false, (List)ImmutableList.of((Object)new TableFunctionNode.PassThroughColumn(e, true)))).requiredSymbols((List<List<Symbol>>)ImmutableList.of((Object)ImmutableList.of((Object)b), (Object)ImmutableList.of((Object)d), (Object)ImmutableList.of((Object)f))).markerSymbols((Map<Symbol, Symbol>)ImmutableMap.of((Object)a, (Object)marker1, (Object)b, (Object)marker1, (Object)c, (Object)marker2, (Object)d, (Object)marker2, (Object)e, (Object)marker3, (Object)f, (Object)marker3, (Object)unreferenced, (Object)marker3)).source((PlanNode)p.values(a, b, c, d, e, f, marker1, marker2, marker3, unreferenced)));
        }).matches(PlanMatchPattern.tableFunctionProcessor(builder -> builder.name("test_function").passThroughSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"a"), (Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"e"))).requiredSymbols((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"b"), (Object)ImmutableList.of((Object)"d"), (Object)ImmutableList.of((Object)"f"))).markerSymbols((Map<String, String>)ImmutableMap.of((Object)"a", (Object)"marker1", (Object)"b", (Object)"marker1", (Object)"c", (Object)"marker2", (Object)"d", (Object)"marker2", (Object)"e", (Object)"marker3", (Object)"f", (Object)"marker3")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "a")), (Object)"b", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "b")), (Object)"c", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "c")), (Object)"d", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "d")), (Object)"e", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "e")), (Object)"f", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "f")), (Object)"marker1", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "marker1")), (Object)"marker2", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "marker2")), (Object)"marker3", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "marker3"))), PlanMatchPattern.values("a", "b", "c", "d", "e", "f", "marker1", "marker2", "marker3", "unreferenced"))));
    }

    @Test
    public void allSymbolsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneTableFunctionProcessorSourceColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol marker = p.symbol("marker");
            return p.tableFunctionProcessor(builder -> builder.name("test_function").requiredSymbols((List<List<Symbol>>)ImmutableList.of((Object)ImmutableList.of((Object)a))).markerSymbols((Map<Symbol, Symbol>)ImmutableMap.of((Object)a, (Object)marker)).source((PlanNode)p.values(a, marker)));
        }).doesNotFire();
    }
}

