/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneUnnestSourceColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.UnnestNode;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestPruneUnnestSourceColumns
extends BaseRuleTest {
    public TestPruneUnnestSourceColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testNotAllInputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneUnnestSourceColumns()).on(p -> {
            Symbol replicateSymbol = p.symbol("replicate_symbol");
            Symbol unnestSymbol = p.symbol("unnest_symbol");
            Symbol unusedSymbol = p.symbol("unused_symbol");
            Symbol unnestedSymbol = p.symbol("unnested_symbol");
            return p.unnest((List<Symbol>)ImmutableList.of((Object)replicateSymbol), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(unnestSymbol, (List)ImmutableList.of((Object)unnestedSymbol))), (PlanNode)p.values(replicateSymbol, unnestSymbol, unusedSymbol));
        }).matches(PlanMatchPattern.unnest((List<String>)ImmutableList.of((Object)"replicate_symbol"), (List<PlanMatchPattern.UnnestMapping>)ImmutableList.of((Object)PlanMatchPattern.UnnestMapping.unnestMapping("unnest_symbol", (List<String>)ImmutableList.of((Object)"unnested_symbol"))), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"replicate_symbol", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "replicate_symbol")), (Object)"unnest_symbol", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "unnest_symbol"))), PlanMatchPattern.values("replicate_symbol", "unnest_symbol", "unused_symbol"))));
    }

    @Test
    public void testAllInputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneUnnestSourceColumns()).on(p -> {
            Symbol replicateSymbol = p.symbol("replicate_symbol");
            Symbol unnestSymbol = p.symbol("unnest_symbol");
            Symbol unnestedSymbol = p.symbol("unnested_symbol");
            return p.unnest((List<Symbol>)ImmutableList.of((Object)replicateSymbol), (List<UnnestNode.Mapping>)ImmutableList.of((Object)new UnnestNode.Mapping(unnestSymbol, (List)ImmutableList.of((Object)unnestedSymbol))), (PlanNode)p.values(replicateSymbol, unnestSymbol));
        }).doesNotFire();
    }
}

