/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushLimitThroughOffset;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.SortItem;
import java.util.List;
import org.junit.jupiter.api.Test;

public class TestPushLimitThroughOffset
extends BaseRuleTest {
    public TestPushLimitThroughOffset() {
        super(new Plugin[0]);
    }

    @Test
    public void testPushdownLimitThroughOffset() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughOffset()).on(p -> p.limit(2L, (PlanNode)p.offset(5L, (PlanNode)p.values(new Symbol[0])))).matches(PlanMatchPattern.offset(5L, PlanMatchPattern.limit(7L, PlanMatchPattern.values(new String[0]))));
    }

    @Test
    public void testPushdownLimitWithTiesThroughOffset() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughOffset()).on(p -> {
            Symbol a = p.symbol("a");
            return p.limit(2L, (List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.offset(5L, (PlanNode)p.values(a)));
        }).matches(PlanMatchPattern.offset(5L, PlanMatchPattern.limit(7L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("a", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.values("a"))));
    }

    @Test
    public void doNotPushdownWhenRowCountOverflowsLong() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughOffset()).on(p -> p.limit(Long.MAX_VALUE, (PlanNode)p.offset(Long.MAX_VALUE, (PlanNode)p.values(new Symbol[0])))).doesNotFire();
    }

    @Test
    public void testPushdownWithPreSortedSymbolsThroughOffset() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughOffset()).on(p -> p.limit(2L, false, (List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (PlanNode)p.offset(5L, (PlanNode)p.values(new Symbol[0])))).matches(PlanMatchPattern.offset(5L, PlanMatchPattern.limit(7L, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), false, (List<String>)ImmutableList.of((Object)"a"), PlanMatchPattern.values(new String[0]))));
    }
}

