/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.connector.MockConnectorFactory;
import io.trino.metadata.AbstractMockMetadata;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.RowChangeParadigm;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TestingColumnHandle;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Row;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushMergeWriterUpdateIntoConnector;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.iterative.rule.test.RuleTester;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableUpdateNode;
import io.trino.sql.planner.plan.TableWriterNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestPushMergeWriterUpdateIntoConnector {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction MULTIPLY_BIGINT = FUNCTIONS.resolveOperator(OperatorType.MULTIPLY, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
    private static final String TEST_SCHEMA = "test_schema";
    private static final String TEST_TABLE = "test_table";
    private static final SchemaTableName SCHEMA_TABLE_NAME = new SchemaTableName("test_schema", "test_table");

    @Test
    public void testPushUpdateIntoConnector() {
        ImmutableList columnNames = ImmutableList.of((Object)"column_1", (Object)"column_2");
        MockConnectorFactory factory = MockConnectorFactory.builder().build();
        try (RuleTester ruleTester = RuleTester.builder().withDefaultCatalogConnectorFactory(factory).build();){
            ruleTester.assertThat((Rule<?>)TestPushMergeWriterUpdateIntoConnector.createRule()).on(arg_0 -> TestPushMergeWriterUpdateIntoConnector.lambda$testPushUpdateIntoConnector$1(ruleTester, (List)columnNames, arg_0)).matches(PlanMatchPattern.node(TableUpdateNode.class, new PlanMatchPattern[0]));
        }
    }

    @Test
    public void testPushUpdateIntoConnectorArithmeticExpression() {
        ImmutableList columnNames = ImmutableList.of((Object)"column_1", (Object)"column_2");
        MockConnectorFactory factory = MockConnectorFactory.builder().build();
        try (RuleTester ruleTester = RuleTester.builder().withDefaultCatalogConnectorFactory(factory).build();){
            ruleTester.assertThat((Rule<?>)TestPushMergeWriterUpdateIntoConnector.createRule()).on(arg_0 -> TestPushMergeWriterUpdateIntoConnector.lambda$testPushUpdateIntoConnectorArithmeticExpression$3(ruleTester, (List)columnNames, arg_0)).doesNotFire();
        }
    }

    @Test
    public void testPushUpdateIntoConnectorUpdateAll() {
        ImmutableList columnNames = ImmutableList.of((Object)"column_1", (Object)"column_2");
        MockConnectorFactory factory = MockConnectorFactory.builder().build();
        try (RuleTester ruleTester = RuleTester.builder().withDefaultCatalogConnectorFactory(factory).build();){
            ruleTester.assertThat((Rule<?>)TestPushMergeWriterUpdateIntoConnector.createRule()).on(arg_0 -> TestPushMergeWriterUpdateIntoConnector.lambda$testPushUpdateIntoConnectorUpdateAll$5(ruleTester, (List)columnNames, arg_0)).doesNotFire();
        }
    }

    private static PushMergeWriterUpdateIntoConnector createRule() {
        return new PushMergeWriterUpdateIntoConnector((Metadata)new AbstractMockMetadata(){

            @Override
            public Optional<TableHandle> applyUpdate(Session session, TableHandle tableHandle, Map<ColumnHandle, io.trino.spi.expression.Constant> assignments) {
                return Optional.of(tableHandle);
            }

            @Override
            public Map<String, ColumnHandle> getColumnHandles(Session session, TableHandle tableHandle) {
                return Map.of("column_1", new TestingColumnHandle("column_1"), "column_2", new TestingColumnHandle("column_2"));
            }
        });
    }

    private static /* synthetic */ PlanNode lambda$testPushUpdateIntoConnectorUpdateAll$5(RuleTester ruleTester, List columnNames, PlanBuilder p) {
        Symbol mergeRow = p.symbol("merge_row");
        Symbol rowId = p.symbol("row_id");
        Symbol rowCount = p.symbol("row_count");
        Row updateMergeRowExpression = new Row((List)ImmutableList.of((Object)new Call(ruleTester.getMetadata().resolveBuiltinFunction("from_base64", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR})), (List)ImmutableList.of((Object)new Constant((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)""))))));
        return p.tableFinish((PlanNode)p.merge((PlanNode)p.mergeProcessor(SCHEMA_TABLE_NAME, (PlanNode)p.project(new Assignments(Map.of(mergeRow, updateMergeRowExpression)), (PlanNode)p.tableScan(tableScanBuilder -> tableScanBuilder.setAssignments((Map<Symbol, ColumnHandle>)ImmutableMap.of()).setSymbols((List<Symbol>)ImmutableList.of()).setTableHandle(ruleTester.getCurrentCatalogTableHandle(TEST_SCHEMA, TEST_TABLE)).build())), mergeRow, rowId, (List<Symbol>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), (List<Symbol>)ImmutableList.of()), p.mergeTarget(SCHEMA_TABLE_NAME, new TableWriterNode.MergeParadigmAndTypes(Optional.of(RowChangeParadigm.DELETE_ROW_AND_INSERT_ROW), (List)ImmutableList.of(), columnNames, (Type)IntegerType.INTEGER)), mergeRow, rowId, (List<Symbol>)ImmutableList.of()), (TableWriterNode.WriterTarget)p.mergeTarget(SCHEMA_TABLE_NAME), rowCount);
    }

    private static /* synthetic */ PlanNode lambda$testPushUpdateIntoConnectorArithmeticExpression$3(RuleTester ruleTester, List columnNames, PlanBuilder p) {
        Symbol mergeRow = p.symbol("merge_row");
        Symbol rowId = p.symbol("row_id");
        Symbol rowCount = p.symbol("row_count");
        Row updateMergeRowExpression = new Row((List)ImmutableList.of((Object)p.symbol("column_1").toSymbolReference(), (Object)new Call(MULTIPLY_BIGINT, (List)ImmutableList.of((Object)p.symbol("col1").toSymbolReference(), (Object)new Constant((Type)BigintType.BIGINT, (Object)5L)))));
        return p.tableFinish((PlanNode)p.merge((PlanNode)p.mergeProcessor(SCHEMA_TABLE_NAME, (PlanNode)p.project(new Assignments(Map.of(mergeRow, updateMergeRowExpression)), (PlanNode)p.tableScan(tableScanBuilder -> tableScanBuilder.setAssignments((Map<Symbol, ColumnHandle>)ImmutableMap.of()).setSymbols((List<Symbol>)ImmutableList.of()).setTableHandle(ruleTester.getCurrentCatalogTableHandle(TEST_SCHEMA, TEST_TABLE)).build())), mergeRow, rowId, (List<Symbol>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), (List<Symbol>)ImmutableList.of()), p.mergeTarget(SCHEMA_TABLE_NAME, new TableWriterNode.MergeParadigmAndTypes(Optional.of(RowChangeParadigm.DELETE_ROW_AND_INSERT_ROW), (List)ImmutableList.of(), columnNames, (Type)IntegerType.INTEGER)), mergeRow, rowId, (List<Symbol>)ImmutableList.of()), (TableWriterNode.WriterTarget)p.mergeTarget(SCHEMA_TABLE_NAME), rowCount);
    }

    private static /* synthetic */ PlanNode lambda$testPushUpdateIntoConnector$1(RuleTester ruleTester, List columnNames, PlanBuilder p) {
        Symbol mergeRow = p.symbol("merge_row");
        Symbol rowId = p.symbol("row_id");
        Symbol rowCount = p.symbol("row_count");
        Row updateMergeRowExpression = new Row((List)ImmutableList.of((Object)p.symbol("column_1").toSymbolReference(), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)Booleans.TRUE, (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)1L)));
        return p.tableFinish((PlanNode)p.merge((PlanNode)p.mergeProcessor(SCHEMA_TABLE_NAME, (PlanNode)p.project(new Assignments(Map.of(mergeRow, updateMergeRowExpression)), (PlanNode)p.tableScan(tableScanBuilder -> tableScanBuilder.setAssignments((Map<Symbol, ColumnHandle>)ImmutableMap.of()).setSymbols((List<Symbol>)ImmutableList.of()).setTableHandle(ruleTester.getCurrentCatalogTableHandle(TEST_SCHEMA, TEST_TABLE)).build())), mergeRow, rowId, (List<Symbol>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), (List<Symbol>)ImmutableList.of()), p.mergeTarget(SCHEMA_TABLE_NAME, new TableWriterNode.MergeParadigmAndTypes(Optional.of(RowChangeParadigm.DELETE_ROW_AND_INSERT_ROW), (List)ImmutableList.of(), columnNames, (Type)IntegerType.INTEGER)), mergeRow, rowId, (List<Symbol>)ImmutableList.of()), (TableWriterNode.WriterTarget)p.mergeTarget(SCHEMA_TABLE_NAME), rowCount);
    }
}

