/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.Plugin;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.RvalueMatcher;
import io.trino.sql.planner.assertions.TopNRankingSymbolMatcher;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushPredicateThroughProjectIntoWindow;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TopNRankingNode;
import io.trino.sql.planner.plan.WindowNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestPushPredicateThroughProjectIntoWindow
extends BaseRuleTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction MODULUS_INTEGER = FUNCTIONS.resolveOperator(OperatorType.MODULUS, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER));

    public TestPushPredicateThroughProjectIntoWindow() {
        super(new Plugin[0]);
    }

    @Test
    public void testRankingSymbolPruned() {
        this.assertRankingSymbolPruned(this.rowNumberFunction());
        this.assertRankingSymbolPruned(this.rankFunction());
    }

    private void assertRankingSymbolPruned(WindowNode.Function rankingFunction) {
        this.tester().assertThat((Rule<?>)new PushPredicateThroughProjectIntoWindow(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol ranking = p.symbol("ranking");
            return p.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "a"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{a}), (PlanNode)p.window(new DataOrganizationSpecification((List)ImmutableList.of(), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)a), (Map)ImmutableMap.of((Object)a, (Object)SortOrder.ASC_NULLS_FIRST)))), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)ranking, (Object)rankingFunction), (PlanNode)p.values(a))));
        }).doesNotFire();
    }

    @Test
    public void testNoUpperBoundForRankingSymbol() {
        this.assertNoUpperBoundForRankingSymbol(this.rowNumberFunction());
        this.assertNoUpperBoundForRankingSymbol(this.rankFunction());
    }

    private void assertNoUpperBoundForRankingSymbol(WindowNode.Function rankingFunction) {
        this.tester().assertThat((Rule<?>)new PushPredicateThroughProjectIntoWindow(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol ranking = p.symbol("ranking");
            return p.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{a, ranking}), (PlanNode)p.window(new DataOrganizationSpecification((List)ImmutableList.of(), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)a), (Map)ImmutableMap.of((Object)a, (Object)SortOrder.ASC_NULLS_FIRST)))), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)ranking, (Object)rankingFunction), (PlanNode)p.values(a))));
        }).doesNotFire();
    }

    @Test
    public void testNonPositiveUpperBoundForRankingSymbol() {
        this.assertNonPositiveUpperBoundForRankingSymbol(this.rowNumberFunction());
        this.assertNonPositiveUpperBoundForRankingSymbol(this.rankFunction());
    }

    private void assertNonPositiveUpperBoundForRankingSymbol(WindowNode.Function rankingFunction) {
        this.tester().assertThat((Rule<?>)new PushPredicateThroughProjectIntoWindow(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol ranking = p.symbol("ranking");
            return p.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)), (Object)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "ranking"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)-10L)))), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{a, ranking}), (PlanNode)p.window(new DataOrganizationSpecification((List)ImmutableList.of(), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)a), (Map)ImmutableMap.of((Object)a, (Object)SortOrder.ASC_NULLS_FIRST)))), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)ranking, (Object)rankingFunction), (PlanNode)p.values(a))));
        }).matches(PlanMatchPattern.values("a", "ranking"));
    }

    @Test
    public void testPredicateNotSatisfied() {
        this.assertPredicateNotSatisfied(this.rowNumberFunction(), TopNRankingNode.RankingType.ROW_NUMBER);
        this.assertPredicateNotSatisfied(this.rankFunction(), TopNRankingNode.RankingType.RANK);
    }

    private void assertPredicateNotSatisfied(WindowNode.Function rankingFunction, TopNRankingNode.RankingType rankingType) {
        this.tester().assertThat((Rule<?>)new PushPredicateThroughProjectIntoWindow(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol ranking = p.symbol("ranking");
            return p.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "ranking"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)), (Object)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "ranking"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L)))), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{ranking}), (PlanNode)p.window(new DataOrganizationSpecification((List)ImmutableList.of(), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)a), (Map)ImmutableMap.of((Object)a, (Object)SortOrder.ASC_NULLS_FIRST)))), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)ranking, (Object)rankingFunction), (PlanNode)p.values(a))));
        }).matches(PlanMatchPattern.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "ranking"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)), (Object)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "ranking"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L)))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"ranking", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "ranking"))), PlanMatchPattern.topNRanking(pattern -> pattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"a"), (Map<String, SortOrder>)ImmutableMap.of((Object)"a", (Object)SortOrder.ASC_NULLS_FIRST)).rankingType(rankingType).maxRankingPerPartition(4).partial(false), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"))).withAlias("ranking", (RvalueMatcher)new TopNRankingSymbolMatcher()))));
    }

    @Test
    public void testPredicateSatisfied() {
        this.assertPredicateSatisfied(this.rowNumberFunction(), TopNRankingNode.RankingType.ROW_NUMBER);
        this.assertPredicateSatisfied(this.rankFunction(), TopNRankingNode.RankingType.RANK);
    }

    private void assertPredicateSatisfied(WindowNode.Function rankingFunction, TopNRankingNode.RankingType rankingType) {
        this.tester().assertThat((Rule<?>)new PushPredicateThroughProjectIntoWindow(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol ranking = p.symbol("ranking");
            return p.filter((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "ranking"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L)), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{ranking}), (PlanNode)p.window(new DataOrganizationSpecification((List)ImmutableList.of(), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)a), (Map)ImmutableMap.of((Object)a, (Object)SortOrder.ASC_NULLS_FIRST)))), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)ranking, (Object)rankingFunction), (PlanNode)p.values(a))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"ranking", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "ranking"))), PlanMatchPattern.topNRanking(pattern -> pattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"a"), (Map<String, SortOrder>)ImmutableMap.of((Object)"a", (Object)SortOrder.ASC_NULLS_FIRST)).rankingType(rankingType).maxRankingPerPartition(4).partial(false), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"))).withAlias("ranking", (RvalueMatcher)new TopNRankingSymbolMatcher())));
    }

    @Test
    public void testPredicatePartiallySatisfied() {
        this.assertPredicatePartiallySatisfied(this.rowNumberFunction(), TopNRankingNode.RankingType.ROW_NUMBER);
        this.assertPredicatePartiallySatisfied(this.rankFunction(), TopNRankingNode.RankingType.RANK);
    }

    private void assertPredicatePartiallySatisfied(WindowNode.Function rankingFunction, TopNRankingNode.RankingType rankingType) {
        this.tester().assertThat((Rule<?>)new PushPredicateThroughProjectIntoWindow(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol ranking = p.symbol("ranking");
            return p.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "ranking"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L)), (Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L)))), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{ranking, a}), (PlanNode)p.window(new DataOrganizationSpecification((List)ImmutableList.of(), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)a), (Map)ImmutableMap.of((Object)a, (Object)SortOrder.ASC_NULLS_FIRST)))), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)ranking, (Object)rankingFunction), (PlanNode)p.values(a))));
        }).matches(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L)), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"ranking", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "ranking")), (Object)"a", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "a"))), PlanMatchPattern.topNRanking(pattern -> pattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"a"), (Map<String, SortOrder>)ImmutableMap.of((Object)"a", (Object)SortOrder.ASC_NULLS_FIRST)).rankingType(rankingType).maxRankingPerPartition(4).partial(false), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"))).withAlias("ranking", (RvalueMatcher)new TopNRankingSymbolMatcher()))));
        this.tester().assertThat((Rule<?>)new PushPredicateThroughProjectIntoWindow(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a");
            Symbol ranking = p.symbol("ranking");
            return p.filter((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "ranking"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L)), (Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Call(MODULUS_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "ranking"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)))), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{ranking}), (PlanNode)p.window(new DataOrganizationSpecification((List)ImmutableList.of(), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)a), (Map)ImmutableMap.of((Object)a, (Object)SortOrder.ASC_NULLS_FIRST)))), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)ranking, (Object)rankingFunction), (PlanNode)p.values(a))));
        }).matches(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Call(MODULUS_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "ranking"), (Object)new Constant((Type)IntegerType.INTEGER, (Object)2L))), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)0L)), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"ranking", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "ranking"))), PlanMatchPattern.topNRanking(pattern -> pattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"a"), (Map<String, SortOrder>)ImmutableMap.of((Object)"a", (Object)SortOrder.ASC_NULLS_FIRST)).rankingType(rankingType).maxRankingPerPartition(4).partial(false), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"))).withAlias("ranking", (RvalueMatcher)new TopNRankingSymbolMatcher()))));
    }

    private WindowNode.Function rowNumberFunction() {
        return new WindowNode.Function(this.tester().getMetadata().resolveBuiltinFunction("row_number", TypeSignatureProvider.fromTypes((Type[])new Type[0])), (List)ImmutableList.of(), WindowNode.Frame.DEFAULT_FRAME, false);
    }

    private WindowNode.Function rankFunction() {
        return new WindowNode.Function(this.tester().getMetadata().resolveBuiltinFunction("rank", TypeSignatureProvider.fromTypes((Type[])new Type[0])), (List)ImmutableList.of(), WindowNode.Frame.DEFAULT_FRAME, false);
    }
}

