/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Expression;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.RemoveRedundantExists;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.ApplyNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.testing.TestingMetadata;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestRemoveRedundantExists
extends BaseRuleTest {
    public TestRemoveRedundantExists() {
        super(new Plugin[0]);
    }

    @Test
    public void testExistsFalse() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantExists()).on(p -> p.apply((Map<Symbol, ApplyNode.SetExpression>)ImmutableMap.of((Object)p.symbol("exists", (Type)BooleanType.BOOLEAN), (Object)new ApplyNode.Exists()), (List<Symbol>)ImmutableList.of(), (PlanNode)p.values(1, new Symbol[0]), (PlanNode)p.values(0, new Symbol[0]))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"exists", (Object)PlanMatchPattern.expression((Expression)Booleans.FALSE)), PlanMatchPattern.values(new String[0])));
    }

    @Test
    public void testExistsTrue() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantExists()).on(p -> p.apply((Map<Symbol, ApplyNode.SetExpression>)ImmutableMap.of((Object)p.symbol("exists", (Type)BooleanType.BOOLEAN), (Object)new ApplyNode.Exists()), (List<Symbol>)ImmutableList.of(), (PlanNode)p.values(1, new Symbol[0]), (PlanNode)p.values(1, new Symbol[0]))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"exists", (Object)PlanMatchPattern.expression((Expression)Booleans.TRUE)), PlanMatchPattern.values(new String[0])));
    }

    @Test
    public void testDoesNotFire() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantExists()).on(p -> p.apply((Map<Symbol, ApplyNode.SetExpression>)ImmutableMap.of((Object)p.symbol("exists", (Type)BooleanType.BOOLEAN), (Object)new ApplyNode.Exists()), (List<Symbol>)ImmutableList.of(), (PlanNode)p.values(1, new Symbol[0]), (PlanNode)p.tableScan((List<Symbol>)ImmutableList.of(), (Map<Symbol, ColumnHandle>)ImmutableMap.of()))).doesNotFire();
        this.tester().assertThat((Rule<?>)new RemoveRedundantExists()).on(p -> p.apply((Map<Symbol, ApplyNode.SetExpression>)ImmutableMap.builder().put((Object)p.symbol("exists", (Type)BooleanType.BOOLEAN), (Object)new ApplyNode.Exists()).put((Object)p.symbol("other"), (Object)new ApplyNode.In(p.symbol("value"), p.symbol("list"))).buildOrThrow(), (List<Symbol>)ImmutableList.of(), (PlanNode)p.values(1, p.symbol("value")), (PlanNode)p.tableScan((List<Symbol>)ImmutableList.of((Object)p.symbol("list")), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("list"), (Object)new TestingMetadata.TestingColumnHandle("list"))))).doesNotFire();
    }
}

