/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.ExpressionRewriter;
import io.trino.sql.ir.ExpressionTreeRewriter;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.optimizer.IrExpressionOptimizer;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.planner.iterative.rule.SimplifyExpressions;
import io.trino.type.Reals;
import io.trino.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSimplifyExpressions {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction DIVIDE_DOUBLE = FUNCTIONS.resolveOperator(OperatorType.DIVIDE, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE));
    private static final ResolvedFunction DIVIDE_REAL = FUNCTIONS.resolveOperator(OperatorType.DIVIDE, (List<? extends Type>)ImmutableList.of((Object)RealType.REAL, (Object)RealType.REAL));

    @Test
    public void testPushesDownNegations() {
        TestSimplifyExpressions.assertSimplifies(TestSimplifyExpressions.not((Expression)new Reference((Type)BooleanType.BOOLEAN, "X")), TestSimplifyExpressions.not((Expression)new Reference((Type)BooleanType.BOOLEAN, "X")));
        TestSimplifyExpressions.assertSimplifies(TestSimplifyExpressions.not(TestSimplifyExpressions.not((Expression)new Reference((Type)BooleanType.BOOLEAN, "X"))), (Expression)new Reference((Type)BooleanType.BOOLEAN, "X"));
        TestSimplifyExpressions.assertSimplifies(TestSimplifyExpressions.not(TestSimplifyExpressions.not(TestSimplifyExpressions.not((Expression)new Reference((Type)BooleanType.BOOLEAN, "X")))), TestSimplifyExpressions.not((Expression)new Reference((Type)BooleanType.BOOLEAN, "X")));
        TestSimplifyExpressions.assertSimplifies(TestSimplifyExpressions.not(TestSimplifyExpressions.not(TestSimplifyExpressions.not((Expression)new Reference((Type)BooleanType.BOOLEAN, "X")))), TestSimplifyExpressions.not((Expression)new Reference((Type)BooleanType.BOOLEAN, "X")));
        TestSimplifyExpressions.assertSimplifies(TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BooleanType.BOOLEAN, "X"), (Expression)new Reference((Type)BooleanType.BOOLEAN, "Y"))), (Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)BooleanType.BOOLEAN, "X"), (Expression)new Reference((Type)BooleanType.BOOLEAN, "Y")));
        TestSimplifyExpressions.assertSimplifies(TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BooleanType.BOOLEAN, "X"), TestSimplifyExpressions.not(TestSimplifyExpressions.not((Expression)new Reference((Type)BooleanType.BOOLEAN, "Y"))))), (Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)BooleanType.BOOLEAN, "X"), (Expression)new Reference((Type)BooleanType.BOOLEAN, "Y")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BooleanType.BOOLEAN, "X"), TestSimplifyExpressions.not(TestSimplifyExpressions.not((Expression)new Reference((Type)BooleanType.BOOLEAN, "Y")))), (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BooleanType.BOOLEAN, "X"), (Expression)new Reference((Type)BooleanType.BOOLEAN, "Y")));
        TestSimplifyExpressions.assertSimplifies(TestSimplifyExpressions.not((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "X"), (Object)new Reference((Type)BooleanType.BOOLEAN, "Y"), (Object)TestSimplifyExpressions.not((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "Z"), (Object)new Reference((Type)BooleanType.BOOLEAN, "V"))))))), (Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)TestSimplifyExpressions.not((Expression)new Reference((Type)BooleanType.BOOLEAN, "X")), (Object)TestSimplifyExpressions.not((Expression)new Reference((Type)BooleanType.BOOLEAN, "Y")), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "Z"), (Object)new Reference((Type)BooleanType.BOOLEAN, "V"))))));
        TestSimplifyExpressions.assertSimplifies(TestSimplifyExpressions.not((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "X"), (Object)new Reference((Type)BooleanType.BOOLEAN, "Y"), (Object)TestSimplifyExpressions.not((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "Z"), (Object)new Reference((Type)BooleanType.BOOLEAN, "V"))))))), (Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)TestSimplifyExpressions.not((Expression)new Reference((Type)BooleanType.BOOLEAN, "X")), (Object)TestSimplifyExpressions.not((Expression)new Reference((Type)BooleanType.BOOLEAN, "Y")), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "Z"), (Object)new Reference((Type)BooleanType.BOOLEAN, "V"))))));
        TestSimplifyExpressions.assertSimplifies(TestSimplifyExpressions.not((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "X"), (Object)new Reference((Type)BooleanType.BOOLEAN, "Y"), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "Z"), (Object)new Reference((Type)BooleanType.BOOLEAN, "V")))))), (Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)TestSimplifyExpressions.not((Expression)new Reference((Type)BooleanType.BOOLEAN, "X")), (Object)TestSimplifyExpressions.not((Expression)new Reference((Type)BooleanType.BOOLEAN, "Y")), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)TestSimplifyExpressions.not((Expression)new Reference((Type)BooleanType.BOOLEAN, "Z")), (Object)TestSimplifyExpressions.not((Expression)new Reference((Type)BooleanType.BOOLEAN, "V")))))));
        TestSimplifyExpressions.assertSimplifies((Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BooleanType.BOOLEAN, "X"), (Expression)new Reference((Type)BooleanType.BOOLEAN, "Y")), (Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BooleanType.BOOLEAN, "X"), (Expression)new Reference((Type)BooleanType.BOOLEAN, "Y")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BooleanType.BOOLEAN, "X"), (Expression)new Reference((Type)BooleanType.BOOLEAN, "Y")), (Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BooleanType.BOOLEAN, "X"), (Expression)new Reference((Type)BooleanType.BOOLEAN, "Y")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BooleanType.BOOLEAN, "X"), (Expression)new Reference((Type)BooleanType.BOOLEAN, "Y")), (Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BooleanType.BOOLEAN, "X"), (Expression)new Reference((Type)BooleanType.BOOLEAN, "Y")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BooleanType.BOOLEAN, "X"), (Expression)new Reference((Type)BooleanType.BOOLEAN, "Y")), (Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BooleanType.BOOLEAN, "X"), (Expression)new Reference((Type)BooleanType.BOOLEAN, "Y")));
    }

    @Test
    public void testExtractCommonPredicates() {
        TestSimplifyExpressions.assertSimplifies((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "X"), (Object)new Reference((Type)BooleanType.BOOLEAN, "Y"))), (Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "X"), (Object)new Reference((Type)BooleanType.BOOLEAN, "Y"))));
        TestSimplifyExpressions.assertSimplifies((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "X"), (Object)new Reference((Type)BooleanType.BOOLEAN, "Y"))), (Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "Y"), (Object)new Reference((Type)BooleanType.BOOLEAN, "X"))));
        TestSimplifyExpressions.assertSimplifies((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "X"), (Object)new Reference((Type)BooleanType.BOOLEAN, "X"))), (Expression)new Reference((Type)BooleanType.BOOLEAN, "X"));
        TestSimplifyExpressions.assertSimplifies((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "X"), (Object)new Reference((Type)BooleanType.BOOLEAN, "X"))), (Expression)new Reference((Type)BooleanType.BOOLEAN, "X"));
        TestSimplifyExpressions.assertSimplifies((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "X"), (Object)new Reference((Type)BooleanType.BOOLEAN, "Y"))), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "X"), (Object)new Reference((Type)BooleanType.BOOLEAN, "Y"))))), (Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "X"), (Object)new Reference((Type)BooleanType.BOOLEAN, "Y"))));
        TestSimplifyExpressions.assertSimplifies((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A"), (Object)new Reference((Type)BooleanType.BOOLEAN, "V"))), (Object)new Reference((Type)BooleanType.BOOLEAN, "V"))), (Expression)new Reference((Type)BooleanType.BOOLEAN, "V"));
        TestSimplifyExpressions.assertSimplifies((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A"), (Object)new Reference((Type)BooleanType.BOOLEAN, "V"))), (Object)new Reference((Type)BooleanType.BOOLEAN, "V"))), (Expression)new Reference((Type)BooleanType.BOOLEAN, "V"));
        TestSimplifyExpressions.assertSimplifies((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A"), (Object)new Reference((Type)BooleanType.BOOLEAN, "B"), (Object)new Reference((Type)BooleanType.BOOLEAN, "C"))), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A"), (Object)new Reference((Type)BooleanType.BOOLEAN, "B"))))), (Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A"), (Object)new Reference((Type)BooleanType.BOOLEAN, "B"))));
        TestSimplifyExpressions.assertSimplifies((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A"), (Object)new Reference((Type)BooleanType.BOOLEAN, "B"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A"), (Object)new Reference((Type)BooleanType.BOOLEAN, "B"), (Object)new Reference((Type)BooleanType.BOOLEAN, "C"))))), (Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A"), (Object)new Reference((Type)BooleanType.BOOLEAN, "B"))));
        TestSimplifyExpressions.assertSimplifies((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BooleanType.BOOLEAN, "I"), (Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A"), (Object)new Reference((Type)BooleanType.BOOLEAN, "B"))), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A"), (Object)new Reference((Type)BooleanType.BOOLEAN, "B"), (Object)new Reference((Type)BooleanType.BOOLEAN, "C")))))), (Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BooleanType.BOOLEAN, "I"), (Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A"), (Object)new Reference((Type)BooleanType.BOOLEAN, "B")))));
        TestSimplifyExpressions.assertSimplifies((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "X"), (Object)new Reference((Type)BooleanType.BOOLEAN, "Y"))), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "X"), (Object)new Reference((Type)BooleanType.BOOLEAN, "Z"))))), (Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "X"), (Object)new Reference((Type)BooleanType.BOOLEAN, "Y"))), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "X"), (Object)new Reference((Type)BooleanType.BOOLEAN, "Z"))))));
        TestSimplifyExpressions.assertSimplifies((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "X"), (Object)new Reference((Type)BooleanType.BOOLEAN, "Y"), (Object)new Reference((Type)BooleanType.BOOLEAN, "V"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "X"), (Object)new Reference((Type)BooleanType.BOOLEAN, "Y"), (Object)new Reference((Type)BooleanType.BOOLEAN, "Z"))))), (Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "X"), (Object)new Reference((Type)BooleanType.BOOLEAN, "Y"))), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "V"), (Object)new Reference((Type)BooleanType.BOOLEAN, "Z"))))));
        TestSimplifyExpressions.assertSimplifies((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "X"), (Object)new Reference((Type)BooleanType.BOOLEAN, "Y"), (Object)new Reference((Type)BooleanType.BOOLEAN, "V"))), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "X"), (Object)new Reference((Type)BooleanType.BOOLEAN, "Y"), (Object)new Reference((Type)BooleanType.BOOLEAN, "Z"))))), (Expression)new Reference((Type)BooleanType.BOOLEAN, "I")), (Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "X"), (Object)new Reference((Type)BooleanType.BOOLEAN, "Y"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "V"), (Object)new Reference((Type)BooleanType.BOOLEAN, "Z"))))), (Expression)new Reference((Type)BooleanType.BOOLEAN, "I")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "X"), (Object)new Reference((Type)BooleanType.BOOLEAN, "V"))), (Object)new Reference((Type)BooleanType.BOOLEAN, "V"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "X"), (Object)new Reference((Type)BooleanType.BOOLEAN, "V"))), (Object)new Reference((Type)BooleanType.BOOLEAN, "V"))))), (Expression)new Reference((Type)BooleanType.BOOLEAN, "V"));
        TestSimplifyExpressions.assertSimplifies((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "X"), (Object)new Reference((Type)BooleanType.BOOLEAN, "V"))), (Object)new Reference((Type)BooleanType.BOOLEAN, "X"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "X"), (Object)new Reference((Type)BooleanType.BOOLEAN, "V"))), (Object)new Reference((Type)BooleanType.BOOLEAN, "V"))))), (Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "X"), (Object)new Reference((Type)BooleanType.BOOLEAN, "V"))));
        TestSimplifyExpressions.assertSimplifies((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "X"), (Object)new Reference((Type)BooleanType.BOOLEAN, "V"))), (Object)new Reference((Type)BooleanType.BOOLEAN, "Z"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "X"), (Object)new Reference((Type)BooleanType.BOOLEAN, "V"))), (Object)new Reference((Type)BooleanType.BOOLEAN, "V"))))), (Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "X"), (Object)new Reference((Type)BooleanType.BOOLEAN, "V"))), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "Z"), (Object)new Reference((Type)BooleanType.BOOLEAN, "V"))))));
        TestSimplifyExpressions.assertSimplifies((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "X"), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "Y"), (Object)new Reference((Type)BooleanType.BOOLEAN, "Z"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "Y"), (Object)new Reference((Type)BooleanType.BOOLEAN, "V"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "Y"), (Object)new Reference((Type)BooleanType.BOOLEAN, "X"))))))), (Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "X"), (Object)new Reference((Type)BooleanType.BOOLEAN, "Y"), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "Z"), (Object)new Reference((Type)BooleanType.BOOLEAN, "V"), (Object)new Reference((Type)BooleanType.BOOLEAN, "X"))))));
        TestSimplifyExpressions.assertSimplifies((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A"), (Object)new Reference((Type)BooleanType.BOOLEAN, "B"), (Object)new Reference((Type)BooleanType.BOOLEAN, "C"), (Object)new Reference((Type)BooleanType.BOOLEAN, "D"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A"), (Object)new Reference((Type)BooleanType.BOOLEAN, "B"), (Object)new Reference((Type)BooleanType.BOOLEAN, "E"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A"), (Object)new Reference((Type)BooleanType.BOOLEAN, "F"))))), (Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A"), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "B"), (Object)new Reference((Type)BooleanType.BOOLEAN, "C"), (Object)new Reference((Type)BooleanType.BOOLEAN, "D"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "B"), (Object)new Reference((Type)BooleanType.BOOLEAN, "E"))), (Object)new Reference((Type)BooleanType.BOOLEAN, "F"))))));
        TestSimplifyExpressions.assertSimplifies((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A"), (Object)new Reference((Type)BooleanType.BOOLEAN, "B"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A"), (Object)new Reference((Type)BooleanType.BOOLEAN, "C"))))), (Object)new Reference((Type)BooleanType.BOOLEAN, "D"))), (Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A"), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "B"), (Object)new Reference((Type)BooleanType.BOOLEAN, "C"))), (Object)new Reference((Type)BooleanType.BOOLEAN, "D"))));
        TestSimplifyExpressions.assertSimplifies((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A"), (Object)new Reference((Type)BooleanType.BOOLEAN, "B"))), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A"), (Object)new Reference((Type)BooleanType.BOOLEAN, "C"))))), (Object)new Reference((Type)BooleanType.BOOLEAN, "D"))), (Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A"), (Object)new Reference((Type)BooleanType.BOOLEAN, "B"), (Object)new Reference((Type)BooleanType.BOOLEAN, "D"))), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A"), (Object)new Reference((Type)BooleanType.BOOLEAN, "C"), (Object)new Reference((Type)BooleanType.BOOLEAN, "D"))))));
        TestSimplifyExpressions.assertSimplifies((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A"), (Object)new Reference((Type)BooleanType.BOOLEAN, "B"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A"), (Object)new Reference((Type)BooleanType.BOOLEAN, "C"))))), (Object)new Reference((Type)BooleanType.BOOLEAN, "D"))), (Object)new Reference((Type)BooleanType.BOOLEAN, "E"))), (Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A"), (Object)new Reference((Type)BooleanType.BOOLEAN, "E"))), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "B"), (Object)new Reference((Type)BooleanType.BOOLEAN, "C"), (Object)new Reference((Type)BooleanType.BOOLEAN, "E"))), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "D"), (Object)new Reference((Type)BooleanType.BOOLEAN, "E"))))));
        TestSimplifyExpressions.assertSimplifies((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A"), (Object)new Reference((Type)BooleanType.BOOLEAN, "B"))), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A"), (Object)new Reference((Type)BooleanType.BOOLEAN, "C"))))), (Object)new Reference((Type)BooleanType.BOOLEAN, "D"))), (Object)new Reference((Type)BooleanType.BOOLEAN, "E"))), (Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A"), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "B"), (Object)new Reference((Type)BooleanType.BOOLEAN, "C"))), (Object)new Reference((Type)BooleanType.BOOLEAN, "D"))), (Object)new Reference((Type)BooleanType.BOOLEAN, "E"))));
        TestSimplifyExpressions.assertSimplifies((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A"), (Object)new Reference((Type)BooleanType.BOOLEAN, "B"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "C"), (Object)new Reference((Type)BooleanType.BOOLEAN, "D"))))), (Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A"), (Object)new Reference((Type)BooleanType.BOOLEAN, "C"))), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A"), (Object)new Reference((Type)BooleanType.BOOLEAN, "D"))), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "B"), (Object)new Reference((Type)BooleanType.BOOLEAN, "C"))), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "B"), (Object)new Reference((Type)BooleanType.BOOLEAN, "D"))))));
        TestSimplifyExpressions.assertSimplifies((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A"), (Object)new Reference((Type)BooleanType.BOOLEAN, "B"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "C"), (Object)new Reference((Type)BooleanType.BOOLEAN, "D"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "E"), (Object)new Reference((Type)BooleanType.BOOLEAN, "F"))))), (Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A"), (Object)new Reference((Type)BooleanType.BOOLEAN, "B"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "C"), (Object)new Reference((Type)BooleanType.BOOLEAN, "D"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "E"), (Object)new Reference((Type)BooleanType.BOOLEAN, "F"))))));
        TestSimplifyExpressions.assertSimplifies((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A1"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A2"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A3"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A4"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A5"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A6"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A7"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A8"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A9"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A10"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A11"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A12"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A13"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A14"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A15"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A16"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A17"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A18"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A19"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A20"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A21"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A22"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A23"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A24"))), (Object[])new Expression[]{new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A25"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A26"))), new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A27"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A28"))), new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A29"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A30"))), new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A31"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A32"))), new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A33"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A34"))), new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A35"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A36"))), new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A37"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A38"))), new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A39"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A40"))), new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A41"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A42"))), new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A43"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A44"))), new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A45"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A46"))), new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A47"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A48"))), new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A49"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A50"))), new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A51"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A52"))), new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A53"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A54"))), new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A55"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A56"))), new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A57"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A58"))), new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A59"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A60")))})), (Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A1"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A2"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A3"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A4"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A5"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A6"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A7"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A8"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A9"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A10"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A11"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A12"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A13"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A14"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A15"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A16"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A17"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A18"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A19"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A20"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A21"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A22"))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A23"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A24"))), (Object[])new Expression[]{new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A25"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A26"))), new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A27"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A28"))), new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A29"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A30"))), new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A31"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A32"))), new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A33"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A34"))), new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A35"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A36"))), new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A37"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A38"))), new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A39"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A40"))), new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A41"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A42"))), new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A43"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A44"))), new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A45"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A46"))), new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A47"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A48"))), new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A49"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A50"))), new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A51"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A52"))), new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A53"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A54"))), new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A55"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A56"))), new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A57"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A58"))), new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "A59"), (Object)new Reference((Type)BooleanType.BOOLEAN, "A60")))})));
    }

    @Test
    public void testMultipleNulls() {
        TestSimplifyExpressions.assertSimplifies((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Constant((Type)BooleanType.BOOLEAN, null), (Object)new Constant((Type)BooleanType.BOOLEAN, null), (Object)new Constant((Type)BooleanType.BOOLEAN, null), (Object)Booleans.FALSE)), (Expression)Booleans.FALSE);
        TestSimplifyExpressions.assertSimplifies((Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Constant((Type)BooleanType.BOOLEAN, null), (Object)new Constant((Type)BooleanType.BOOLEAN, null), (Object)new Constant((Type)BooleanType.BOOLEAN, null), (Object)new Reference((Type)BooleanType.BOOLEAN, "B1"))), (Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Constant((Type)BooleanType.BOOLEAN, null), (Object)new Reference((Type)BooleanType.BOOLEAN, "B1"))));
        TestSimplifyExpressions.assertSimplifies((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Constant((Type)BooleanType.BOOLEAN, null), (Object)new Constant((Type)BooleanType.BOOLEAN, null), (Object)new Constant((Type)BooleanType.BOOLEAN, null), (Object)Booleans.TRUE)), (Expression)Booleans.TRUE);
        TestSimplifyExpressions.assertSimplifies((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Constant((Type)BooleanType.BOOLEAN, null), (Object)new Constant((Type)BooleanType.BOOLEAN, null), (Object)new Constant((Type)BooleanType.BOOLEAN, null), (Object)new Reference((Type)BooleanType.BOOLEAN, "B1"))), (Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Constant((Type)BooleanType.BOOLEAN, null), (Object)new Reference((Type)BooleanType.BOOLEAN, "B1"))));
    }

    @Test
    public void testCastBigintToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)BigintType.BIGINT, (Object)12300000000L), (Type)VarcharType.createVarcharType((int)11)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)11), (Object)Slices.utf8Slice((String)"12300000000")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)BigintType.BIGINT, (Object)-12300000000L), (Type)VarcharType.createVarcharType((int)50)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)50), (Object)Slices.utf8Slice((String)"-12300000000")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)BigintType.BIGINT, (Object)12300000000L), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new Constant((Type)BigintType.BIGINT, (Object)12300000000L), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)BigintType.BIGINT, (Object)-12300000000L), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new Constant((Type)BigintType.BIGINT, (Object)-12300000000L), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Cast((Expression)new Constant((Type)BigintType.BIGINT, (Object)12300000000L), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)3), (Object)Slices.utf8Slice((String)"12300000000"))), (Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Cast((Expression)new Constant((Type)BigintType.BIGINT, (Object)12300000000L), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)3), (Object)Slices.utf8Slice((String)"12300000000"))));
    }

    @Test
    public void testCastIntegerToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1234L), (Type)VarcharType.createVarcharType((int)4)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)4), (Object)Slices.utf8Slice((String)"1234")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)-1234L), (Type)VarcharType.createVarcharType((int)50)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)50), (Object)Slices.utf8Slice((String)"-1234")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1234L), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1234L), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1234L), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1234L), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1234L), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)3), (Object)Slices.utf8Slice((String)"1234"))), (Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Cast((Expression)new Constant((Type)IntegerType.INTEGER, (Object)1234L), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)3), (Object)Slices.utf8Slice((String)"1234"))));
    }

    @Test
    public void testCastSmallintToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)SmallintType.SMALLINT, (Object)1234L), (Type)VarcharType.createVarcharType((int)4)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)4), (Object)Slices.utf8Slice((String)"1234")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)SmallintType.SMALLINT, (Object)-1234L), (Type)VarcharType.createVarcharType((int)50)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)50), (Object)Slices.utf8Slice((String)"-1234")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)SmallintType.SMALLINT, (Object)1234L), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new Constant((Type)SmallintType.SMALLINT, (Object)1234L), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)SmallintType.SMALLINT, (Object)-1234L), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new Constant((Type)SmallintType.SMALLINT, (Object)-1234L), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Cast((Expression)new Constant((Type)SmallintType.SMALLINT, (Object)1234L), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)3), (Object)Slices.utf8Slice((String)"1234"))), (Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Cast((Expression)new Constant((Type)SmallintType.SMALLINT, (Object)1234L), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)3), (Object)Slices.utf8Slice((String)"1234"))));
    }

    @Test
    public void testCastTinyintToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)TinyintType.TINYINT, (Object)123L), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)3), (Object)Slices.utf8Slice((String)"123")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)TinyintType.TINYINT, (Object)-123L), (Type)VarcharType.createVarcharType((int)50)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)50), (Object)Slices.utf8Slice((String)"-123")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)TinyintType.TINYINT, (Object)123L), (Type)VarcharType.createVarcharType((int)2)), (Expression)new Cast((Expression)new Constant((Type)TinyintType.TINYINT, (Object)123L), (Type)VarcharType.createVarcharType((int)2)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)TinyintType.TINYINT, (Object)-123L), (Type)VarcharType.createVarcharType((int)2)), (Expression)new Cast((Expression)new Constant((Type)TinyintType.TINYINT, (Object)-123L), (Type)VarcharType.createVarcharType((int)2)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Cast((Expression)new Constant((Type)TinyintType.TINYINT, (Object)123L), (Type)VarcharType.createVarcharType((int)2)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)2), (Object)Slices.utf8Slice((String)"12"))), (Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Cast((Expression)new Constant((Type)TinyintType.TINYINT, (Object)123L), (Type)VarcharType.createVarcharType((int)2)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)2), (Object)Slices.utf8Slice((String)"12"))));
    }

    @Test
    public void testCastShortDecimalToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DecimalType.createDecimalType((int)3, (int)1), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("12.4"))), (Type)VarcharType.createVarcharType((int)4)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)4), (Object)Slices.utf8Slice((String)"12.4")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DecimalType.createDecimalType((int)3, (int)1), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("-12.4"))), (Type)VarcharType.createVarcharType((int)50)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)50), (Object)Slices.utf8Slice((String)"-12.4")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DecimalType.createDecimalType((int)3, (int)1), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("12.4"))), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new Constant((Type)DecimalType.createDecimalType((int)3, (int)1), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("12.4"))), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DecimalType.createDecimalType((int)3, (int)1), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("-12.4"))), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new Constant((Type)DecimalType.createDecimalType((int)3, (int)1), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("-12.4"))), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Cast((Expression)new Constant((Type)DecimalType.createDecimalType((int)3, (int)1), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("12.4"))), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)3), (Object)Slices.utf8Slice((String)"12.4"))), (Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Cast((Expression)new Constant((Type)DecimalType.createDecimalType((int)3, (int)1), (Object)Decimals.valueOfShort((BigDecimal)new BigDecimal("12.4"))), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)3), (Object)Slices.utf8Slice((String)"12.4"))));
    }

    @Test
    public void testCastLongDecimalToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DecimalType.createDecimalType((int)19, (int)1), (Object)Decimals.valueOf((BigDecimal)new BigDecimal("100000000000000000.1"))), (Type)VarcharType.createVarcharType((int)20)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)20), (Object)Slices.utf8Slice((String)"100000000000000000.1")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DecimalType.createDecimalType((int)19, (int)1), (Object)Decimals.valueOf((BigDecimal)new BigDecimal("-100000000000000000.1"))), (Type)VarcharType.createVarcharType((int)50)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)50), (Object)Slices.utf8Slice((String)"-100000000000000000.1")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DecimalType.createDecimalType((int)19, (int)1), (Object)Decimals.valueOf((BigDecimal)new BigDecimal("100000000000000000.1"))), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new Constant((Type)DecimalType.createDecimalType((int)19, (int)1), (Object)Decimals.valueOf((BigDecimal)new BigDecimal("100000000000000000.1"))), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DecimalType.createDecimalType((int)19, (int)1), (Object)Decimals.valueOf((BigDecimal)new BigDecimal("-100000000000000000.1"))), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new Constant((Type)DecimalType.createDecimalType((int)19, (int)1), (Object)Decimals.valueOf((BigDecimal)new BigDecimal("-100000000000000000.1"))), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Cast((Expression)new Constant((Type)DecimalType.createDecimalType((int)19, (int)1), (Object)Decimals.valueOf((BigDecimal)new BigDecimal("100000000000000000.1"))), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)3), (Object)Slices.utf8Slice((String)"100000000000000000.1"))), (Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Cast((Expression)new Constant((Type)DecimalType.createDecimalType((int)19, (int)1), (Object)Decimals.valueOf((BigDecimal)new BigDecimal("100000000000000000.1"))), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)3), (Object)Slices.utf8Slice((String)"100000000000000000.1"))));
    }

    @Test
    public void testCastDoubleToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)3), (Object)Slices.utf8Slice((String)"0E0")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DoubleType.DOUBLE, (Object)-0.0), (Type)VarcharType.createVarcharType((int)4)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)4), (Object)Slices.utf8Slice((String)"-0E0")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Call(DIVIDE_DOUBLE, (List)ImmutableList.of((Object)new Constant((Type)DoubleType.DOUBLE, (Object)0.0), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)0.0))), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)3), (Object)Slices.utf8Slice((String)"NaN")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DoubleType.DOUBLE, (Object)Double.POSITIVE_INFINITY), (Type)VarcharType.createVarcharType((int)8)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)8), (Object)Slices.utf8Slice((String)"Infinity")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DoubleType.DOUBLE, (Object)1200.0), (Type)VarcharType.createVarcharType((int)5)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)5), (Object)Slices.utf8Slice((String)"1.2E3")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DoubleType.DOUBLE, (Object)-1200.0), (Type)VarcharType.createVarcharType((int)50)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)50), (Object)Slices.utf8Slice((String)"-1.2E3")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DoubleType.DOUBLE, (Object)1200.0), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new Constant((Type)DoubleType.DOUBLE, (Object)1200.0), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DoubleType.DOUBLE, (Object)-1200.0), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new Constant((Type)DoubleType.DOUBLE, (Object)-1200.0), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DoubleType.DOUBLE, (Object)Double.NaN), (Type)VarcharType.createVarcharType((int)2)), (Expression)new Cast((Expression)new Constant((Type)DoubleType.DOUBLE, (Object)Double.NaN), (Type)VarcharType.createVarcharType((int)2)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DoubleType.DOUBLE, (Object)Double.POSITIVE_INFINITY), (Type)VarcharType.createVarcharType((int)7)), (Expression)new Cast((Expression)new Constant((Type)DoubleType.DOUBLE, (Object)Double.POSITIVE_INFINITY), (Type)VarcharType.createVarcharType((int)7)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Cast((Expression)new Constant((Type)DoubleType.DOUBLE, (Object)1200.0), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)3), (Object)Slices.utf8Slice((String)"1200.0"))), (Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Cast((Expression)new Constant((Type)DoubleType.DOUBLE, (Object)1200.0), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)3), (Object)Slices.utf8Slice((String)"1200.0"))));
    }

    @Test
    public void testCastRealToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)0.0f)), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)3), (Object)Slices.utf8Slice((String)"0E0")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)-0.0f)), (Type)VarcharType.createVarcharType((int)4)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)4), (Object)Slices.utf8Slice((String)"-0E0")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Call(DIVIDE_REAL, (List)ImmutableList.of((Object)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)0.0f)), (Object)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)0.0f)))), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)3), (Object)Slices.utf8Slice((String)"NaN")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)Float.POSITIVE_INFINITY)), (Type)VarcharType.createVarcharType((int)8)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)8), (Object)Slices.utf8Slice((String)"Infinity")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)1200.0f)), (Type)VarcharType.createVarcharType((int)5)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)5), (Object)Slices.utf8Slice((String)"1.2E3")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)-1200.0f)), (Type)VarcharType.createVarcharType((int)50)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)50), (Object)Slices.utf8Slice((String)"-1.2E3")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)1200.0f)), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)1200.0f)), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)-1200.0f)), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)-1200.0f)), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)Float.NaN)), (Type)VarcharType.createVarcharType((int)2)), (Expression)new Cast((Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)Float.NaN)), (Type)VarcharType.createVarcharType((int)2)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)Float.POSITIVE_INFINITY)), (Type)VarcharType.createVarcharType((int)7)), (Expression)new Cast((Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)Float.POSITIVE_INFINITY)), (Type)VarcharType.createVarcharType((int)7)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Cast((Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)1200.0f)), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)3), (Object)Slices.utf8Slice((String)"1200.0"))), (Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Cast((Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)1200.0f)), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)3), (Object)Slices.utf8Slice((String)"1200.0"))));
    }

    @Test
    public void testCastDateToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2013-02-02")), (Type)VarcharType.createVarcharType((int)10)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)10), (Object)Slices.utf8Slice((String)"2013-02-02")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2013-02-02")), (Type)VarcharType.createVarcharType((int)50)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)50), (Object)Slices.utf8Slice((String)"2013-02-02")));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2013-02-02")), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2013-02-02")), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Cast((Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2013-02-02")), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)3), (Object)Slices.utf8Slice((String)"2013-02-02"))), (Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Cast((Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2013-02-02")), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Constant((Type)VarcharType.createVarcharType((int)3), (Object)Slices.utf8Slice((String)"2013-02-02"))));
    }

    private static void assertSimplifies(Expression expression, Expression expected) {
        Expression simplified = TestSimplifyExpressions.normalize(SimplifyExpressions.rewrite((Expression)expression, (Session)SessionTestUtils.TEST_SESSION, (IrExpressionOptimizer)IrExpressionOptimizer.newOptimizer((PlannerContext)TestingPlannerContext.PLANNER_CONTEXT)));
        Assertions.assertThat((Object)simplified).isEqualTo((Object)TestSimplifyExpressions.normalize(expected));
    }

    @Test
    public void testPushesDownNegationsNumericTypes() {
        TestSimplifyExpressions.assertSimplifiesNumericTypes(TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "I1"), (Expression)new Reference((Type)IntegerType.INTEGER, "I2"))), (Expression)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "I1"), (Expression)new Reference((Type)IntegerType.INTEGER, "I2")));
        TestSimplifyExpressions.assertSimplifiesNumericTypes(TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "I1"), (Expression)new Reference((Type)IntegerType.INTEGER, "I2"))), (Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "I1"), (Expression)new Reference((Type)IntegerType.INTEGER, "I2")));
        TestSimplifyExpressions.assertSimplifiesNumericTypes(TestSimplifyExpressions.not((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "I1"), (Expression)new Reference((Type)IntegerType.INTEGER, "I2")), (Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "I3"), (Expression)new Reference((Type)IntegerType.INTEGER, "I4"))))), (Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "I1"), (Expression)new Reference((Type)IntegerType.INTEGER, "I2")), (Object)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "I3"), (Expression)new Reference((Type)IntegerType.INTEGER, "I4")))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes(TestSimplifyExpressions.not(TestSimplifyExpressions.not(TestSimplifyExpressions.not((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)TestSimplifyExpressions.not(TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "I1"), (Expression)new Reference((Type)IntegerType.INTEGER, "I2")))), (Object)TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "I3"), (Expression)new Reference((Type)IntegerType.INTEGER, "I4")))))))), (Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "I1"), (Expression)new Reference((Type)IntegerType.INTEGER, "I2")), (Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "I3"), (Expression)new Reference((Type)IntegerType.INTEGER, "I4")))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes(TestSimplifyExpressions.not((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "I1"), (Expression)new Reference((Type)IntegerType.INTEGER, "I2")), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "B1"), (Object)new Reference((Type)BooleanType.BOOLEAN, "B2"))), (Object)TestSimplifyExpressions.not((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "B3"), (Object)new Reference((Type)BooleanType.BOOLEAN, "B4"))))))), (Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "I1"), (Expression)new Reference((Type)IntegerType.INTEGER, "I2")), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)TestSimplifyExpressions.not((Expression)new Reference((Type)BooleanType.BOOLEAN, "B1")), (Object)TestSimplifyExpressions.not((Expression)new Reference((Type)BooleanType.BOOLEAN, "B2")))), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "B3"), (Object)new Reference((Type)BooleanType.BOOLEAN, "B4"))))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)IntegerType.INTEGER, "I1"), (Expression)new Reference((Type)IntegerType.INTEGER, "I2")), (Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)IntegerType.INTEGER, "I1"), (Expression)new Reference((Type)IntegerType.INTEGER, "I2")));
        TestSimplifyExpressions.assertSimplifiesNumericTypes(TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "D1"), (Expression)new Reference((Type)DoubleType.DOUBLE, "D2"))), (Expression)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "D1"), (Expression)new Reference((Type)DoubleType.DOUBLE, "D2")));
        TestSimplifyExpressions.assertSimplifiesNumericTypes(TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "D1"), (Expression)new Reference((Type)DoubleType.DOUBLE, "D2"))), (Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "D1"), (Expression)new Reference((Type)DoubleType.DOUBLE, "D2")));
        TestSimplifyExpressions.assertSimplifiesNumericTypes(TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)RealType.REAL, "R1"), (Expression)new Reference((Type)RealType.REAL, "R2"))), (Expression)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)RealType.REAL, "R1"), (Expression)new Reference((Type)RealType.REAL, "R2")));
        TestSimplifyExpressions.assertSimplifiesNumericTypes(TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)RealType.REAL, "R1"), (Expression)new Reference((Type)RealType.REAL, "R2"))), (Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)RealType.REAL, "R1"), (Expression)new Reference((Type)RealType.REAL, "R2")));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "D1"), (Expression)new Reference((Type)DoubleType.DOUBLE, "D2")), (Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "D1"), (Expression)new Reference((Type)DoubleType.DOUBLE, "D2")));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)RealType.REAL, "R1"), (Expression)new Reference((Type)RealType.REAL, "R2")), (Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)RealType.REAL, "R1"), (Expression)new Reference((Type)RealType.REAL, "R2")));
        TestSimplifyExpressions.assertSimplifiesNumericTypes(TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "D1"), (Expression)new Reference((Type)DoubleType.DOUBLE, "D2"))), TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "D1"), (Expression)new Reference((Type)DoubleType.DOUBLE, "D2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes(TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "D1"), (Expression)new Reference((Type)DoubleType.DOUBLE, "D2"))), TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "D1"), (Expression)new Reference((Type)DoubleType.DOUBLE, "D2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes(TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "D1"), (Expression)new Reference((Type)DoubleType.DOUBLE, "D2"))), TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "D1"), (Expression)new Reference((Type)DoubleType.DOUBLE, "D2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes(TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "D1"), (Expression)new Reference((Type)DoubleType.DOUBLE, "D2"))), TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "D1"), (Expression)new Reference((Type)DoubleType.DOUBLE, "D2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes(TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)RealType.REAL, "R1"), (Expression)new Reference((Type)RealType.REAL, "R2"))), TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)RealType.REAL, "R1"), (Expression)new Reference((Type)RealType.REAL, "R2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes(TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)RealType.REAL, "R1"), (Expression)new Reference((Type)RealType.REAL, "R2"))), TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)RealType.REAL, "R1"), (Expression)new Reference((Type)RealType.REAL, "R2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes(TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)RealType.REAL, "R1"), (Expression)new Reference((Type)RealType.REAL, "R2"))), TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)RealType.REAL, "R1"), (Expression)new Reference((Type)RealType.REAL, "R2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes(TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)RealType.REAL, "R1"), (Expression)new Reference((Type)RealType.REAL, "R2"))), TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)RealType.REAL, "R1"), (Expression)new Reference((Type)RealType.REAL, "R2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes(TestSimplifyExpressions.not(TestSimplifyExpressions.not(TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "D1"), (Expression)new Reference((Type)DoubleType.DOUBLE, "D2"))))), TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "D1"), (Expression)new Reference((Type)DoubleType.DOUBLE, "D2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes(TestSimplifyExpressions.not(TestSimplifyExpressions.not(TestSimplifyExpressions.not(TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "D1"), (Expression)new Reference((Type)DoubleType.DOUBLE, "D2")))))), (Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)DoubleType.DOUBLE, "D1"), (Expression)new Reference((Type)DoubleType.DOUBLE, "D2")));
        TestSimplifyExpressions.assertSimplifiesNumericTypes(TestSimplifyExpressions.not(TestSimplifyExpressions.not(TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)RealType.REAL, "R1"), (Expression)new Reference((Type)RealType.REAL, "R2"))))), TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)RealType.REAL, "R1"), (Expression)new Reference((Type)RealType.REAL, "R2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes(TestSimplifyExpressions.not(TestSimplifyExpressions.not(TestSimplifyExpressions.not(TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)RealType.REAL, "R1"), (Expression)new Reference((Type)RealType.REAL, "R2")))))), (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)RealType.REAL, "R1"), (Expression)new Reference((Type)RealType.REAL, "R2")));
        TestSimplifyExpressions.assertSimplifiesNumericTypes(TestSimplifyExpressions.not((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "I1"), (Expression)new Reference((Type)IntegerType.INTEGER, "I2")), (Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "D1"), (Expression)new Reference((Type)DoubleType.DOUBLE, "D2"))))), (Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "I1"), (Expression)new Reference((Type)IntegerType.INTEGER, "I2")), (Object)TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "D1"), (Expression)new Reference((Type)DoubleType.DOUBLE, "D2"))))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes(TestSimplifyExpressions.not(TestSimplifyExpressions.not(TestSimplifyExpressions.not((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)TestSimplifyExpressions.not(TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)RealType.REAL, "R1"), (Expression)new Reference((Type)RealType.REAL, "R2")))), (Object)TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "I1"), (Expression)new Reference((Type)IntegerType.INTEGER, "I2")))))))), (Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)RealType.REAL, "R1"), (Expression)new Reference((Type)RealType.REAL, "R2"))), (Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "I1"), (Expression)new Reference((Type)IntegerType.INTEGER, "I2")))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes(TestSimplifyExpressions.not((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "D1"), (Expression)new Reference((Type)DoubleType.DOUBLE, "D2")), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "B1"), (Object)new Reference((Type)BooleanType.BOOLEAN, "B2"))), (Object)TestSimplifyExpressions.not((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "B3"), (Object)new Reference((Type)BooleanType.BOOLEAN, "B4"))))))), (Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "D1"), (Expression)new Reference((Type)DoubleType.DOUBLE, "D2"))), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)TestSimplifyExpressions.not((Expression)new Reference((Type)BooleanType.BOOLEAN, "B1")), (Object)TestSimplifyExpressions.not((Expression)new Reference((Type)BooleanType.BOOLEAN, "B2")))), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "B3"), (Object)new Reference((Type)BooleanType.BOOLEAN, "B4"))))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes(TestSimplifyExpressions.not((Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "D1"), (Expression)new Reference((Type)DoubleType.DOUBLE, "D2")), (Object)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "I1"), (Expression)new Reference((Type)IntegerType.INTEGER, "I2")))), (Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Reference((Type)BooleanType.BOOLEAN, "B1"), (Object)new Reference((Type)BooleanType.BOOLEAN, "B2"))), (Object)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)RealType.REAL, "R1"), (Expression)new Reference((Type)RealType.REAL, "R2"))))))), (Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "D1"), (Expression)new Reference((Type)DoubleType.DOUBLE, "D2"))), (Object)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "I1"), (Expression)new Reference((Type)IntegerType.INTEGER, "I2")))), (Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)TestSimplifyExpressions.not((Expression)new Reference((Type)BooleanType.BOOLEAN, "B1")), (Object)TestSimplifyExpressions.not((Expression)new Reference((Type)BooleanType.BOOLEAN, "B2")))), (Object)TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)RealType.REAL, "R1"), (Expression)new Reference((Type)RealType.REAL, "R2"))))))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes(IrExpressions.ifExpression((Expression)TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "I1"), (Expression)new Reference((Type)IntegerType.INTEGER, "I2"))), (Expression)new Reference((Type)DoubleType.DOUBLE, "D1"), (Expression)new Reference((Type)DoubleType.DOUBLE, "D2")), IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "I1"), (Expression)new Reference((Type)IntegerType.INTEGER, "I2")), (Expression)new Reference((Type)DoubleType.DOUBLE, "D1"), (Expression)new Reference((Type)DoubleType.DOUBLE, "D2")));
        TestSimplifyExpressions.assertSimplifiesNumericTypes(TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "D1"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)1.0))), TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "D1"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)1.0))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes(TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)1.0), (Expression)new Reference((Type)DoubleType.DOUBLE, "D2"))), TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)1.0), (Expression)new Reference((Type)DoubleType.DOUBLE, "D2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes(TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)RealType.REAL, "R1"), (Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)1.0f)))), TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)RealType.REAL, "R1"), (Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)1.0f)))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes(TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)1.0f)), (Expression)new Reference((Type)RealType.REAL, "R2"))), TestSimplifyExpressions.not((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Constant((Type)RealType.REAL, (Object)Reals.toReal((float)1.0f)), (Expression)new Reference((Type)RealType.REAL, "R2"))));
    }

    private static void assertSimplifiesNumericTypes(Expression expression, Expression expected) {
        Expression rewritten = SimplifyExpressions.rewrite((Expression)expression, (Session)SessionTestUtils.TEST_SESSION, (IrExpressionOptimizer)IrExpressionOptimizer.newOptimizer((PlannerContext)TestingPlannerContext.PLANNER_CONTEXT));
        Assertions.assertThat((Object)TestSimplifyExpressions.normalize(rewritten)).isEqualTo((Object)TestSimplifyExpressions.normalize(expected));
    }

    private static Expression normalize(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new NormalizeExpressionRewriter(), (Expression)expression);
    }

    private static Expression not(Expression value) {
        return IrExpressions.not((Metadata)FUNCTIONS.getMetadata(), (Expression)value);
    }

    private static class NormalizeExpressionRewriter
    extends ExpressionRewriter<Void> {
        private NormalizeExpressionRewriter() {
        }

        public Expression rewriteLogical(Logical node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            List predicates = IrUtils.extractPredicates((Logical.Operator)node.operator(), (Expression)node).stream().map(p -> treeRewriter.rewrite(p, (Object)context)).sorted(Comparator.comparing(Expression::toString)).collect(Collectors.toList());
            return IrUtils.logicalExpression((Logical.Operator)node.operator(), predicates);
        }

        public Expression rewriteCast(Cast node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            return new Cast(node.expression(), node.type());
        }
    }
}

