/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.connector.MockConnector;
import io.trino.connector.MockConnectorColumnHandle;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorTableHandle;
import io.trino.connector.MockConnectorTransactionHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorTableLayout;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableProcedureExecutionMode;
import io.trino.spi.connector.TableProcedureMetadata;
import io.trino.spi.connector.WriterScalingOptions;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.statistics.ColumnStatistics;
import io.trino.spi.statistics.Estimate;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.TableExecuteNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.testing.PlanTester;
import io.trino.testing.TestingSession;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestAddLocalExchangesForTaskScaleWriters
extends BasePlanTest {
    private static final ConnectorPartitioningHandle CONNECTOR_PARTITIONING_HANDLE = new ConnectorPartitioningHandle(){};

    @Override
    protected PlanTester createPlanTester() {
        PlanTester planTester = PlanTester.create((Session)TestingSession.testSessionBuilder().build());
        planTester.createCatalog("mock_with_scaled_writers", (ConnectorFactory)this.createConnectorFactory("mock_with_scaled_writers", true, true), (Map)ImmutableMap.of());
        planTester.createCatalog("mock_without_scaled_writers", (ConnectorFactory)this.createConnectorFactory("mock_without_scaled_writers", true, false), (Map)ImmutableMap.of());
        planTester.createCatalog("mock_without_multiple_writer_per_partition", (ConnectorFactory)this.createConnectorFactory("mock_without_multiple_writer_per_partition", false, true), (Map)ImmutableMap.of());
        return planTester;
    }

    private MockConnectorFactory createConnectorFactory(String catalogHandle, boolean supportsMultipleWritersPerPartition, boolean writerScalingEnabledWithinTask) {
        return MockConnectorFactory.builder().withGetTableHandle((session, tableName) -> {
            if (tableName.getTableName().equals("source_table") || tableName.getTableName().equals("system_partitioned_table") || tableName.getTableName().equals("connector_partitioned_table") || tableName.getTableName().equals("unpartitioned_table")) {
                return new MockConnectorTableHandle((SchemaTableName)tableName);
            }
            return null;
        }).withWriterScalingOptions(new WriterScalingOptions(true, writerScalingEnabledWithinTask)).withGetTableStatistics(tableName -> {
            if (tableName.getTableName().equals("source_table")) {
                return new TableStatistics(Estimate.of((double)100.0), (Map)ImmutableMap.of((Object)new MockConnectorColumnHandle("year", (Type)IntegerType.INTEGER), (Object)new ColumnStatistics(Estimate.of((double)0.0), Estimate.of((double)10.0), Estimate.of((double)100.0), Optional.empty())));
            }
            return TableStatistics.empty();
        }).withGetLayoutForTableExecute((session, tableHandle) -> {
            MockConnector.MockConnectorTableExecuteHandle tableExecuteHandle = (MockConnector.MockConnectorTableExecuteHandle)tableHandle;
            if (tableExecuteHandle.getSchemaTableName().getTableName().equals("system_partitioned_table")) {
                return Optional.of(new ConnectorTableLayout((List)ImmutableList.of((Object)"year")));
            }
            return Optional.empty();
        }).withTableProcedures((Iterable<TableProcedureMetadata>)ImmutableSet.of((Object)new TableProcedureMetadata("OPTIMIZE", TableProcedureExecutionMode.distributedWithFilteringAndRepartitioning(), (List)ImmutableList.of((Object)PropertyMetadata.stringProperty((String)"file_size_threshold", (String)"file_size_threshold", (String)"10GB", (boolean)false))))).withGetColumns(schemaTableName -> ImmutableList.of((Object)new ColumnMetadata("customer", (Type)IntegerType.INTEGER), (Object)new ColumnMetadata("year", (Type)IntegerType.INTEGER))).withGetInsertLayout((session, tableName) -> {
            if (tableName.getTableName().equals("system_partitioned_table")) {
                return Optional.of(new ConnectorTableLayout((List)ImmutableList.of((Object)"year")));
            }
            if (tableName.getTableName().equals("connector_partitioned_table")) {
                return Optional.of(new ConnectorTableLayout(CONNECTOR_PARTITIONING_HANDLE, (List)ImmutableList.of((Object)"year"), supportsMultipleWritersPerPartition));
            }
            return Optional.empty();
        }).withName(catalogHandle).build();
    }

    @Test
    public void testLocalScaledUnpartitionedWriterDistribution() {
        this.assertDistributedPlan("INSERT INTO unpartitioned_table SELECT * FROM source_table", TestingSession.testSessionBuilder().setCatalog("mock_without_multiple_writer_per_partition").setSchema("mock").setSystemProperty("task_scale_writers_enabled", "true").setSystemProperty("scale_writers", "false").build(), PlanMatchPattern.anyTree(PlanMatchPattern.tableWriter((List<String>)ImmutableList.of((Object)"customer", (Object)"year"), (List<String>)ImmutableList.of((Object)"customer", (Object)"year"), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, SystemPartitioningHandle.SCALED_WRITER_ROUND_ROBIN_DISTRIBUTION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION, PlanMatchPattern.tableScan("source_table", (Map<String, String>)ImmutableMap.of((Object)"customer", (Object)"customer", (Object)"year", (Object)"year")))))));
        this.assertDistributedPlan("INSERT INTO unpartitioned_table SELECT * FROM source_table", TestingSession.testSessionBuilder().setCatalog("mock_without_multiple_writer_per_partition").setSchema("mock").setSystemProperty("task_scale_writers_enabled", "false").setSystemProperty("scale_writers", "false").build(), PlanMatchPattern.anyTree(PlanMatchPattern.tableWriter((List<String>)ImmutableList.of((Object)"customer", (Object)"year"), (List<String>)ImmutableList.of((Object)"customer", (Object)"year"), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, SystemPartitioningHandle.SINGLE_DISTRIBUTION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION, PlanMatchPattern.tableScan("source_table", (Map<String, String>)ImmutableMap.of((Object)"customer", (Object)"customer", (Object)"year", (Object)"year")))))));
    }

    @Test
    public void testLocalScaledUnpartitionedWriterWithPerTaskScalingDisabled() {
        this.assertDistributedPlan("INSERT INTO unpartitioned_table SELECT * FROM source_table", TestingSession.testSessionBuilder().setCatalog("mock_without_scaled_writers").setSchema("mock").setSystemProperty("task_scale_writers_enabled", "true").setSystemProperty("scale_writers", "false").build(), PlanMatchPattern.anyTree(PlanMatchPattern.tableWriter((List<String>)ImmutableList.of((Object)"customer", (Object)"year"), (List<String>)ImmutableList.of((Object)"customer", (Object)"year"), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, SystemPartitioningHandle.SINGLE_DISTRIBUTION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION, PlanMatchPattern.tableScan("source_table", (Map<String, String>)ImmutableMap.of((Object)"customer", (Object)"customer", (Object)"year", (Object)"year")))))));
        this.assertDistributedPlan("INSERT INTO unpartitioned_table SELECT * FROM source_table", TestingSession.testSessionBuilder().setCatalog("mock_without_scaled_writers").setSchema("mock").setSystemProperty("task_scale_writers_enabled", "false").setSystemProperty("scale_writers", "false").build(), PlanMatchPattern.anyTree(PlanMatchPattern.tableWriter((List<String>)ImmutableList.of((Object)"customer", (Object)"year"), (List<String>)ImmutableList.of((Object)"customer", (Object)"year"), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, SystemPartitioningHandle.SINGLE_DISTRIBUTION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION, PlanMatchPattern.tableScan("source_table", (Map<String, String>)ImmutableMap.of((Object)"customer", (Object)"customer", (Object)"year", (Object)"year")))))));
    }

    @Test
    public void testLocalScaledPartitionedWriterWithoutSupportForMultipleWritersPerPartition() {
        for (boolean taskScaleWritersEnabled : Arrays.asList(true, false)) {
            String catalogName = "mock_without_multiple_writer_per_partition";
            PartitioningHandle partitioningHandle = new PartitioningHandle(Optional.of(this.getCatalogHandle(catalogName)), Optional.of(MockConnectorTransactionHandle.INSTANCE), CONNECTOR_PARTITIONING_HANDLE);
            this.assertDistributedPlan("INSERT INTO connector_partitioned_table SELECT * FROM source_table", TestingSession.testSessionBuilder().setCatalog(catalogName).setSchema("mock").setSystemProperty("task_scale_writers_enabled", String.valueOf(taskScaleWritersEnabled)).setSystemProperty("scale_writers", "false").build(), PlanMatchPattern.anyTree(PlanMatchPattern.tableWriter((List<String>)ImmutableList.of((Object)"customer", (Object)"year"), (List<String>)ImmutableList.of((Object)"customer", (Object)"year"), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, partitioningHandle, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, partitioningHandle, PlanMatchPattern.tableScan("source_table", (Map<String, String>)ImmutableMap.of((Object)"customer", (Object)"customer", (Object)"year", (Object)"year")))))));
        }
    }

    @Test
    public void testLocalScaledPartitionedWriterWithPerTaskScalingDisabled() {
        for (boolean taskScaleWritersEnabled : Arrays.asList(true, false)) {
            String catalogName = "mock_without_scaled_writers";
            PartitioningHandle partitioningHandle = new PartitioningHandle(Optional.of(this.getCatalogHandle(catalogName)), Optional.of(MockConnectorTransactionHandle.INSTANCE), CONNECTOR_PARTITIONING_HANDLE);
            this.assertDistributedPlan("INSERT INTO connector_partitioned_table SELECT * FROM source_table", TestingSession.testSessionBuilder().setCatalog(catalogName).setSchema("mock").setSystemProperty("task_scale_writers_enabled", String.valueOf(taskScaleWritersEnabled)).setSystemProperty("scale_writers", "false").build(), PlanMatchPattern.anyTree(PlanMatchPattern.tableWriter((List<String>)ImmutableList.of((Object)"customer", (Object)"year"), (List<String>)ImmutableList.of((Object)"customer", (Object)"year"), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, partitioningHandle, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, partitioningHandle, PlanMatchPattern.tableScan("source_table", (Map<String, String>)ImmutableMap.of((Object)"customer", (Object)"customer", (Object)"year", (Object)"year")))))));
        }
    }

    @Test
    public void testLocalScaledPartitionedWriterForSystemPartitioningWithEnforcedPreferredPartitioning() {
        this.assertDistributedPlan("INSERT INTO system_partitioned_table SELECT * FROM source_table", TestingSession.testSessionBuilder().setCatalog("mock_with_scaled_writers").setSchema("mock").setSystemProperty("use_preferred_write_partitioning", "true").setSystemProperty("task_scale_writers_enabled", "true").setSystemProperty("scale_writers", "false").build(), PlanMatchPattern.anyTree(PlanMatchPattern.tableWriter((List<String>)ImmutableList.of((Object)"customer", (Object)"year"), (List<String>)ImmutableList.of((Object)"customer", (Object)"year"), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, SystemPartitioningHandle.SCALED_WRITER_HASH_DISTRIBUTION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, PlanMatchPattern.tableScan("source_table", (Map<String, String>)ImmutableMap.of((Object)"customer", (Object)"customer", (Object)"year", (Object)"year")))))));
        this.assertDistributedPlan("INSERT INTO system_partitioned_table SELECT * FROM source_table", TestingSession.testSessionBuilder().setCatalog("mock_with_scaled_writers").setSchema("mock").setSystemProperty("use_preferred_write_partitioning", "true").setSystemProperty("task_scale_writers_enabled", "false").setSystemProperty("scale_writers", "false").build(), PlanMatchPattern.anyTree(PlanMatchPattern.tableWriter((List<String>)ImmutableList.of((Object)"customer", (Object)"year"), (List<String>)ImmutableList.of((Object)"customer", (Object)"year"), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, PlanMatchPattern.tableScan("source_table", (Map<String, String>)ImmutableMap.of((Object)"customer", (Object)"customer", (Object)"year", (Object)"year")))))));
    }

    @Test
    public void testLocalScaledPartitionedWriterForConnectorPartitioning() {
        String catalogName = "mock_with_scaled_writers";
        PartitioningHandle partitioningHandle = new PartitioningHandle(Optional.of(this.getCatalogHandle(catalogName)), Optional.of(MockConnectorTransactionHandle.INSTANCE), CONNECTOR_PARTITIONING_HANDLE);
        PartitioningHandle scaledPartitioningHandle = new PartitioningHandle(Optional.of(this.getCatalogHandle(catalogName)), Optional.of(MockConnectorTransactionHandle.INSTANCE), CONNECTOR_PARTITIONING_HANDLE, true);
        this.assertDistributedPlan("INSERT INTO connector_partitioned_table SELECT * FROM source_table", TestingSession.testSessionBuilder().setCatalog(catalogName).setSchema("mock").setSystemProperty("task_scale_writers_enabled", "true").setSystemProperty("scale_writers", "false").build(), PlanMatchPattern.anyTree(PlanMatchPattern.tableWriter((List<String>)ImmutableList.of((Object)"customer", (Object)"year"), (List<String>)ImmutableList.of((Object)"customer", (Object)"year"), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, scaledPartitioningHandle, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, partitioningHandle, PlanMatchPattern.tableScan("source_table", (Map<String, String>)ImmutableMap.of((Object)"customer", (Object)"customer", (Object)"year", (Object)"year")))))));
        this.assertDistributedPlan("INSERT INTO connector_partitioned_table SELECT * FROM source_table", TestingSession.testSessionBuilder().setCatalog(catalogName).setSchema("mock").setSystemProperty("task_scale_writers_enabled", "false").setSystemProperty("scale_writers", "false").build(), PlanMatchPattern.anyTree(PlanMatchPattern.tableWriter((List<String>)ImmutableList.of((Object)"customer", (Object)"year"), (List<String>)ImmutableList.of((Object)"customer", (Object)"year"), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, partitioningHandle, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, partitioningHandle, PlanMatchPattern.tableScan("source_table", (Map<String, String>)ImmutableMap.of((Object)"customer", (Object)"customer", (Object)"year", (Object)"year")))))));
    }

    @Test
    public void testLocalScaledPartitionedWriterWithEnforcedLocalPreferredPartitioning() {
        this.assertDistributedPlan("INSERT INTO system_partitioned_table SELECT * FROM source_table", TestingSession.testSessionBuilder().setCatalog("mock_with_scaled_writers").setSchema("mock").setSystemProperty("task_scale_writers_enabled", "true").setSystemProperty("scale_writers", "false").build(), PlanMatchPattern.anyTree(PlanMatchPattern.tableWriter((List<String>)ImmutableList.of((Object)"customer", (Object)"year"), (List<String>)ImmutableList.of((Object)"customer", (Object)"year"), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, SystemPartitioningHandle.SCALED_WRITER_HASH_DISTRIBUTION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, PlanMatchPattern.tableScan("source_table", (Map<String, String>)ImmutableMap.of((Object)"customer", (Object)"customer", (Object)"year", (Object)"year")))))));
        this.assertDistributedPlan("INSERT INTO system_partitioned_table SELECT * FROM source_table", TestingSession.testSessionBuilder().setCatalog("mock_with_scaled_writers").setSchema("mock").setSystemProperty("task_scale_writers_enabled", "false").setSystemProperty("scale_writers", "false").build(), PlanMatchPattern.anyTree(PlanMatchPattern.tableWriter((List<String>)ImmutableList.of((Object)"customer", (Object)"year"), (List<String>)ImmutableList.of((Object)"customer", (Object)"year"), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, PlanMatchPattern.tableScan("source_table", (Map<String, String>)ImmutableMap.of((Object)"customer", (Object)"customer", (Object)"year", (Object)"year")))))));
    }

    @Test
    public void testTableExecuteLocalScalingDisabledForPartitionedTable() {
        String query = "ALTER TABLE system_partitioned_table EXECUTE optimize(file_size_threshold => '10MB')";
        Session session = Session.builder((Session)this.getPlanTester().getDefaultSession()).setCatalog("mock_with_scaled_writers").setSchema("mock").setSystemProperty("task_scale_writers_enabled", "true").build();
        this.assertDistributedPlan(query, session, PlanMatchPattern.anyTree(PlanMatchPattern.node(TableExecuteNode.class, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]))))));
    }

    @Test
    public void testTableExecuteLocalScalingDisabledForUnpartitionedTable() {
        String query = "ALTER TABLE unpartitioned_table EXECUTE optimize(file_size_threshold => '10MB')";
        Session session = Session.builder((Session)this.getPlanTester().getDefaultSession()).setCatalog("mock_with_scaled_writers").setSchema("mock").setSystemProperty("task_scale_writers_enabled", "true").build();
        this.assertDistributedPlan(query, session, PlanMatchPattern.anyTree(PlanMatchPattern.node(TableExecuteNode.class, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, SystemPartitioningHandle.SINGLE_DISTRIBUTION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, SystemPartitioningHandle.SCALED_WRITER_ROUND_ROBIN_DISTRIBUTION, PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]))))));
    }
}

