/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.rowpattern;

import io.trino.sql.planner.rowpattern.IrPatternAlternationOptimizer;
import io.trino.sql.planner.rowpattern.IrRowPatternFlattener;
import io.trino.sql.planner.rowpattern.Patterns;
import io.trino.sql.planner.rowpattern.ir.IrRowPattern;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestIrRowPatternOptimization {
    @Test
    public void testFlattenAlternation() {
        this.assertFlattened(Patterns.alternation(new IrRowPattern[]{Patterns.label("A"), Patterns.alternation(new IrRowPattern[]{Patterns.label("B"), Patterns.label("C")})}), Patterns.alternation(new IrRowPattern[]{Patterns.label("A"), Patterns.label("B"), Patterns.label("C")}));
        this.assertFlattened(Patterns.alternation(Patterns.alternation(new IrRowPattern[]{Patterns.label("A"), Patterns.alternation(Patterns.alternation(new IrRowPattern[]{Patterns.label("B"), Patterns.label("C")}), Patterns.alternation(new IrRowPattern[]{Patterns.label("D"), Patterns.label("E")}))}), Patterns.alternation(new IrRowPattern[]{Patterns.label("F"), Patterns.label("G")})), Patterns.alternation(new IrRowPattern[]{Patterns.label("A"), Patterns.label("B"), Patterns.label("C"), Patterns.label("D"), Patterns.label("E"), Patterns.label("F"), Patterns.label("G")}));
    }

    @Test
    public void testOptimizeAlternation() {
        this.assertOptimized(Patterns.alternation(new IrRowPattern[]{Patterns.alternation(new IrRowPattern[]{Patterns.label("A"), Patterns.empty()}), Patterns.label("B")}), Patterns.alternation(new IrRowPattern[]{Patterns.questionMarkQuantified((IrRowPattern)Patterns.label("A"), true), Patterns.label("B")}));
        this.assertOptimized(Patterns.alternation(new IrRowPattern[]{Patterns.alternation(new IrRowPattern[]{Patterns.empty(), Patterns.label("A")}), Patterns.label("B")}), Patterns.alternation(new IrRowPattern[]{Patterns.questionMarkQuantified((IrRowPattern)Patterns.label("A"), false), Patterns.label("B")}));
    }

    @Test
    public void testFlattenAndOptimizeAlternation() {
        this.assertFlattenedOptimized(Patterns.alternation(new IrRowPattern[]{Patterns.alternation(new IrRowPattern[]{Patterns.label("A"), Patterns.label("B")}), Patterns.label("C")}), Patterns.alternation(new IrRowPattern[]{Patterns.label("A"), Patterns.label("B"), Patterns.label("C")}));
        this.assertFlattenedOptimized(Patterns.alternation(Patterns.alternation(new IrRowPattern[]{Patterns.label("A"), Patterns.label("B")}), Patterns.empty()), Patterns.alternation(new IrRowPattern[]{Patterns.label("A"), Patterns.questionMarkQuantified((IrRowPattern)Patterns.label("B"), true)}));
        this.assertFlattenedOptimized(Patterns.alternation(Patterns.alternation(new IrRowPattern[]{Patterns.empty(), Patterns.label("A")}), Patterns.empty()), Patterns.questionMarkQuantified((IrRowPattern)Patterns.label("A"), false));
        this.assertFlattenedOptimized(Patterns.alternation(Patterns.empty(), Patterns.empty()), Patterns.empty());
        this.assertFlattenedOptimized(Patterns.alternation(new IrRowPattern[]{Patterns.alternation(new IrRowPattern[]{Patterns.label("A"), Patterns.alternation(Patterns.alternation(Patterns.empty(), Patterns.alternation(new IrRowPattern[]{Patterns.alternation(new IrRowPattern[]{Patterns.label("B"), Patterns.empty()}), Patterns.label("C")})), Patterns.empty())}), Patterns.label("D")}), Patterns.alternation(new IrRowPattern[]{Patterns.questionMarkQuantified((IrRowPattern)Patterns.label("A"), true), Patterns.label("B"), Patterns.label("C"), Patterns.label("D")}));
    }

    @Test
    public void testFlattenConcatenation() {
        this.assertFlattened(Patterns.concatenation(new IrRowPattern[]{Patterns.concatenation(new IrRowPattern[]{Patterns.label("A"), Patterns.label("B")}), Patterns.label("C")}), Patterns.concatenation(new IrRowPattern[]{Patterns.label("A"), Patterns.label("B"), Patterns.label("C")}));
        this.assertFlattened(Patterns.concatenation(new IrRowPattern[]{Patterns.concatenation(Patterns.concatenation(new IrRowPattern[]{Patterns.label("A"), Patterns.label("B")}), Patterns.empty()), Patterns.label("C")}), Patterns.concatenation(new IrRowPattern[]{Patterns.label("A"), Patterns.label("B"), Patterns.label("C")}));
        this.assertFlattened(Patterns.concatenation(new IrRowPattern[]{Patterns.concatenation(new IrRowPattern[]{Patterns.concatenation(new IrRowPattern[]{Patterns.empty(), Patterns.label("A")}), Patterns.label("B")}), Patterns.label("C")}), Patterns.concatenation(new IrRowPattern[]{Patterns.label("A"), Patterns.label("B"), Patterns.label("C")}));
        this.assertFlattened(Patterns.concatenation(Patterns.concatenation(new IrRowPattern[]{Patterns.concatenation(Patterns.concatenation(new IrRowPattern[]{Patterns.concatenation(Patterns.concatenation(new IrRowPattern[]{Patterns.empty(), Patterns.label("A")}), Patterns.empty()), Patterns.label("B")}), Patterns.empty()), Patterns.label("C")}), Patterns.empty()), Patterns.concatenation(new IrRowPattern[]{Patterns.label("A"), Patterns.label("B"), Patterns.label("C")}));
        this.assertFlattened(Patterns.concatenation(new IrRowPattern[]{Patterns.empty(), Patterns.label("A")}), (IrRowPattern)Patterns.label("A"));
        this.assertFlattened(Patterns.concatenation(new IrRowPattern[]{Patterns.label("A"), Patterns.empty()}), (IrRowPattern)Patterns.label("A"));
        this.assertFlattened(Patterns.concatenation(Patterns.concatenation(Patterns.empty(), Patterns.empty()), Patterns.empty()), Patterns.empty());
        this.assertFlattened(Patterns.concatenation(new IrRowPattern[]{Patterns.label("A"), Patterns.concatenation(new IrRowPattern[]{Patterns.label("B"), Patterns.label("C")})}), Patterns.concatenation(new IrRowPattern[]{Patterns.label("A"), Patterns.label("B"), Patterns.label("C")}));
        this.assertFlattened(Patterns.concatenation(Patterns.concatenation(new IrRowPattern[]{Patterns.label("A"), Patterns.concatenation(new IrRowPattern[]{Patterns.concatenation(new IrRowPattern[]{Patterns.concatenation(new IrRowPattern[]{Patterns.label("B"), Patterns.label("C")}), Patterns.label("D")}), Patterns.label("E")})}), Patterns.concatenation(new IrRowPattern[]{Patterns.label("F"), Patterns.label("G")})), Patterns.concatenation(new IrRowPattern[]{Patterns.label("A"), Patterns.label("B"), Patterns.label("C"), Patterns.label("D"), Patterns.label("E"), Patterns.label("F"), Patterns.label("G")}));
    }

    @Test
    public void testFlattenPermutation() {
        this.assertFlattened(Patterns.permutation(new IrRowPattern[]{Patterns.label("A"), Patterns.label("B"), Patterns.label("C")}), Patterns.permutation(new IrRowPattern[]{Patterns.label("A"), Patterns.label("B"), Patterns.label("C")}));
        this.assertFlattened(Patterns.permutation(new IrRowPattern[]{Patterns.label("A"), Patterns.label("B"), Patterns.empty()}), Patterns.permutation(new IrRowPattern[]{Patterns.label("A"), Patterns.label("B")}));
        this.assertFlattened(Patterns.permutation(new IrRowPattern[]{Patterns.empty(), Patterns.label("A"), Patterns.empty(), Patterns.label("B"), Patterns.empty(), Patterns.label("C"), Patterns.empty()}), Patterns.permutation(new IrRowPattern[]{Patterns.label("A"), Patterns.label("B"), Patterns.label("C")}));
        this.assertFlattened(Patterns.permutation(new IrRowPattern[]{Patterns.empty(), Patterns.label("A")}), (IrRowPattern)Patterns.label("A"));
        this.assertFlattened(Patterns.permutation(new IrRowPattern[]{Patterns.label("A"), Patterns.empty()}), (IrRowPattern)Patterns.label("A"));
        this.assertFlattened(Patterns.permutation(Patterns.empty(), Patterns.empty(), Patterns.empty()), Patterns.empty());
    }

    @Test
    public void testFlattenAndOptimize() {
        this.assertFlattenedOptimized(Patterns.alternation(Patterns.concatenation(Patterns.empty(), Patterns.alternation(new IrRowPattern[]{Patterns.label("A"), Patterns.label("B")})), Patterns.alternation(Patterns.concatenation(Patterns.concatenation(Patterns.empty(), Patterns.empty()), Patterns.empty()), Patterns.alternation(new IrRowPattern[]{Patterns.label("C"), Patterns.empty()}))), Patterns.alternation(new IrRowPattern[]{Patterns.label("A"), Patterns.questionMarkQuantified((IrRowPattern)Patterns.label("B"), true), Patterns.label("C")}));
    }

    @Test
    public void testRemoveNestedExclusions() {
        this.assertFlattened(Patterns.excluded(Patterns.excluded(Patterns.excluded(Patterns.excluded((IrRowPattern)Patterns.label("A"))))), Patterns.excluded((IrRowPattern)Patterns.label("A")));
    }

    @Test
    public void testEmptyPattern() {
        this.assertFlattened(Patterns.empty(), Patterns.empty());
        this.assertOptimized(Patterns.empty(), Patterns.empty());
    }

    @Test
    public void testFlattenQuantifiedEmptyPattern() {
        this.assertFlattened(Patterns.starQuantified(Patterns.empty(), true), Patterns.empty());
        this.assertFlattened(Patterns.plusQuantified(Patterns.empty(), true), Patterns.empty());
        this.assertFlattened(Patterns.questionMarkQuantified(Patterns.starQuantified(Patterns.plusQuantified(Patterns.empty(), true), true), true), Patterns.empty());
        this.assertFlattened(Patterns.rangeQuantified(Patterns.empty(), 1, Optional.of(2), true), Patterns.empty());
        this.assertFlattened(Patterns.rangeQuantified(Patterns.empty(), 0, Optional.empty(), false), Patterns.empty());
    }

    private void assertFlattened(IrRowPattern pattern, IrRowPattern expected) {
        IrRowPattern flattened = IrRowPatternFlattener.optimize((IrRowPattern)pattern);
        Assertions.assertThat((Object)flattened).isEqualTo((Object)expected);
    }

    private void assertOptimized(IrRowPattern pattern, IrRowPattern expected) {
        IrRowPattern optimized = IrPatternAlternationOptimizer.optimize((IrRowPattern)pattern);
        Assertions.assertThat((Object)optimized).isEqualTo((Object)expected);
    }

    private void assertFlattenedOptimized(IrRowPattern pattern, IrRowPattern expected) {
        IrRowPattern flattened = IrRowPatternFlattener.optimize((IrRowPattern)pattern);
        IrRowPattern optimized = IrPatternAlternationOptimizer.optimize((IrRowPattern)flattened);
        Assertions.assertThat((Object)optimized).isEqualTo((Object)expected);
    }
}

