/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.spi.security.Identity;
import io.trino.sql.SqlPath;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.TestingSession;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestSessionFunctions {
    @Test
    public void testCurrentUser() {
        Session session = TestingSession.testSessionBuilder().setIdentity(Identity.ofUser((String)"test_current_user")).build();
        try (QueryAssertions queryAssertions = new QueryAssertions(session);){
            ((QueryAssertions.QueryAssert)Assertions.assertThat(queryAssertions.query("SELECT CURRENT_USER"))).matches("SELECT CAST('" + session.getUser() + "' AS VARCHAR)");
        }
    }

    @Test
    public void testCurrentPath() {
        Session session = TestingSession.testSessionBuilder().setPath(SqlPath.buildPath((String)"testPath", Optional.empty())).build();
        try (QueryAssertions queryAssertions = new QueryAssertions(session);){
            ((QueryAssertions.QueryAssert)Assertions.assertThat(queryAssertions.query("SELECT CURRENT_PATH"))).matches("SELECT CAST('" + session.getPath().toString() + "' AS VARCHAR)");
        }
        Session emptyPathSession = TestingSession.testSessionBuilder().setPath(SqlPath.EMPTY_PATH).build();
        try (QueryAssertions queryAssertions = new QueryAssertions(emptyPathSession);){
            ((QueryAssertions.QueryAssert)Assertions.assertThat(queryAssertions.query("SELECT CURRENT_PATH"))).matches("VALUES VARCHAR ''");
        }
    }

    @Test
    public void testCurrentCatalog() {
        try (QueryAssertions assertions = new QueryAssertions();){
            Session session = TestingSession.testSessionBuilder().setCatalog("trino_rocks").build();
            ((QueryAssertions.QueryAssert)Assertions.assertThat(assertions.query(session, "SELECT CURRENT_CATALOG"))).matches("VALUES CAST('" + (String)session.getCatalog().get() + "' AS VARCHAR)");
            session = TestingSession.testSessionBuilder().setCatalog(Optional.empty()).setSchema(Optional.empty()).build();
            ((QueryAssertions.QueryAssert)Assertions.assertThat(assertions.query(session, "SELECT CURRENT_CATALOG"))).matches("VALUES CAST(NULL AS VARCHAR)");
        }
    }

    @Test
    public void testCurrentSchema() {
        try (QueryAssertions assertions = new QueryAssertions();){
            Session session = TestingSession.testSessionBuilder().setSchema("trino_rocks").build();
            ((QueryAssertions.QueryAssert)Assertions.assertThat(assertions.query(session, "SELECT CURRENT_SCHEMA"))).matches("VALUES CAST('" + (String)session.getSchema().get() + "' AS VARCHAR)");
            session = TestingSession.testSessionBuilder().setSchema(Optional.empty()).build();
            ((QueryAssertions.QueryAssert)Assertions.assertThat(assertions.query(session, "SELECT CURRENT_SCHEMA"))).matches("VALUES CAST(NULL AS VARCHAR)");
        }
    }

    @Test
    public void testCurrentGroups() {
        Identity identityWithoutGroups = Identity.ofUser((String)"test_current_user");
        Session session = TestingSession.testSessionBuilder().setIdentity(identityWithoutGroups).build();
        try (QueryAssertions queryAssertions = new QueryAssertions(session);){
            ((QueryAssertions.QueryAssert)Assertions.assertThat(queryAssertions.query("SELECT current_groups()"))).matches("SELECT CAST(ARRAY[] AS ARRAY(VARCHAR))");
        }
        ImmutableSet groups = ImmutableSet.of((Object)"group_a", (Object)"group_b");
        Identity identityWithGroups = new Identity.Builder("test_current_user").withGroups((Set)groups).build();
        session = TestingSession.testSessionBuilder().setIdentity(identityWithGroups).build();
        try (QueryAssertions queryAssertions = new QueryAssertions(session);){
            ((QueryAssertions.QueryAssert)Assertions.assertThat(queryAssertions.query("SELECT array_sort(current_groups())"))).matches(String.format("SELECT CAST(ARRAY[%s] AS ARRAY(VARCHAR))", groups.stream().map(e -> String.format("'%s'", e)).collect(Collectors.joining(","))));
        }
    }
}

