/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.sql.query.QueryAssertions;
import java.math.BigInteger;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestWindowFrameRows {
    private final QueryAssertions assertions = new QueryAssertions();

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testOffsetTypes() {
        String expected = "VALUES ARRAY[null, null, 1], ARRAY[null, null, 1, 2], ARRAY[null, 1, 2, 2], ARRAY[1, 2, 2], ARRAY[2, 2]";
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT array_agg(a) OVER(ORDER BY a ASC NULLS FIRST ROWS BETWEEN TINYINT '1' PRECEDING AND TINYINT '2' FOLLOWING) FROM (VALUES 2, 2, 1, null, null) t(a)"))).matches(expected);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT array_agg(a) OVER(ORDER BY a ASC NULLS FIRST ROWS BETWEEN SMALLINT '1' PRECEDING AND SMALLINT '2' FOLLOWING) FROM (VALUES 2, 2, 1, null, null) t(a)"))).matches(expected);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT array_agg(a) OVER(ORDER BY a ASC NULLS FIRST ROWS BETWEEN INTEGER '1' PRECEDING AND INTEGER '2' FOLLOWING) FROM (VALUES 2, 2, 1, null, null) t(a)"))).matches(expected);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT array_agg(a) OVER(ORDER BY a ASC NULLS FIRST ROWS BETWEEN BIGINT '1' PRECEDING AND BIGINT '2' FOLLOWING) FROM (VALUES 2, 2, 1, null, null) t(a)"))).matches(expected);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT array_agg(a) OVER(ORDER BY a ASC NULLS FIRST ROWS BETWEEN DECIMAL '1' PRECEDING AND DECIMAL '2' FOLLOWING) FROM (VALUES 2, 2, 1, null, null) t(a)"))).matches(expected);
        expected = "VALUES ARRAY[null, null, 1, 2, 2], ARRAY[null, null, 1, 2, 2], ARRAY[null, 1, 2, 2], ARRAY[1, 2, 2], ARRAY[2, 2]";
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format("SELECT array_agg(a) OVER(ORDER BY a ASC NULLS FIRST ROWS BETWEEN 1 PRECEDING AND DECIMAL '%d' FOLLOWING) FROM (VALUES 2, 2, 1, null, null) t(a)", 0x80000000L)))).matches(expected);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format("SELECT array_agg(a) OVER(ORDER BY a ASC NULLS FIRST ROWS BETWEEN 1 PRECEDING AND DECIMAL '%d' FOLLOWING) FROM (VALUES 2, 2, 1, null, null) t(a)", Long.MAX_VALUE)))).matches(expected);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format("SELECT array_agg(a) OVER(ORDER BY a ASC NULLS FIRST ROWS BETWEEN 1 PRECEDING AND DECIMAL '%s' FOLLOWING) FROM (VALUES 2, 2, 1, null, null) t(a)", BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE))))).matches(expected);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT array_agg(a) OVER(ORDER BY a ASC NULLS FIRST ROWS BETWEEN 1 PRECEDING AND DECIMAL '999999999999999999999999999999' FOLLOWING) FROM (VALUES 2, 2, 1, null, null) t(a)"))).matches(expected);
    }
}

