/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestBigintOperators {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testLiteral() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("100000000037")))).isEqualTo(100000000037L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("100000000017")))).isEqualTo(100000000017L);
    }

    @Test
    public void testTypeConstructor() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("BIGINT '9223372036854775807'")))).isEqualTo(Long.MAX_VALUE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("BIGINT '-9223372036854775807'")))).isEqualTo(-9223372036854775807L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("BIGINT '+754'")))).isEqualTo(754L);
    }

    @Test
    public void testUnaryPlus() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("+100000000037")))).isEqualTo(100000000037L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("+100000000017")))).isEqualTo(100000000017L);
    }

    @Test
    public void testUnaryMinus() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("-100000000037")))).isEqualTo(-100000000037L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("-100000000017")))).isEqualTo(-100000000017L);
    }

    @Test
    public void testAdd() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "37", "100000000037")))).isEqualTo(100000000074L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "37", "100000000017")))).isEqualTo(100000000054L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "100000000017", "37")))).isEqualTo(100000000054L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "100000000017", "100000000017")))).isEqualTo(200000000034L);
    }

    @Test
    public void testSubtract() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "100000000037", "37")))).isEqualTo(100000000000L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "37", "100000000017")))).isEqualTo(-99999999980L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "100000000017", "37")))).isEqualTo(99999999980L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "100000000017", "100000000017")))).isEqualTo(0L);
    }

    @Test
    public void testMultiply() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "100000000037", "37")))).isEqualTo(3700000001369L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "37", "100000000017")))).isEqualTo(3700000000629L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "100000000017", "37")))).isEqualTo(3700000000629L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "100000000017", "10000017")))).isEqualTo(1000001700170000289L);
    }

    @Test
    public void testDivide() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "100000000037", "37")))).isEqualTo(2702702703L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "37", "100000000017")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "100000000017", "37")))).isEqualTo(2702702703L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "100000000017", "100000000017")))).isEqualTo(1L);
    }

    @Test
    public void testModulus() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "100000000037", "37")))).isEqualTo(26L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "37", "100000000017")))).isEqualTo(37L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "100000000017", "37")))).isEqualTo(6L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MODULUS, "100000000017", "100000000017")))).isEqualTo(0L);
    }

    @Test
    public void testNegation() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.NEGATION, "(100000000037)")))).isEqualTo(-100000000037L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.NEGATION, "(100000000017)")))).isEqualTo(-100000000017L);
    }

    @Test
    public void testEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "100000000037", "100000000037")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "37", "100000000017")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "100000000017", "37")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "100000000017", "100000000017")))).isEqualTo(true);
    }

    @Test
    public void testNotEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "100000000037").binding("b", "100000000037")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "37").binding("b", "100000000017")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "100000000017").binding("b", "37")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "100000000017").binding("b", "100000000017")))).isEqualTo(false);
    }

    @Test
    public void testLessThan() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "100000000037", "100000000037")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "100000000037", "100000000017")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "100000000017", "100000000037")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "100000000017", "100000000017")))).isEqualTo(false);
    }

    @Test
    public void testLessThanOrEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "100000000037", "100000000037")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "100000000037", "100000000017")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "100000000017", "100000000037")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "100000000017", "100000000017")))).isEqualTo(true);
    }

    @Test
    public void testGreaterThan() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "100000000037").binding("b", "100000000037")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "100000000037").binding("b", "100000000017")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "100000000017").binding("b", "100000000037")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "100000000017").binding("b", "100000000017")))).isEqualTo(false);
    }

    @Test
    public void testGreaterThanOrEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "100000000037").binding("b", "100000000037")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "100000000037").binding("b", "100000000017")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "100000000017").binding("b", "100000000037")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "100000000017").binding("b", "100000000017")))).isEqualTo(true);
    }

    @Test
    public void testBetween() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "100000000037").binding("low", "100000000037").binding("high", "100000000037")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "100000000037").binding("low", "100000000037").binding("high", "100000000017")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "100000000037").binding("low", "100000000017").binding("high", "100000000037")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "100000000037").binding("low", "100000000017").binding("high", "100000000017")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "100000000017").binding("low", "100000000037").binding("high", "100000000037")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "100000000017").binding("low", "100000000037").binding("high", "100000000017")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "100000000017").binding("low", "100000000017").binding("high", "100000000037")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "100000000017").binding("low", "100000000017").binding("high", "100000000017")))).isEqualTo(true);
    }

    @Test
    public void testCastToBigint() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as bigint)").binding("a", "100000000037")))).isEqualTo(100000000037L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as bigint)").binding("a", "100000000017")))).isEqualTo(100000000017L);
    }

    @Test
    public void testCastToVarchar() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as varchar)").binding("a", "BIGINT '37'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("37");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as varchar)").binding("a", "100000000017")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("100000000017");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as varchar(13))").binding("a", "100000000017")))).hasType((Type)VarcharType.createVarcharType((int)13)).isEqualTo("100000000017");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as varchar(50))").binding("a", "100000000017")))).hasType((Type)VarcharType.createVarcharType((int)50)).isEqualTo("100000000017");
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as varchar(2))").binding("a", "100000000017").evaluate()).hasMessage("Value 100000000017 cannot be represented as varchar(2)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testCastToDouble() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as double)").binding("a", "BIGINT '37'")))).isEqualTo(37.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as double)").binding("a", "100000000017")))).isEqualTo(1.00000000017E11);
    }

    @Test
    public void testCastToFloat() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as real)").binding("a", "BIGINT '37'")))).isEqualTo(Float.valueOf(37.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as real)").binding("a", "-100000000017")))).isEqualTo(Float.valueOf(-1.0E11f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as real)").binding("a", "BIGINT '0'")))).isEqualTo(Float.valueOf(0.0f));
    }

    @Test
    public void testCastToBoolean() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as boolean)").binding("a", "BIGINT '37'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as boolean)").binding("a", "100000000017")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as boolean)").binding("a", "BIGINT '0'")))).isEqualTo(false);
    }

    @Test
    public void testCastFromVarchar() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as bigint)").binding("a", "'100000000037'")))).isEqualTo(100000000037L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as bigint)").binding("a", "'100000000017'")))).isEqualTo(100000000017L);
    }

    @Test
    public void testIdentical() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IDENTICAL, "CAST(NULL AS BIGINT)", "CAST(NULL AS BIGINT)")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IDENTICAL, "100000000037", "100000000037")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IDENTICAL, "100000000037", "100000000038")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IDENTICAL, "NULL", "100000000037")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IDENTICAL, "100000000037", "NULL")))).isEqualTo(false);
    }

    @Test
    public void testOverflowAdd() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.ADD, Long.toString(Long.MAX_VALUE), "BIGINT '1'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("bigint addition overflow: 9223372036854775807 + 1");
    }

    @Test
    public void testUnderflowSubtract() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.SUBTRACT, Long.toString(Long.MIN_VALUE), "BIGINT '1'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("bigint subtraction overflow: -9223372036854775808 - 1");
    }

    @Test
    public void testOverflowMultiply() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.MULTIPLY, Long.toString(Long.MAX_VALUE), "2")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("bigint multiplication overflow: 9223372036854775807 * 2");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.MULTIPLY, Long.toString(Long.MIN_VALUE), "-1")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("bigint multiplication overflow: -9223372036854775808 * -1");
    }

    @Test
    public void testOverflowDivide() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.DIVIDE, Long.toString(Long.MIN_VALUE), "-1")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("bigint division overflow: -9223372036854775808 / -1");
    }

    @Test
    public void testIndeterminate() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "cast(null as bigint)")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "cast(1 as bigint)")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "cast(4499999999 as bigint)")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "4499999999")))).isEqualTo(false);
    }

    @Test
    public void testNegateOverflow() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.NEGATION, Long.toString(Long.MIN_VALUE))::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("bigint negation overflow: -9223372036854775808");
    }
}

