/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.type.IpAddressType;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestIpAddressOperators {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testVarcharToIpAddressCast() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as IPADDRESS)").binding("a", "'::ffff:1.2.3.4'")))).hasType((Type)IpAddressType.IPADDRESS).isEqualTo("1.2.3.4");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as IPADDRESS)").binding("a", "'1.2.3.4'")))).hasType((Type)IpAddressType.IPADDRESS).isEqualTo("1.2.3.4");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as IPADDRESS)").binding("a", "'192.168.0.0'")))).hasType((Type)IpAddressType.IPADDRESS).isEqualTo("192.168.0.0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as IPADDRESS)").binding("a", "'2001:0db8:0000:0000:0000:ff00:0042:8329'")))).hasType((Type)IpAddressType.IPADDRESS).isEqualTo("2001:db8::ff00:42:8329");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as IPADDRESS)").binding("a", "'2001:db8::ff00:42:8329'")))).hasType((Type)IpAddressType.IPADDRESS).isEqualTo("2001:db8::ff00:42:8329");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as IPADDRESS)").binding("a", "'2001:db8:0:0:1:0:0:1'")))).hasType((Type)IpAddressType.IPADDRESS).isEqualTo("2001:db8::1:0:0:1");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as IPADDRESS)").binding("a", "'2001:db8:0:0:1::1'")))).hasType((Type)IpAddressType.IPADDRESS).isEqualTo("2001:db8::1:0:0:1");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as IPADDRESS)").binding("a", "'2001:db8::1:0:0:1'")))).hasType((Type)IpAddressType.IPADDRESS).isEqualTo("2001:db8::1:0:0:1");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as IPADDRESS)").binding("a", "'2001:DB8::FF00:ABCD:12EF'")))).hasType((Type)IpAddressType.IPADDRESS).isEqualTo("2001:db8::ff00:abcd:12ef");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("IPADDRESS '10.0.0.0'")))).hasType((Type)IpAddressType.IPADDRESS).isEqualTo("10.0.0.0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("IPADDRESS '64:ff9b::10.0.0.0'")))).hasType((Type)IpAddressType.IPADDRESS).isEqualTo("64:ff9b::a00:0");
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as IPADDRESS)").binding("a", "'facebook.com'").evaluate()).hasMessage("Cannot cast value to IPADDRESS: facebook.com")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as IPADDRESS)").binding("a", "'localhost'").evaluate()).hasMessage("Cannot cast value to IPADDRESS: localhost")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as IPADDRESS)").binding("a", "'2001:db8::1::1'").evaluate()).hasMessage("Cannot cast value to IPADDRESS: 2001:db8::1::1")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as IPADDRESS)").binding("a", "'2001:zxy::1::1'").evaluate()).hasMessage("Cannot cast value to IPADDRESS: 2001:zxy::1::1")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as IPADDRESS)").binding("a", "'789.1.1.1'").evaluate()).hasMessage("Cannot cast value to IPADDRESS: 789.1.1.1")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testIpAddressToVarcharCast() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "IPADDRESS '::ffff:1.2.3.4'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1.2.3.4");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "IPADDRESS '::ffff:102:304'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1.2.3.4");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "IPADDRESS '2001:0db8:0000:0000:0000:ff00:0042:8329'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("2001:db8::ff00:42:8329");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "IPADDRESS '2001:db8::ff00:42:8329'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("2001:db8::ff00:42:8329");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "IPADDRESS '2001:db8:0:0:1:0:0:1'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("2001:db8::1:0:0:1");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a AS VARCHAR)").binding("a", "CAST('1.2.3.4' as IPADDRESS)")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1.2.3.4");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a AS VARCHAR)").binding("a", "CAST('2001:db8:0:0:1::1' as IPADDRESS)")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("2001:db8::1:0:0:1");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a AS VARCHAR)").binding("a", "CAST('64:ff9b::10.0.0.0' as IPADDRESS)")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("64:ff9b::a00:0");
    }

    @Test
    public void testVarbinaryToIpAddressCast() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as IPADDRESS)").binding("a", "x'00000000000000000000ffff01020304'")))).hasType((Type)IpAddressType.IPADDRESS).isEqualTo("1.2.3.4");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as IPADDRESS)").binding("a", "x'01020304'")))).hasType((Type)IpAddressType.IPADDRESS).isEqualTo("1.2.3.4");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as IPADDRESS)").binding("a", "x'c0a80000'")))).hasType((Type)IpAddressType.IPADDRESS).isEqualTo("192.168.0.0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as IPADDRESS)").binding("a", "x'20010db8000000000000ff0000428329'")))).hasType((Type)IpAddressType.IPADDRESS).isEqualTo("2001:db8::ff00:42:8329");
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as IPADDRESS)").binding("a", "x'f000001100'").evaluate()).hasMessage("Invalid IP address binary length: 5")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testIpAddressToVarbinaryCast() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARBINARY)").binding("a", "IPADDRESS '::ffff:1.2.3.4'")))).hasType((Type)VarbinaryType.VARBINARY).matches("X'00000000000000000000FFFF01020304'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARBINARY)").binding("a", "IPADDRESS '2001:0db8:0000:0000:0000:ff00:0042:8329'")))).hasType((Type)VarbinaryType.VARBINARY).matches("X'20010DB8000000000000FF0000428329'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARBINARY)").binding("a", "IPADDRESS '2001:db8::ff00:42:8329'")))).hasType((Type)VarbinaryType.VARBINARY).matches("X'20010DB8000000000000FF0000428329'");
    }

    @Test
    public void testEquals() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "IPADDRESS '2001:0db8:0000:0000:0000:ff00:0042:8329'", "IPADDRESS '2001:db8::ff00:42:8329'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "cast('1.2.3.4' as IPADDRESS)", "CAST('::ffff:1.2.3.4' AS IPADDRESS)")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "IPADDRESS '192.168.0.0'", "IPADDRESS '::ffff:192.168.0.0'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "IPADDRESS '10.0.0.0'", "IPADDRESS '::ffff:a00:0'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "IPADDRESS '2001:db8::ff00:42:8329'", "IPADDRESS '2001:db8::ff00:42:8300'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "CAST('1.2.3.4' AS IPADDRESS)", "IPADDRESS '1.2.3.5'")))).isEqualTo(false);
    }

    @Test
    public void testIdentical() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IDENTICAL, "IPADDRESS '2001:0db8:0000:0000:0000:ff00:0042:8329'", "IPADDRESS '2001:db8::ff00:42:8329'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IDENTICAL, "cast(NULL as IPADDRESS)", "CAST(NULL AS IPADDRESS)")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IDENTICAL, "IPADDRESS '2001:0db8:0000:0000:0000:ff00:0042:8329'", "IPADDRESS '2001:db8::ff00:42:8328'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IDENTICAL, "IPADDRESS '2001:0db8:0000:0000:0000:ff00:0042:8329'", "CAST(NULL AS IPADDRESS)")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IDENTICAL, "CAST(NULL AS IPADDRESS)", "IPADDRESS '2001:db8::ff00:42:8328'")))).isEqualTo(false);
    }

    @Test
    public void testNotEquals() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "IPADDRESS '2001:0db8:0000:0000:0000:ff00:0042:8329'").binding("b", "IPADDRESS '1.2.3.4'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "CAST('1.2.3.4' as IPADDRESS)").binding("b", "CAST('1.2.3.5' AS IPADDRESS)")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "CAST('1.2.3.4' AS IPADDRESS)").binding("b", "IPADDRESS '1.2.3.4'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "IPADDRESS '2001:0db8:0000:0000:0000:ff00:0042:8329'").binding("b", "IPADDRESS '2001:db8::ff00:42:8329'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "CAST('1.2.3.4' as IPADDRESS)").binding("b", "CAST('::ffff:1.2.3.4' AS IPADDRESS)")))).isEqualTo(false);
    }

    @Test
    public void testOrderOperators() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "IPADDRESS '::2222'").binding("low", "IPADDRESS '::'").binding("high", "IPADDRESS '::1234'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "IPADDRESS '2001:0db8:0000:0000:0000:ff00:0042:8329'").binding("b", "IPADDRESS '1.2.3.4'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "IPADDRESS '1.2.3.4'").binding("b", "IPADDRESS '2001:0db8:0000:0000:0000:ff00:0042:8329'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "cast('1.2.3.4' as IPADDRESS)", "CAST('1.2.3.5' AS IPADDRESS)")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "cast('1.2.3.5' as IPADDRESS)", "CAST('1.2.3.4' AS IPADDRESS)")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "IPADDRESS '::1'", "CAST('1.2.3.5' AS IPADDRESS)")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "IPADDRESS '1.2.3.5'", "CAST('1.2.3.5' AS IPADDRESS)")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "IPADDRESS '1.2.3.6'", "CAST('1.2.3.5' AS IPADDRESS)")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "IPADDRESS '::1'").binding("b", "IPADDRESS '::'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "IPADDRESS '::1'").binding("b", "IPADDRESS '::1'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "IPADDRESS '::'").binding("b", "IPADDRESS '::1'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "IPADDRESS '::1'").binding("low", "IPADDRESS '::'").binding("high", "IPADDRESS '::1234'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "IPADDRESS '::2222'").binding("low", "IPADDRESS '::'").binding("high", "IPADDRESS '::1234'")))).isEqualTo(false);
    }

    @Test
    public void testIndeterminate() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "CAST(null AS IPADDRESS)")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "IPADDRESS '::2222'")))).isEqualTo(false);
    }

    @Test
    public void testHash() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.HASH_CODE, "CAST(null AS IPADDRESS)")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.HASH_CODE, "IPADDRESS '::2222'")))).isEqualTo(6196302176720775325L);
    }
}

