/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.Type;
import io.trino.type.AbstractTestType;
import io.trino.type.IpAddressType;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestIpAddressType
extends AbstractTestType {
    public TestIpAddressType() {
        super((Type)IpAddressType.IPADDRESS, String.class, TestIpAddressType.createTestBlock());
    }

    public static ValueBlock createTestBlock() {
        BlockBuilder blockBuilder = IpAddressType.IPADDRESS.createFixedSizeBlockBuilder(1);
        IpAddressType.IPADDRESS.writeSlice(blockBuilder, TestIpAddressType.getSliceForAddress("2001:db8::ff00:42:8320"));
        IpAddressType.IPADDRESS.writeSlice(blockBuilder, TestIpAddressType.getSliceForAddress("2001:db8::ff00:42:8321"));
        IpAddressType.IPADDRESS.writeSlice(blockBuilder, TestIpAddressType.getSliceForAddress("2001:db8::ff00:42:8322"));
        IpAddressType.IPADDRESS.writeSlice(blockBuilder, TestIpAddressType.getSliceForAddress("2001:db8::ff00:42:8323"));
        IpAddressType.IPADDRESS.writeSlice(blockBuilder, TestIpAddressType.getSliceForAddress("2001:db8::ff00:42:8324"));
        IpAddressType.IPADDRESS.writeSlice(blockBuilder, TestIpAddressType.getSliceForAddress("2001:db8::ff00:42:8325"));
        IpAddressType.IPADDRESS.writeSlice(blockBuilder, TestIpAddressType.getSliceForAddress("2001:db8::ff00:42:8326"));
        IpAddressType.IPADDRESS.writeSlice(blockBuilder, TestIpAddressType.getSliceForAddress("2001:db8::ff00:42:8327"));
        IpAddressType.IPADDRESS.writeSlice(blockBuilder, TestIpAddressType.getSliceForAddress("2001:db8::ff00:42:8328"));
        IpAddressType.IPADDRESS.writeSlice(blockBuilder, TestIpAddressType.getSliceForAddress("2001:db8::ff00:42:8329"));
        return blockBuilder.buildValueBlock();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        byte[] address = ((Slice)value).getBytes();
        int n = address.length - 1;
        byte by = (byte)(address[n] + 1);
        address[n] = by;
        Preconditions.checkState((by != 0 ? 1 : 0) != 0, (Object)"Last byte of address is 0xff");
        return Slices.wrappedBuffer((byte[])address);
    }

    @Override
    protected Object getNonNullValue() {
        return Slices.wrappedBuffer((byte[])InetAddresses.forString((String)"::").getAddress());
    }

    @Test
    public void testDisplayName() {
        Assertions.assertThat((String)IpAddressType.IPADDRESS.getDisplayName()).isEqualTo("ipaddress");
    }

    private static Slice getSliceForAddress(String address) {
        return Slices.wrappedBuffer((byte[])InetAddresses.forString((String)address).getAddress());
    }

    @Test
    public void testRange() {
        Assertions.assertThat((Optional)this.type.getRange()).isEmpty();
    }

    @Test
    public void testPreviousValue() {
        Assertions.assertThat((Optional)this.type.getPreviousValue(this.getSampleValue())).isEmpty();
    }

    @Test
    public void testNextValue() {
        Assertions.assertThat((Optional)this.type.getNextValue(this.getSampleValue())).isEmpty();
    }
}

