/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import io.trino.util.DateTimeUtils;
import java.time.DateTimeException;
import java.util.OptionalInt;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDateTimeUtils {
    @Test
    public void testParseIfIso8601DateFormat() {
        ((AbstractIntegerAssert)Assertions.assertThat((int)0).describedAs("1970-01-01", new Object[0])).isEqualTo(DateTimeUtils.parseIfIso8601DateFormat((String)"1970-01-01").getAsInt());
        ((AbstractIntegerAssert)Assertions.assertThat((int)31).describedAs("1970-02-01", new Object[0])).isEqualTo(DateTimeUtils.parseIfIso8601DateFormat((String)"1970-02-01").getAsInt());
        ((AbstractIntegerAssert)Assertions.assertThat((int)-31).describedAs("1969-12-01", new Object[0])).isEqualTo(DateTimeUtils.parseIfIso8601DateFormat((String)"1969-12-01").getAsInt());
        ((AbstractIntegerAssert)Assertions.assertThat((int)19051).describedAs("2022-02-28", new Object[0])).isEqualTo(DateTimeUtils.parseIfIso8601DateFormat((String)"2022-02-28").getAsInt());
        ((AbstractIntegerAssert)Assertions.assertThat((int)-719528).describedAs("0000-01-01", new Object[0])).isEqualTo(DateTimeUtils.parseIfIso8601DateFormat((String)"0000-01-01").getAsInt());
        ((AbstractIntegerAssert)Assertions.assertThat((int)2932896).describedAs("9999-12-31", new Object[0])).isEqualTo(DateTimeUtils.parseIfIso8601DateFormat((String)"9999-12-31").getAsInt());
        Assertions.assertThat((OptionalInt)DateTimeUtils.parseIfIso8601DateFormat((String)"1970-2-01")).isEmpty();
        Assertions.assertThat((OptionalInt)DateTimeUtils.parseIfIso8601DateFormat((String)"a970-02-10")).isEmpty();
        Assertions.assertThat((OptionalInt)DateTimeUtils.parseIfIso8601DateFormat((String)"1p70-02-10")).isEmpty();
        Assertions.assertThat((OptionalInt)DateTimeUtils.parseIfIso8601DateFormat((String)"19%0-02-10")).isEmpty();
        Assertions.assertThat((OptionalInt)DateTimeUtils.parseIfIso8601DateFormat((String)"197o-02-10")).isEmpty();
        Assertions.assertThat((OptionalInt)DateTimeUtils.parseIfIso8601DateFormat((String)"1970_02-01")).isEmpty();
        Assertions.assertThat((OptionalInt)DateTimeUtils.parseIfIso8601DateFormat((String)"1970- 2-01")).isEmpty();
        Assertions.assertThat((OptionalInt)DateTimeUtils.parseIfIso8601DateFormat((String)"1970-3.-01")).isEmpty();
        Assertions.assertThat((OptionalInt)DateTimeUtils.parseIfIso8601DateFormat((String)"1970-02/01")).isEmpty();
        Assertions.assertThat((OptionalInt)DateTimeUtils.parseIfIso8601DateFormat((String)"1970-02-/1")).isEmpty();
        Assertions.assertThat((OptionalInt)DateTimeUtils.parseIfIso8601DateFormat((String)"1970-12-0l")).isEmpty();
        Assertions.assertThat((OptionalInt)DateTimeUtils.parseIfIso8601DateFormat((String)"1970/02/01")).isEmpty();
        Assertions.assertThat((OptionalInt)DateTimeUtils.parseIfIso8601DateFormat((String)"Dec 24 2022")).isEmpty();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DateTimeUtils.parseIfIso8601DateFormat((String)"2022-02-29")).isInstanceOf(DateTimeException.class)).hasMessage("Invalid date 'February 29' as '2022' is not a leap year");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DateTimeUtils.parseIfIso8601DateFormat((String)"1970-32-01")).isInstanceOf(DateTimeException.class)).hasMessage("Invalid value for MonthOfYear (valid values 1 - 12): 32");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DateTimeUtils.parseIfIso8601DateFormat((String)"1970-02-41")).isInstanceOf(DateTimeException.class)).hasMessage("Invalid value for DayOfMonth (valid values 1 - 28/31): 41");
    }
}

