/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import com.google.common.collect.Iterables;
import io.trino.util.DisjointSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDisjointSet {
    @Test
    public void testInitial() {
        DisjointSet disjoint = new DisjointSet();
        for (int i = 0; i < 100; ++i) {
            Assertions.assertThat((int)((Integer)disjoint.find((Object)i))).isEqualTo(i);
        }
        Assertions.assertThat((int)disjoint.getEquivalentClasses().size()).isEqualTo(100);
    }

    @Test
    public void testMergeAllSequentially() {
        int i;
        DisjointSet disjoint = new DisjointSet();
        for (i = 0; i < 100; ++i) {
            Assertions.assertThat((boolean)disjoint.findAndUnion((Object)i, (Object)(i + 1))).isTrue();
            if (i != 0) {
                Assertions.assertThat((Integer)((Integer)disjoint.find((Object)(i - 1)))).isEqualTo(disjoint.find((Object)i));
            }
            if (i == 99) continue;
            Assertions.assertThat((Integer)((Integer)disjoint.find((Object)(i + 1)))).isNotEqualTo(disjoint.find((Object)(i + 2)));
        }
        for (i = 0; i <= 100; ++i) {
            for (int j = 0; j <= 100; ++j) {
                Assertions.assertThat((Integer)((Integer)disjoint.find((Object)i))).isEqualTo(disjoint.find((Object)j));
                Assertions.assertThat((boolean)disjoint.findAndUnion((Object)i, (Object)j)).isFalse();
            }
        }
        Collection equivalentClasses = disjoint.getEquivalentClasses();
        Assertions.assertThat((int)equivalentClasses.size()).isEqualTo(1);
        Assertions.assertThat((int)((Set)Iterables.getOnlyElement((Iterable)equivalentClasses)).size()).isEqualTo(101);
    }

    @Test
    public void testMergeAllBackwardsSequentially() {
        int i;
        DisjointSet disjoint = new DisjointSet();
        for (i = 100; i > 0; --i) {
            Assertions.assertThat((boolean)disjoint.findAndUnion((Object)i, (Object)(i - 1))).isTrue();
            if (i != 100) {
                Assertions.assertThat((Integer)((Integer)disjoint.find((Object)(i + 1)))).isEqualTo(disjoint.find((Object)i));
            }
            if (i == 1) continue;
            Assertions.assertThat((Integer)((Integer)disjoint.find((Object)(i - 1)))).isNotEqualTo(disjoint.find((Object)(i - 2)));
        }
        for (i = 0; i <= 100; ++i) {
            for (int j = 0; j <= 100; ++j) {
                Assertions.assertThat((Integer)((Integer)disjoint.find((Object)i))).isEqualTo(disjoint.find((Object)j));
                Assertions.assertThat((boolean)disjoint.findAndUnion((Object)i, (Object)j)).isFalse();
            }
        }
        Collection equivalentClasses = disjoint.getEquivalentClasses();
        Assertions.assertThat((int)equivalentClasses.size()).isEqualTo(1);
        Assertions.assertThat((int)((Set)Iterables.getOnlyElement((Iterable)equivalentClasses)).size()).isEqualTo(101);
    }

    @Test
    public void testMergeFourGroups() {
        DisjointSet disjoint = new DisjointSet();
        List inputs = IntStream.range(0, 96).boxed().collect(Collectors.toList());
        Collections.shuffle(inputs);
        Iterator iterator = inputs.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            Assertions.assertThat((boolean)disjoint.findAndUnion((Object)i, (Object)(i + 4))).isTrue();
        }
        for (int i = 0; i < 100; ++i) {
            for (int j = 0; j < 100; ++j) {
                if ((i - j) % 4 == 0) {
                    Assertions.assertThat((Integer)((Integer)disjoint.find((Object)i))).isEqualTo(disjoint.find((Object)j));
                    Assertions.assertThat((boolean)disjoint.findAndUnion((Object)i, (Object)j)).isFalse();
                    continue;
                }
                Assertions.assertThat((Integer)((Integer)disjoint.find((Object)i))).isNotEqualTo(disjoint.find((Object)j));
            }
        }
        Collection equivalentClasses = disjoint.getEquivalentClasses();
        Assertions.assertThat((int)equivalentClasses.size()).isEqualTo(4);
        equivalentClasses.forEach(equivalentClass -> Assertions.assertThat((int)equivalentClass.size()).isEqualTo(25));
    }

    @Test
    public void testMergeRandomly() {
        DisjointSet disjoint = new DisjointSet();
        Random rand = new Random();
        double[] numbers = new double[100];
        for (int i = 0; i < 100; ++i) {
            numbers[i] = rand.nextDouble();
            disjoint.find((Object)numbers[i]);
        }
        int groupCount = 100;
        while (groupCount > 1) {
            boolean newEquivalence = disjoint.findAndUnion((Object)numbers[rand.nextInt(100)], (Object)numbers[rand.nextInt(100)]);
            if (newEquivalence) {
                --groupCount;
            }
            Assertions.assertThat((int)disjoint.getEquivalentClasses().size()).isEqualTo(groupCount);
        }
    }
}

