/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.ControlStatement;
import io.trino.sql.tree.ElseClause;
import io.trino.sql.tree.ElseIfClause;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class IfStatement
extends ControlStatement {
    private final Expression expression;
    private final List<ControlStatement> statements;
    private final List<ElseIfClause> elseIfClauses;
    private final Optional<ElseClause> elseClause;

    public IfStatement(NodeLocation location, Expression expression, List<ControlStatement> statements, List<ElseIfClause> elseIfClauses, Optional<ElseClause> elseClause) {
        super(location);
        this.expression = Objects.requireNonNull(expression, "expression is null");
        this.statements = Objects.requireNonNull(statements, "statements is null");
        this.elseIfClauses = Objects.requireNonNull(elseIfClauses, "elseIfClauses is null");
        this.elseClause = Objects.requireNonNull(elseClause, "elseClause is null");
    }

    public Expression getExpression() {
        return this.expression;
    }

    public List<ControlStatement> getStatements() {
        return this.statements;
    }

    public List<ElseIfClause> getElseIfClauses() {
        return this.elseIfClauses;
    }

    public Optional<ElseClause> getElseClause() {
        return this.elseClause;
    }

    @Override
    public List<? extends Node> getChildren() {
        ImmutableList.Builder children = ImmutableList.builder().add((Object)this.expression).addAll(this.statements).addAll(this.elseIfClauses);
        this.elseClause.ifPresent(arg_0 -> ((ImmutableList.Builder)children).add(arg_0));
        return children.build();
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitIfStatement(this, context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof IfStatement)) return false;
        IfStatement other = (IfStatement)obj;
        if (!Objects.equals(this.expression, other.expression)) return false;
        if (!Objects.equals(this.statements, other.statements)) return false;
        if (!Objects.equals(this.elseIfClauses, other.elseIfClauses)) return false;
        if (!Objects.equals(this.elseClause, other.elseClause)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.expression, this.statements, this.elseIfClauses, this.elseClause);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("expression", (Object)this.expression).add("statements", this.statements).add("elseIfClauses", this.elseIfClauses).add("elseClause", this.elseClause).toString();
    }
}

