/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.JsonPathParameter;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class JsonObjectMember
extends Node {
    private final Expression key;
    private final Expression value;
    private final Optional<JsonPathParameter.JsonFormat> format;

    public JsonObjectMember(NodeLocation location, Expression key, Expression value, Optional<JsonPathParameter.JsonFormat> format) {
        super(location);
        Objects.requireNonNull(key, "key is null");
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(format, "format is null");
        this.key = key;
        this.value = value;
        this.format = format;
    }

    public Expression getKey() {
        return this.key;
    }

    public Expression getValue() {
        return this.value;
    }

    public Optional<JsonPathParameter.JsonFormat> getFormat() {
        return this.format;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitJsonObjectMember(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of((Object)this.key, (Object)this.value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonObjectMember that = (JsonObjectMember)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value) && Objects.equals(this.format, that.format);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.key, this.value, this.format);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("key", (Object)this.key).add("value", (Object)this.value).add("format", this.format).omitNullValues().toString();
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!JsonObjectMember.sameClass(this, other)) {
            return false;
        }
        return this.format.equals(((JsonObjectMember)other).format);
    }
}

