/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.DataType;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ParameterDeclaration
extends Node {
    private final Optional<Identifier> name;
    private final DataType type;

    @Deprecated
    public ParameterDeclaration(Optional<Identifier> name, DataType type) {
        super(Optional.empty());
        this.name = Objects.requireNonNull(name, "name is null");
        this.type = Objects.requireNonNull(type, "type is null");
    }

    public ParameterDeclaration(NodeLocation location, Optional<Identifier> name, DataType type) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.type = Objects.requireNonNull(type, "type is null");
    }

    public Optional<Identifier> getName() {
        return this.name;
    }

    public DataType getType() {
        return this.type;
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitParameterDeclaration(this, context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ParameterDeclaration)) return false;
        ParameterDeclaration other = (ParameterDeclaration)obj;
        if (!Objects.equals(this.name, other.name)) return false;
        if (!Objects.equals(this.type, other.type)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", this.name).add("type", (Object)this.type).toString();
    }
}

