/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.JsonTablePlan;
import io.trino.sql.tree.JsonTableSpecificPlan;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.PlanLeaf;
import java.util.List;
import java.util.Objects;

public class PlanParentChild
extends JsonTableSpecificPlan {
    private final JsonTablePlan.ParentChildPlanType type;
    private final PlanLeaf parent;
    private final JsonTableSpecificPlan child;

    public PlanParentChild(NodeLocation location, JsonTablePlan.ParentChildPlanType type, PlanLeaf parent, JsonTableSpecificPlan child) {
        super(location);
        this.type = Objects.requireNonNull(type, "type is null");
        this.parent = Objects.requireNonNull(parent, "parent is null");
        this.child = Objects.requireNonNull(child, "child is null");
    }

    public JsonTablePlan.ParentChildPlanType getType() {
        return this.type;
    }

    public PlanLeaf getParent() {
        return this.parent;
    }

    public JsonTableSpecificPlan getChild() {
        return this.child;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitPlanParentChild(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of((Object)this.child);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("parent", (Object)this.parent).add("child", (Object)this.child).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlanParentChild that = (PlanParentChild)o;
        return this.type == that.type && Objects.equals(this.parent, that.parent) && Objects.equals(this.child, that.child);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.parent, this.child});
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!PlanParentChild.sameClass(this, other)) {
            return false;
        }
        PlanParentChild otherPlan = (PlanParentChild)other;
        return this.type == otherPlan.type && this.parent.equals(otherPlan.parent);
    }
}

