/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.PathSpecification;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;

public class SetPath
extends Statement {
    private final PathSpecification pathSpecification;

    public SetPath(NodeLocation location, PathSpecification pathSpecification) {
        super(location);
        this.pathSpecification = Objects.requireNonNull(pathSpecification, "pathSpecification is null");
    }

    public PathSpecification getPathSpecification() {
        return this.pathSpecification;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSetPath(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of((Object)this.pathSpecification);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.pathSpecification);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SetPath o = (SetPath)obj;
        return Objects.equals(this.pathSpecification, o.pathSpecification);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("pathSpecification", (Object)this.pathSpecification).toString();
    }
}

