/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import java.util.Optional;
import java.util.function.Function;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.statement.NoTemplateEngine;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;

@FunctionalInterface
public interface TemplateEngine {
    public static final TemplateEngine NOP = new NoTemplateEngine();

    public String render(String var1, StatementContext var2);

    default public Optional<Function<StatementContext, String>> parse(String template, ConfigRegistry config) {
        return Optional.empty();
    }

    @FunctionalInterface
    public static interface Parsing
    extends TemplateEngine {
        @Override
        default public String render(String template, StatementContext ctx) {
            return this.parse(template, ctx.getConfig()).orElseThrow(() -> new UnableToCreateStatementException("Caching template engine did not prepare")).apply(ctx);
        }

        @Override
        public Optional<Function<StatementContext, String>> parse(String var1, ConfigRegistry var2);
    }
}

