/*
 * Decompiled with CFR 0.152.
 */
package io.trino.matching.pattern;

import io.trino.matching.Captures;
import io.trino.matching.Match;
import io.trino.matching.Pattern;
import io.trino.matching.PatternVisitor;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class EqualsPattern<T>
extends Pattern<T> {
    private final T expectedValue;

    public EqualsPattern(T expectedValue, Optional<Pattern<?>> previous) {
        super(previous);
        this.expectedValue = Objects.requireNonNull(expectedValue, "expectedValue can't be null. Use isNull() pattern instead.");
    }

    public T expectedValue() {
        return this.expectedValue;
    }

    @Override
    public <C> Stream<Match> accept(Object object, Captures captures, C context) {
        return Stream.of(Match.of(captures)).filter(match -> this.expectedValue.equals(object));
    }

    @Override
    public void accept(PatternVisitor patternVisitor) {
        patternVisitor.visitEquals(this);
    }
}

