/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpch;

import io.trino.tpch.GenerateUtils;
import io.trino.tpch.StringUtils;
import io.trino.tpch.TpchEntity;
import java.util.Objects;

public record Order(long rowNumber, long orderKey, long customerKey, char orderStatus, long totalPriceInCents, int orderDate, String orderPriority, String clerk, int shipPriority, String comment) implements TpchEntity
{
    public Order {
        Objects.requireNonNull(orderPriority, "orderPriority is null");
        Objects.requireNonNull(clerk, "clerk is null");
        Objects.requireNonNull(comment, "comment is null");
    }

    public double totalPrice() {
        return (double)this.totalPriceInCents / 100.0;
    }

    @Override
    public String toLine() {
        return StringUtils.buildLine(this.orderKey, this.customerKey, Character.valueOf(this.orderStatus), GenerateUtils.formatMoney(this.totalPriceInCents), GenerateUtils.formatDate(this.orderDate), this.orderPriority, this.clerk, this.shipPriority, this.comment);
    }
}

