/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpch;

import io.trino.tpch.RandomInt;
import io.trino.tpch.RandomLong;

public class RandomBoundedLong {
    private final RandomLong randomLong;
    private final RandomInt randomInt;
    private final long lowValue;
    private final long highValue;

    public RandomBoundedLong(long seed, boolean use64Bits, long lowValue, long highValue) {
        this(seed, use64Bits, lowValue, highValue, 1);
    }

    public RandomBoundedLong(long seed, boolean use64Bits, long lowValue, long highValue, int expectedRowCount) {
        if (use64Bits) {
            this.randomLong = new RandomLong(seed, expectedRowCount);
            this.randomInt = null;
        } else {
            this.randomLong = null;
            this.randomInt = new RandomInt(seed, expectedRowCount);
        }
        this.lowValue = lowValue;
        this.highValue = highValue;
    }

    public long nextValue() {
        if (this.randomLong != null) {
            return this.randomLong.nextLong(this.lowValue, this.highValue);
        }
        return this.randomInt.nextInt((int)this.lowValue, (int)this.highValue);
    }

    public void rowFinished() {
        if (this.randomLong != null) {
            this.randomLong.rowFinished();
        } else {
            this.randomInt.rowFinished();
        }
    }

    public void advanceRows(long rowCount) {
        if (this.randomLong != null) {
            this.randomLong.advanceRows(rowCount);
        } else {
            this.randomInt.advanceRows(rowCount);
        }
    }
}

