/*
 * Decompiled with CFR 0.152.
 */
package io.trino.block;

import io.trino.jmh.Benchmarks;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.profile.GCProfiler;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@Fork(value=1)
@Warmup(iterations=3)
@Measurement(iterations=5)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkRowBlockBuilder {
    @Benchmark
    public void benchmarkBeginBlockEntry(BenchmarkData data, Blackhole blackhole) {
        for (int i = 0; i < data.rows; ++i) {
            data.getBlockBuilder().buildEntry(fieldBuilders -> {
                for (int fieldIndex = 0; fieldIndex < data.getTypes().size(); ++fieldIndex) {
                    BigintType.BIGINT.writeLong((BlockBuilder)fieldBuilders.get(fieldIndex), data.getRandom().nextLong());
                }
            });
        }
        blackhole.consume((Object)data.getBlockBuilder());
    }

    public static void main(String[] args) throws Exception {
        Benchmarks.benchmark(BenchmarkRowBlockBuilder.class).withOptions(options -> options.addProfiler(GCProfiler.class)).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private RowBlockBuilder blockBuilder;
        private List<Type> types;
        @Param(value={"10", "100", "1000"})
        private int rows = 10;
        @Param(value={"2", "4", "8"})
        private int typesLength = 2;
        private Random random;

        @Setup(value=Level.Iteration)
        public void setup() {
            this.types = Collections.nCopies(this.typesLength, BigintType.BIGINT);
            RowType rowType = RowType.anonymous(this.types);
            this.blockBuilder = rowType.createBlockBuilder(null, this.rows);
            this.random = new Random(1024L);
        }

        public int getRows() {
            return this.rows;
        }

        public Random getRandom() {
            return this.random;
        }

        public List<Type> getTypes() {
            return this.types;
        }

        public RowBlockBuilder getBlockBuilder() {
            return this.blockBuilder;
        }
    }
}

