/*
 * Decompiled with CFR 0.152.
 */
package io.trino.block;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.block.AbstractTestBlock;
import io.trino.spi.block.ArrayBlock;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ByteArrayBlock;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestArrayBlock
extends AbstractTestBlock {
    private static final int[] ARRAY_SIZES = new int[]{16, 0, 13, 1, 2, 11, 4, 7};

    @Test
    public void testWithFixedWidthBlock() {
        long[][] expectedValues = new long[ARRAY_SIZES.length][];
        Random rand = new Random(47L);
        for (int i = 0; i < ARRAY_SIZES.length; ++i) {
            expectedValues[i] = rand.longs(ARRAY_SIZES[i]).toArray();
        }
        Block block = TestArrayBlock.createBlockBuilderWithValues(expectedValues).build();
        this.assertBlock(block, (T[])expectedValues);
        this.assertBlockFilteredPositions((T[])expectedValues, block, 0, 1, 3, 4, 7);
        this.assertBlockFilteredPositions((T[])expectedValues, block, 2, 3, 5, 6);
        long[][] expectedValuesWithNull = (long[][])TestArrayBlock.alternatingNullValues(expectedValues);
        Block blockWithNull = TestArrayBlock.createBlockBuilderWithValues(expectedValuesWithNull).build();
        this.assertBlock(blockWithNull, (T[])expectedValuesWithNull);
        this.assertBlockFilteredPositions((T[])expectedValuesWithNull, blockWithNull, 0, 1, 5, 6, 7, 10, 11, 12, 15);
        this.assertBlockFilteredPositions((T[])expectedValuesWithNull, blockWithNull, 2, 3, 4, 9, 13, 14);
    }

    @Test
    public void testWithVariableWidthBlock() {
        Slice[][] expectedValues = new Slice[ARRAY_SIZES.length][];
        for (int i = 0; i < ARRAY_SIZES.length; ++i) {
            expectedValues[i] = new Slice[ARRAY_SIZES[i]];
            for (int j = 0; j < ARRAY_SIZES[i]; ++j) {
                expectedValues[i][j] = Slices.utf8Slice((String)String.format("%d.%d", i, j));
            }
        }
        Block block = TestArrayBlock.createBlockBuilderWithValues(expectedValues).build();
        this.assertBlock(block, (T[])expectedValues);
        this.assertBlockFilteredPositions((T[])expectedValues, block, 0, 1, 3, 4, 7);
        this.assertBlockFilteredPositions((T[])expectedValues, block, 2, 3, 5, 6);
        Slice[][] expectedValuesWithNull = (Slice[][])TestArrayBlock.alternatingNullValues(expectedValues);
        Block blockWithNull = TestArrayBlock.createBlockBuilderWithValues(expectedValuesWithNull).build();
        this.assertBlock(blockWithNull, (T[])expectedValuesWithNull);
        this.assertBlockFilteredPositions((T[])expectedValuesWithNull, blockWithNull, 0, 1, 5, 6, 7, 10, 11, 12, 15);
        this.assertBlockFilteredPositions((T[])expectedValuesWithNull, blockWithNull, 2, 3, 4, 9, 13, 14);
    }

    @Test
    public void testWithArrayBlock() {
        long[][][] expectedValues = TestArrayBlock.createExpectedValues();
        Block block = TestArrayBlock.createBlockBuilderWithValues(expectedValues).build();
        this.assertBlock(block, (T[])expectedValues);
        this.assertBlockFilteredPositions((T[])expectedValues, block, 0, 1, 3, 4, 7);
        this.assertBlockFilteredPositions((T[])expectedValues, block, 2, 3, 5, 6);
        long[][][] expectedValuesWithNull = (long[][][])TestArrayBlock.alternatingNullValues(expectedValues);
        Block blockWithNull = TestArrayBlock.createBlockBuilderWithValues(expectedValuesWithNull).build();
        this.assertBlock(blockWithNull, (T[])expectedValuesWithNull);
        this.assertBlockFilteredPositions((T[])expectedValuesWithNull, blockWithNull, 0, 1, 5, 6, 7, 10, 11, 12, 15);
        this.assertBlockFilteredPositions((T[])expectedValuesWithNull, blockWithNull, 2, 3, 4, 9, 13, 14);
    }

    private static long[][][] createExpectedValues() {
        long[][][] expectedValues = new long[ARRAY_SIZES.length][][];
        for (int i = 0; i < ARRAY_SIZES.length; ++i) {
            expectedValues[i] = new long[ARRAY_SIZES[i]][];
            for (int j = 1; j < ARRAY_SIZES[i]; ++j) {
                expectedValues[i][j] = (long[])((i + j) % 5 == 0 ? null : new long[]{i, j, i + j});
            }
        }
        return expectedValues;
    }

    @Test
    public void testLazyBlockBuilderInitialization() {
        long[][] expectedValues = new long[ARRAY_SIZES.length][];
        Random rand = new Random(47L);
        for (int i = 0; i < ARRAY_SIZES.length; ++i) {
            expectedValues[i] = rand.longs(ARRAY_SIZES[i]).toArray();
        }
        ArrayBlockBuilder emptyBlockBuilder = new ArrayBlockBuilder((Type)BigintType.BIGINT, null, 0, 0);
        ArrayBlockBuilder blockBuilder = new ArrayBlockBuilder((Type)BigintType.BIGINT, null, 100, 100);
        Assertions.assertThat((long)blockBuilder.getSizeInBytes()).isEqualTo(emptyBlockBuilder.getSizeInBytes());
        Assertions.assertThat((long)blockBuilder.getRetainedSizeInBytes()).isEqualTo(emptyBlockBuilder.getRetainedSizeInBytes());
        TestArrayBlock.writeValues(expectedValues, (BlockBuilder)blockBuilder);
        Assertions.assertThat((blockBuilder.getSizeInBytes() > emptyBlockBuilder.getSizeInBytes() ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((blockBuilder.getRetainedSizeInBytes() > emptyBlockBuilder.getRetainedSizeInBytes() ? 1 : 0) != 0).isTrue();
        blockBuilder = blockBuilder.newBlockBuilderLike(null);
        Assertions.assertThat((long)blockBuilder.getSizeInBytes()).isEqualTo(emptyBlockBuilder.getSizeInBytes());
        Assertions.assertThat((long)blockBuilder.getRetainedSizeInBytes()).isEqualTo(emptyBlockBuilder.getRetainedSizeInBytes());
    }

    @Test
    public void testEstimatedDataSizeForStats() {
        long[][][] expectedValues = (long[][][])TestArrayBlock.alternatingNullValues(TestArrayBlock.createExpectedValues());
        Block block = TestArrayBlock.createBlockBuilderWithValues(expectedValues).build();
        Assertions.assertThat((int)block.getPositionCount()).isEqualTo(expectedValues.length);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            int expectedSize = TestArrayBlock.getExpectedEstimatedDataSize(expectedValues[i]);
            Assertions.assertThat((long)block.getEstimatedDataSizeForStats(i)).isEqualTo((long)expectedSize);
        }
    }

    private static int getExpectedEstimatedDataSize(long[][] values) {
        if (values == null) {
            return 0;
        }
        int size = 0;
        for (long[] value : values) {
            if (value == null) continue;
            size += 8 * value.length;
        }
        return size;
    }

    @Test
    public void testCompactBlock() {
        ByteArrayBlock emptyValueBlock = new ByteArrayBlock(0, Optional.empty(), new byte[0]);
        ByteArrayBlock compactValueBlock = new ByteArrayBlock(16, Optional.empty(), TestArrayBlock.createExpectedValue(16).getBytes());
        ByteArrayBlock inCompactValueBlock = new ByteArrayBlock(16, Optional.empty(), TestArrayBlock.createExpectedValue(17).getBytes());
        int[] offsets = new int[]{0, 1, 1, 2, 4, 8, 16};
        boolean[] valueIsNull = new boolean[]{false, true, false, false, false, false};
        TestArrayBlock.testCompactBlock((Block)ArrayBlock.fromElementBlock((int)0, Optional.empty(), (int[])new int[1], (Block)emptyValueBlock));
        TestArrayBlock.testCompactBlock((Block)ArrayBlock.fromElementBlock((int)valueIsNull.length, Optional.of(valueIsNull), (int[])offsets, (Block)compactValueBlock));
        TestArrayBlock.testNotCompactBlock((Block)ArrayBlock.fromElementBlock((int)(valueIsNull.length - 1), Optional.of(valueIsNull), (int[])offsets, (Block)compactValueBlock));
        TestArrayBlock.testNotCompactBlock((Block)ArrayBlock.fromElementBlock((int)valueIsNull.length, Optional.of(valueIsNull), (int[])offsets, (Block)inCompactValueBlock));
    }

    private static BlockBuilder createBlockBuilderWithValues(long[][][] expectedValues) {
        ArrayBlockBuilder blockBuilder = new ArrayBlockBuilder((BlockBuilder)new ArrayBlockBuilder((Type)BigintType.BIGINT, null, 100, 100), null, 100);
        for (long[][] expectedValue : expectedValues) {
            if (expectedValue == null) {
                blockBuilder.appendNull();
                continue;
            }
            blockBuilder.buildEntry(elementBuilder -> {
                for (long[] values : expectedValue) {
                    if (values == null) {
                        elementBuilder.appendNull();
                        continue;
                    }
                    ((ArrayBlockBuilder)elementBuilder).buildEntry(innerBuilder -> Arrays.stream(values).forEach(value -> BigintType.BIGINT.writeLong(innerBuilder, value)));
                }
            });
        }
        return blockBuilder;
    }

    private static BlockBuilder createBlockBuilderWithValues(long[][] expectedValues) {
        ArrayBlockBuilder blockBuilder = new ArrayBlockBuilder((Type)BigintType.BIGINT, null, 100, 100);
        return TestArrayBlock.writeValues(expectedValues, (BlockBuilder)blockBuilder);
    }

    private static BlockBuilder writeValues(long[][] expectedValues, BlockBuilder blockBuilder) {
        for (long[] expectedValue : expectedValues) {
            if (expectedValue == null) {
                blockBuilder.appendNull();
                continue;
            }
            ((ArrayBlockBuilder)blockBuilder).buildEntry(elementBuilder -> {
                for (long v : expectedValue) {
                    BigintType.BIGINT.writeLong(elementBuilder, v);
                }
            });
        }
        return blockBuilder;
    }

    private static BlockBuilder createBlockBuilderWithValues(Slice[][] expectedValues) {
        ArrayBlockBuilder blockBuilder = new ArrayBlockBuilder((Type)VarcharType.VARCHAR, null, 100, 100);
        for (Slice[] expectedValue : expectedValues) {
            if (expectedValue == null) {
                blockBuilder.appendNull();
                continue;
            }
            blockBuilder.buildEntry(elementBuilder -> {
                for (Slice v : expectedValue) {
                    VarcharType.VARCHAR.writeSlice(elementBuilder, v);
                }
            });
        }
        return blockBuilder;
    }

    @Override
    protected <T> void assertPositionValue(Block block, int position, T expectedValue) {
        if (expectedValue == null) {
            Assertions.assertThat((boolean)block.isNull(position)).isTrue();
            return;
        }
        Assertions.assertThat((boolean)block.isNull(position)).isFalse();
        ArrayBlock arrayBlock = (ArrayBlock)block;
        Block actual = arrayBlock.getArray(position);
        if (expectedValue instanceof Byte[]) {
            Byte[] expected = (Byte[])expectedValue;
            Assertions.assertThat((int)actual.getPositionCount()).isEqualTo(expected.length);
            for (int i = 0; i < expected.length; ++i) {
                if (expected[i] == null) {
                    Assertions.assertThat((boolean)actual.isNull(i)).isTrue();
                    continue;
                }
                Assertions.assertThat((byte)TinyintType.TINYINT.getByte(actual, i)).isEqualTo(expected[i].byteValue());
            }
        } else if (expectedValue instanceof long[]) {
            long[] expected = (long[])expectedValue;
            Assertions.assertThat((int)actual.getPositionCount()).isEqualTo(expected.length);
            for (int i = 0; i < expected.length; ++i) {
                Assertions.assertThat((long)BigintType.BIGINT.getLong(actual, i)).isEqualTo(expected[i]);
            }
        } else if (expectedValue instanceof Slice[]) {
            Slice[] expected = (Slice[])expectedValue;
            Assertions.assertThat((int)actual.getPositionCount()).isEqualTo(expected.length);
            for (int i = 0; i < expected.length; ++i) {
                Assertions.assertThat((Comparable)VarcharType.VARCHAR.getSlice(actual, i)).isEqualTo((Object)expected[i]);
            }
        } else if (expectedValue instanceof long[][]) {
            long[][] expected = (long[][])expectedValue;
            Assertions.assertThat((int)actual.getPositionCount()).isEqualTo(expected.length);
            for (int i = 0; i < expected.length; ++i) {
                this.assertPositionValue(actual, i, expected[i]);
            }
        } else {
            throw new IllegalArgumentException("Unsupported type: " + expectedValue.getClass().getSimpleName());
        }
    }
}

