/*
 * Decompiled with CFR 0.152.
 */
package io.trino.block;

import com.google.common.base.VerifyException;
import com.google.common.collect.Streams;
import io.trino.block.BlockAssertions;
import java.util.List;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public final class TestBlockAssertions {
    @Test
    public void generatesListWithNulls() {
        List<Integer> list = BlockAssertions.generateListWithNulls(10, 0.2f, () -> 1);
        Assertions.assertThat((long)Streams.stream(list).filter(Objects::isNull).count()).isEqualTo(2L);
    }

    @Test
    public void failsIfPositionCountToLow() {
        Assertions.assertThatThrownBy(() -> BlockAssertions.generateListWithNulls(4, 0.2f, () -> 1)).isInstanceOf(VerifyException.class);
    }
}

