/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableMap;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorPlugin;
import io.trino.spi.Plugin;
import io.trino.testing.StandaloneQueryRunner;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestConnectorTracingContextPropagation {
    private static final String CATALOG_NAME = "test_catalog";
    private static final String CONNECTOR_NAME = "test_connector";

    @Test
    public void testTracingContextCapture() {
        AtomicReference capturedContext = new AtomicReference();
        try (StandaloneQueryRunner queryRunner = new StandaloneQueryRunner(TestingSession.testSessionBuilder().build());){
            queryRunner.installPlugin((Plugin)new MockConnectorPlugin(MockConnectorFactory.builder().withName(CONNECTOR_NAME).withData(table -> {
                capturedContext.set(Context.current());
                return List.of(List.of());
            }).build()));
            queryRunner.createCatalog(CATALOG_NAME, CONNECTOR_NAME, (Map)ImmutableMap.of());
            queryRunner.execute("SELECT COUNT(*) FROM %s.test.test".formatted(CATALOG_NAME));
        }
        Assertions.assertThat((Object)((Context)capturedContext.get())).matches(ctx -> Span.fromContext((Context)ctx).getSpanContext().isValid(), "valid tracing context");
    }
}

