/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.trino.Session;
import io.trino.execution.BaseDataDefinitionTaskTest;
import io.trino.execution.DropNotNullConstraintTask;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorCapabilities;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.SaveMode;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.QueryUtil;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.tree.DropNotNullConstraint;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.QualifiedName;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestDropNotNullConstraintConstraintTask
extends BaseDataDefinitionTaskTest {
    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.metadata = new MockMetadataWithNotNull("test_catalog");
        this.plannerContext = TestingPlannerContext.plannerContextBuilder().withMetadata(this.metadata).build();
    }

    @Test
    public void testDropNotNullConstraint() {
        QualifiedObjectName tableName = TestDropNotNullConstraintConstraintTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test_catalog", TestDropNotNullConstraintConstraintTask.simpleTable(tableName), SaveMode.FAIL);
        TableHandle table = this.metadata.getTableHandle(this.testSession, tableName).orElseThrow();
        Assertions.assertThat((List)this.metadata.getTableMetadata(this.testSession, table).columns()).containsExactly((Object[])new ColumnMetadata[]{TestDropNotNullConstraintConstraintTask.notNullColumn("a", (Type)BigintType.BIGINT), TestDropNotNullConstraintConstraintTask.notNullColumn("b", (Type)BigintType.BIGINT)});
        MoreFutures.getFutureValue(this.executeDropNotNullConstraint(TestDropNotNullConstraintConstraintTask.asQualifiedName(tableName), QueryUtil.identifier((String)"b"), false));
        Assertions.assertThat((List)this.metadata.getTableMetadata(this.testSession, table).columns()).containsExactly((Object[])new ColumnMetadata[]{TestDropNotNullConstraintConstraintTask.notNullColumn("a", (Type)BigintType.BIGINT), TestDropNotNullConstraintConstraintTask.nullableColumn("b", (Type)BigintType.BIGINT)});
    }

    @Test
    public void testDropNotNullConstraintNotExistingTable() {
        QualifiedObjectName tableName = TestDropNotNullConstraintConstraintTask.qualifiedObjectName("not_existing_table");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeDropNotNullConstraint(TestDropNotNullConstraintConstraintTask.asQualifiedName(tableName), QueryUtil.identifier((String)"b"), false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessageContaining("Table '%s' does not exist", new Object[]{tableName});
    }

    @Test
    public void testDropNotNullConstraintNotExistingTableIfExists() {
        QualifiedName tableName = TestDropNotNullConstraintConstraintTask.qualifiedName("not_existing_table");
        MoreFutures.getFutureValue(this.executeDropNotNullConstraint(tableName, QueryUtil.identifier((String)"b"), true));
    }

    @Test
    public void testDropNotNullConstraintMissingColumn() {
        QualifiedObjectName tableName = TestDropNotNullConstraintConstraintTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test_catalog", TestDropNotNullConstraintConstraintTask.simpleTable(tableName), SaveMode.FAIL);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeDropNotNullConstraint(TestDropNotNullConstraintConstraintTask.asQualifiedName(tableName), QueryUtil.identifier((String)"missing_column"), false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessageContaining("Column 'missing_column' does not exist");
    }

    @Test
    public void testDropNotNullConstraintNullableColumn() {
        QualifiedObjectName tableName = TestDropNotNullConstraintConstraintTask.qualifiedObjectName("existing_table");
        ConnectorTableMetadata tableMetadata = new ConnectorTableMetadata(tableName.asSchemaTableName(), (List)ImmutableList.of((Object)TestDropNotNullConstraintConstraintTask.nullableColumn("a", (Type)BigintType.BIGINT)));
        this.metadata.createTable(this.testSession, "test_catalog", tableMetadata, SaveMode.FAIL);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeDropNotNullConstraint(TestDropNotNullConstraintConstraintTask.asQualifiedName(tableName), QueryUtil.identifier((String)"a"), false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessageContaining("Column is already nullable");
    }

    @Test
    public void testDropNotNullConstraintOnView() {
        QualifiedObjectName viewName = TestDropNotNullConstraintConstraintTask.qualifiedObjectName("existing_view");
        this.metadata.createView(this.testSession, viewName, TestDropNotNullConstraintConstraintTask.someView(), (Map<String, Object>)ImmutableMap.of(), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeDropNotNullConstraint(TestDropNotNullConstraintConstraintTask.asQualifiedName(viewName), QueryUtil.identifier((String)"test"), false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessageContaining("Table '%s' does not exist, but a view with that name exists.", new Object[]{viewName});
    }

    @Test
    public void testDropNotNullConstraintOnMaterializedView() {
        QualifiedObjectName materializedViewName = TestDropNotNullConstraintConstraintTask.qualifiedObjectName("existing_materialized_view");
        this.metadata.createMaterializedView(this.testSession, QualifiedObjectName.valueOf((String)materializedViewName.toString()), this.someMaterializedView(), MATERIALIZED_VIEW_PROPERTIES, false, false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeDropNotNullConstraint(TestDropNotNullConstraintConstraintTask.asQualifiedName(materializedViewName), QueryUtil.identifier((String)"test"), false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessageContaining("Table '%s' does not exist, but a materialized view with that name exists.", new Object[]{materializedViewName});
    }

    private ListenableFuture<Void> executeDropNotNullConstraint(QualifiedName table, Identifier column, boolean tableExists) {
        return new DropNotNullConstraintTask(this.plannerContext.getMetadata(), (AccessControl)new AllowAllAccessControl()).execute(new DropNotNullConstraint(new NodeLocation(1, 1), table, column, tableExists), this.queryStateMachine, (List)ImmutableList.of(), WarningCollector.NOOP);
    }

    private static ConnectorTableMetadata simpleTable(QualifiedObjectName tableName) {
        return new ConnectorTableMetadata(tableName.asSchemaTableName(), (List)ImmutableList.of((Object)TestDropNotNullConstraintConstraintTask.notNullColumn("a", (Type)BigintType.BIGINT), (Object)TestDropNotNullConstraintConstraintTask.notNullColumn("b", (Type)BigintType.BIGINT)));
    }

    private static ColumnMetadata nullableColumn(String name, Type type) {
        return ColumnMetadata.builder().setName(name).setType(type).setNullable(true).build();
    }

    private static ColumnMetadata notNullColumn(String name, Type type) {
        return ColumnMetadata.builder().setName(name).setType(type).setNullable(false).build();
    }

    private static class MockMetadataWithNotNull
    extends BaseDataDefinitionTaskTest.MockMetadata {
        public MockMetadataWithNotNull(String catalogName) {
            super(catalogName);
        }

        @Override
        public Set<ConnectorCapabilities> getConnectorCapabilities(Session session, CatalogHandle catalogHandle) {
            return ImmutableSet.of((Object)ConnectorCapabilities.NOT_NULL_COLUMN_CONSTRAINT);
        }
    }
}

