/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.executor.timesharing;

import io.trino.execution.executor.timesharing.SimulationSplit;
import io.trino.execution.executor.timesharing.SimulationTask;
import java.util.concurrent.ScheduledExecutorService;

abstract class SplitSpecification {
    private final long scheduledTimeNanos;
    private final long perQuantaNanos;

    private SplitSpecification(long scheduledTimeNanos, long perQuantaNanos) {
        this.scheduledTimeNanos = scheduledTimeNanos;
        this.perQuantaNanos = perQuantaNanos;
    }

    public long getScheduledTimeNanos() {
        return this.scheduledTimeNanos;
    }

    public long getPerQuantaNanos() {
        return this.perQuantaNanos;
    }

    public abstract SimulationSplit instantiate(SimulationTask var1);

    public static class IntermediateSplitSpecification
    extends SplitSpecification {
        private final long wallTimeNanos;
        private final long numQuantas;
        private final long betweenQuantaNanos;
        private final ScheduledExecutorService wakeupExecutor;

        public IntermediateSplitSpecification(long scheduledTimeNanos, long perQuantaNanos, long wallTimeNanos, long numQuantas, long betweenQuantaNanos, ScheduledExecutorService wakeupExecutor) {
            super(scheduledTimeNanos, perQuantaNanos);
            this.wallTimeNanos = wallTimeNanos;
            this.numQuantas = numQuantas;
            this.betweenQuantaNanos = betweenQuantaNanos;
            this.wakeupExecutor = wakeupExecutor;
        }

        @Override
        public SimulationSplit.IntermediateSplit instantiate(SimulationTask task) {
            return new SimulationSplit.IntermediateSplit(task, this.wallTimeNanos, this.numQuantas, super.getPerQuantaNanos(), this.betweenQuantaNanos, super.getScheduledTimeNanos(), this.wakeupExecutor);
        }
    }

    public static class LeafSplitSpecification
    extends SplitSpecification {
        public LeafSplitSpecification(long scheduledTimeNanos, long perQuantaNanos) {
            super(scheduledTimeNanos, perQuantaNanos);
        }

        @Override
        public SimulationSplit.LeafSplit instantiate(SimulationTask task) {
            return new SimulationSplit.LeafSplit(task, super.getScheduledTimeNanos(), super.getPerQuantaNanos());
        }
    }
}

