/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.client.NodeVersion;
import io.trino.execution.StageId;
import io.trino.execution.TaskId;
import io.trino.execution.TaskInfo;
import io.trino.memory.LowMemoryKiller;
import io.trino.memory.MemoryInfo;
import io.trino.metadata.InternalNode;
import io.trino.operator.RetryPolicy;
import io.trino.spi.QueryId;
import io.trino.spi.memory.MemoryPoolInfo;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class LowMemoryKillerTestingUtils {
    private LowMemoryKillerTestingUtils() {
    }

    static List<MemoryInfo> toNodeMemoryInfoList(long memoryPoolMaxBytes, Map<String, Map<String, Long>> queries) {
        return LowMemoryKillerTestingUtils.toNodeMemoryInfoList(memoryPoolMaxBytes, queries, (Map<String, Map<String, Map<Integer, Long>>>)ImmutableMap.of());
    }

    static List<MemoryInfo> toNodeMemoryInfoList(long memoryPoolMaxBytes, Map<String, Map<String, Long>> queries, Map<String, Map<String, Map<Integer, Long>>> tasks) {
        HashMap<InternalNode, NodeReservation> nodeReservations = new HashMap<InternalNode, NodeReservation>();
        for (Map.Entry<String, Map<String, Long>> entry : queries.entrySet()) {
            QueryId queryId = new QueryId(entry.getKey());
            Map<String, Long> reservationByNode = entry.getValue();
            for (Map.Entry<String, Long> nodeEntry : reservationByNode.entrySet()) {
                InternalNode node = new InternalNode(nodeEntry.getKey(), URI.create("http://localhost"), new NodeVersion("version"), false);
                long bytes = nodeEntry.getValue();
                if (bytes == 0L) continue;
                nodeReservations.computeIfAbsent(node, internalNode -> new NodeReservation()).add(queryId, bytes);
            }
        }
        ImmutableList.Builder result = ImmutableList.builder();
        for (Map.Entry entry : nodeReservations.entrySet()) {
            NodeReservation nodeReservation = (NodeReservation)entry.getValue();
            MemoryPoolInfo memoryPoolInfo = new MemoryPoolInfo(memoryPoolMaxBytes, nodeReservation.getTotalReservedBytes(), 0L, nodeReservation.getReservationByQuery(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), LowMemoryKillerTestingUtils.tasksMemoryInfoForNode(((InternalNode)entry.getKey()).getNodeIdentifier(), tasks), (Map)ImmutableMap.of());
            result.add((Object)new MemoryInfo(7, memoryPoolInfo));
        }
        return result.build();
    }

    private static Map<String, Long> tasksMemoryInfoForNode(String nodeIdentifier, Map<String, Map<String, Map<Integer, Long>>> tasks) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Map.Entry<String, Map<String, Map<Integer, Long>>> queryNodesEntry : tasks.entrySet()) {
            for (Map.Entry<String, Map<Integer, Long>> nodeTasksEntry : queryNodesEntry.getValue().entrySet()) {
                if (!nodeIdentifier.equals(nodeTasksEntry.getKey())) continue;
                for (Map.Entry<Integer, Long> partitionReservationEntry : nodeTasksEntry.getValue().entrySet()) {
                    result.put((Object)LowMemoryKillerTestingUtils.taskId(queryNodesEntry.getKey(), partitionReservationEntry.getKey()).toString(), (Object)partitionReservationEntry.getValue());
                }
            }
        }
        return result.buildOrThrow();
    }

    static TaskId taskId(String query, int partition) {
        return new TaskId(new StageId(QueryId.valueOf((String)query), 0), partition, 0);
    }

    static List<LowMemoryKiller.RunningQueryInfo> toRunningQueryInfoList(Map<String, Map<String, Long>> queries) {
        return LowMemoryKillerTestingUtils.toRunningQueryInfoList(queries, (Set<String>)ImmutableSet.of());
    }

    static List<LowMemoryKiller.RunningQueryInfo> toRunningQueryInfoList(Map<String, Map<String, Long>> queries, Set<String> queriesWithTaskLevelRetries) {
        return LowMemoryKillerTestingUtils.toRunningQueryInfoList(queries, queriesWithTaskLevelRetries, (Map<String, Map<Integer, TaskInfo>>)ImmutableMap.of());
    }

    static List<LowMemoryKiller.RunningQueryInfo> toRunningQueryInfoList(Map<String, Map<String, Long>> queries, Set<String> queriesWithTaskLevelRetries, Map<String, Map<Integer, TaskInfo>> taskInfos) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Map.Entry<String, Map<String, Long>> entry : queries.entrySet()) {
            String queryId = entry.getKey();
            long totalReservation = entry.getValue().values().stream().mapToLong(x -> x).sum();
            Map queryTaskInfos = (Map)taskInfos.getOrDefault(queryId, (Map<Integer, TaskInfo>)ImmutableMap.of()).entrySet().stream().collect(ImmutableMap.toImmutableMap(taskEntry -> LowMemoryKillerTestingUtils.taskId(queryId, (Integer)taskEntry.getKey()), Map.Entry::getValue));
            result.add((Object)new LowMemoryKiller.RunningQueryInfo(new QueryId(queryId), totalReservation, queryTaskInfos, queriesWithTaskLevelRetries.contains(queryId) ? RetryPolicy.TASK : RetryPolicy.NONE));
        }
        return result.build();
    }

    private static class NodeReservation {
        private long totalReservedBytes;
        private final Map<QueryId, Long> reservationByQuery = new HashMap<QueryId, Long>();

        private NodeReservation() {
        }

        public void add(QueryId queryId, long bytes) {
            this.totalReservedBytes += bytes;
            this.reservationByQuery.put(queryId, bytes);
        }

        public long getTotalReservedBytes() {
            return this.totalReservedBytes;
        }

        public Map<QueryId, Long> getReservationByQuery() {
            return this.reservationByQuery;
        }
    }
}

