/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import io.airlift.json.JsonCodec;
import io.trino.metadata.QualifiedTablePrefix;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestQualifiedTablePrefix {
    private static final JsonCodec<QualifiedTablePrefix> CODEC = JsonCodec.jsonCodec(QualifiedTablePrefix.class);

    @Test
    public void testCatalog() {
        QualifiedTablePrefix tableName = new QualifiedTablePrefix("catalog");
        Assertions.assertThat((String)"catalog").isEqualTo(tableName.getCatalogName());
        Assertions.assertThat((boolean)tableName.hasSchemaName()).isFalse();
        Assertions.assertThat((boolean)tableName.hasTableName()).isFalse();
    }

    @Test
    public void testSchema() {
        QualifiedTablePrefix tableName = new QualifiedTablePrefix("catalog", "schema");
        Assertions.assertThat((String)"catalog").isEqualTo(tableName.getCatalogName());
        Assertions.assertThat((boolean)tableName.hasSchemaName()).isTrue();
        Assertions.assertThat((String)"schema").isEqualTo((String)tableName.getSchemaName().get());
        Assertions.assertThat((boolean)tableName.hasTableName()).isFalse();
    }

    @Test
    public void testTable() {
        QualifiedTablePrefix tableName = new QualifiedTablePrefix("catalog", "schema", "table");
        Assertions.assertThat((String)"catalog").isEqualTo(tableName.getCatalogName());
        Assertions.assertThat((boolean)tableName.hasSchemaName()).isTrue();
        Assertions.assertThat((String)"schema").isEqualTo((String)tableName.getSchemaName().get());
        Assertions.assertThat((boolean)tableName.hasTableName()).isTrue();
        Assertions.assertThat((String)"table").isEqualTo((String)tableName.getTableName().get());
    }

    @Test
    public void testNullSchema() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new QualifiedTablePrefix("catalog", null, "table")).isInstanceOf(NullPointerException.class)).hasMessage("schemaName is null");
    }

    @Test
    public void testRoundTrip() {
        QualifiedTablePrefix table = new QualifiedTablePrefix("abc", "xyz", "fgh");
        Assertions.assertThat((Object)((QualifiedTablePrefix)CODEC.fromJson(CODEC.toJson((Object)table)))).isEqualTo((Object)table);
    }
}

