/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import io.trino.block.BlockAssertions;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.Type;
import io.trino.type.TypeTestUtils;
import java.util.List;
import java.util.Optional;

public class PageTestUtils {
    private PageTestUtils() {
    }

    public static Page createRandomPage(List<Type> types, int positionCount, float nullRate) {
        return PageTestUtils.createRandomPage(types, positionCount, Optional.of(ImmutableList.of((Object)0)), nullRate, (List<Wrapping>)ImmutableList.of());
    }

    public static Page createRandomDictionaryPage(List<Type> types, int positionCount, float nullRate) {
        return PageTestUtils.createRandomPage(types, positionCount, Optional.of(ImmutableList.of((Object)0)), nullRate, (List<Wrapping>)ImmutableList.of((Object)((Object)Wrapping.DICTIONARY)));
    }

    public static Page createRandomRlePage(List<Type> types, int positionCount, float nullRate) {
        return PageTestUtils.createRandomPage(types, positionCount, Optional.of(ImmutableList.of((Object)0)), nullRate, (List<Wrapping>)ImmutableList.of((Object)((Object)Wrapping.RUN_LENGTH)));
    }

    public static Page createRandomPage(List<Type> types, int positionCount, Optional<List<Integer>> hashChannels, float nullRate, List<Wrapping> wrappings) {
        List blocks = (List)types.stream().map(type -> {
            ValueBlock block = BlockAssertions.createRandomBlockForType(type, positionCount, nullRate);
            for (Wrapping wrapping : wrappings) {
                block = wrapping.wrap((Block)block, positionCount);
            }
            return block;
        }).collect(ImmutableList.toImmutableList());
        return PageTestUtils.createPage(types, positionCount, hashChannels, blocks);
    }

    public static Page createPage(List<Type> types, int positionCount, Optional<List<Integer>> hashChannels, List<Block> blocks) {
        ImmutableList.Builder finalBlocks = ImmutableList.builder().addAll(blocks);
        hashChannels.ifPresent(channels -> finalBlocks.add((Object)TypeTestUtils.getHashBlock((List)channels.stream().map(types::get).collect(ImmutableList.toImmutableList()), (Block[])channels.stream().map(blocks::get).toArray(Block[]::new))));
        return new Page(positionCount, (Block[])finalBlocks.build().toArray(Block[]::new));
    }

    public static enum Wrapping {
        DICTIONARY{

            @Override
            public Block wrap(Block block, int positionCount) {
                return BlockAssertions.createRandomDictionaryBlock(block, positionCount);
            }
        }
        ,
        RUN_LENGTH{

            @Override
            public Block wrap(Block block, int positionCount) {
                return BlockAssertions.createRandomRleBlock(block, positionCount);
            }
        };


        public abstract Block wrap(Block var1, int var2);
    }
}

