/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import io.airlift.concurrent.Threads;
import io.airlift.units.DataSize;
import io.trino.ExceededMemoryLimitException;
import io.trino.RowPagesBuilder;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.operator.Driver;
import io.trino.operator.DriverContext;
import io.trino.operator.HashSemiJoinOperator;
import io.trino.operator.Operator;
import io.trino.operator.OperatorAssertion;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.operator.SetBuilderOperator;
import io.trino.operator.TaskContext;
import io.trino.operator.ValuesOperator;
import io.trino.spi.Page;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import io.trino.sql.gen.JoinCompiler;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.MaterializedResult;
import io.trino.testing.TestingTaskContext;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_METHOD)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestHashSemiJoinOperator {
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private TaskContext taskContext;
    private TypeOperators typeOperators;

    @BeforeEach
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));
        this.taskContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION);
        this.typeOperators = new TypeOperators();
    }

    @AfterEach
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testSemiJoin() {
        this.testSemiJoin(true);
        this.testSemiJoin(false);
    }

    private void testSemiJoin(boolean hashEnabled) {
        DriverContext driverContext = this.taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(0, new PlanNodeId("test"), ValuesOperator.class.getSimpleName());
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), new Type[]{BigintType.BIGINT});
        ValuesOperator buildOperator = new ValuesOperator(operatorContext, rowPagesBuilder.row(10L).row(30L).row(30L).row(35L).row(36L).row(37L).row(50L).build());
        SetBuilderOperator.SetBuilderOperatorFactory setBuilderOperatorFactory = new SetBuilderOperator.SetBuilderOperatorFactory(1, new PlanNodeId("test"), rowPagesBuilder.getTypes().get(0), 0, rowPagesBuilder.getHashChannel(), 10, new JoinCompiler(this.typeOperators), this.typeOperators);
        Operator setBuilderOperator = setBuilderOperatorFactory.createOperator(driverContext);
        Driver driver = Driver.createDriver((DriverContext)driverContext, (Operator)buildOperator, (Operator[])new Operator[]{setBuilderOperator});
        while (!driver.isFinished()) {
            driver.processUntilBlocked();
        }
        ImmutableList probeTypes = ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        RowPagesBuilder rowPagesBuilderProbe = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), new Type[]{BigintType.BIGINT, BigintType.BIGINT});
        List<Page> probeInput = rowPagesBuilderProbe.addSequencePage(10, 30, 0).build();
        Optional probeHashChannel = hashEnabled ? Optional.of(probeTypes.size()) : Optional.empty();
        OperatorFactory joinOperatorFactory = HashSemiJoinOperator.createOperatorFactory((int)2, (PlanNodeId)new PlanNodeId("test"), (SetBuilderOperator.SetSupplier)setBuilderOperatorFactory.getSetProvider(), rowPagesBuilderProbe.getTypes(), (int)0, probeHashChannel);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, (Iterable)ImmutableList.of((Object)BooleanType.BOOLEAN))).row(new Object[]{30L, 0L, true}).row(new Object[]{31L, 1L, false}).row(new Object[]{32L, 2L, false}).row(new Object[]{33L, 3L, false}).row(new Object[]{34L, 4L, false}).row(new Object[]{35L, 5L, true}).row(new Object[]{36L, 6L, true}).row(new Object[]{37L, 7L, true}).row(new Object[]{38L, 8L, false}).row(new Object[]{39L, 9L, false}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, driverContext, probeInput, expected, hashEnabled, (List<Integer>)ImmutableList.of((Object)probeTypes.size()));
    }

    @Test
    public void testSemiJoinOnVarcharType() {
        this.testSemiJoinOnVarcharType(true);
        this.testSemiJoinOnVarcharType(false);
    }

    private void testSemiJoinOnVarcharType(boolean hashEnabled) {
        DriverContext driverContext = this.taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(0, new PlanNodeId("test"), ValuesOperator.class.getSimpleName());
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), new Type[]{VarcharType.VARCHAR});
        ValuesOperator buildOperator = new ValuesOperator(operatorContext, rowPagesBuilder.row("10").row("30").row("30").row("35").row("36").row("37").row("50").build());
        SetBuilderOperator.SetBuilderOperatorFactory setBuilderOperatorFactory = new SetBuilderOperator.SetBuilderOperatorFactory(1, new PlanNodeId("test"), rowPagesBuilder.getTypes().get(0), 0, rowPagesBuilder.getHashChannel(), 10, new JoinCompiler(this.typeOperators), this.typeOperators);
        Operator setBuilderOperator = setBuilderOperatorFactory.createOperator(driverContext);
        Driver driver = Driver.createDriver((DriverContext)driverContext, (Operator)buildOperator, (Operator[])new Operator[]{setBuilderOperator});
        while (!driver.isFinished()) {
            driver.processUntilBlocked();
        }
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT);
        RowPagesBuilder rowPagesBuilderProbe = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), new Type[]{VarcharType.VARCHAR, BigintType.BIGINT});
        List<Page> probeInput = rowPagesBuilderProbe.addSequencePage(10, 30, 0).build();
        Optional probeHashChannel = hashEnabled ? Optional.of(probeTypes.size()) : Optional.empty();
        OperatorFactory joinOperatorFactory = HashSemiJoinOperator.createOperatorFactory((int)2, (PlanNodeId)new PlanNodeId("test"), (SetBuilderOperator.SetSupplier)setBuilderOperatorFactory.getSetProvider(), rowPagesBuilderProbe.getTypes(), (int)0, probeHashChannel);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, (Iterable)ImmutableList.of((Object)BooleanType.BOOLEAN))).row(new Object[]{"30", 0L, true}).row(new Object[]{"31", 1L, false}).row(new Object[]{"32", 2L, false}).row(new Object[]{"33", 3L, false}).row(new Object[]{"34", 4L, false}).row(new Object[]{"35", 5L, true}).row(new Object[]{"36", 6L, true}).row(new Object[]{"37", 7L, true}).row(new Object[]{"38", 8L, false}).row(new Object[]{"39", 9L, false}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, driverContext, probeInput, expected, hashEnabled, (List<Integer>)ImmutableList.of((Object)probeTypes.size()));
    }

    @Test
    public void testBuildSideNulls() {
        this.testBuildSideNulls(true);
        this.testBuildSideNulls(false);
    }

    private void testBuildSideNulls(boolean hashEnabled) {
        DriverContext driverContext = this.taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(0, new PlanNodeId("test"), ValuesOperator.class.getSimpleName());
        ImmutableList buildTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        ValuesOperator buildOperator = new ValuesOperator(operatorContext, rowPagesBuilder.row(0L).row(1L).row(2L).row(2L).row(3L).row(new Object[]{null}).build());
        SetBuilderOperator.SetBuilderOperatorFactory setBuilderOperatorFactory = new SetBuilderOperator.SetBuilderOperatorFactory(1, new PlanNodeId("test"), (Type)buildTypes.get(0), 0, rowPagesBuilder.getHashChannel(), 10, new JoinCompiler(this.typeOperators), this.typeOperators);
        Operator setBuilderOperator = setBuilderOperatorFactory.createOperator(driverContext);
        Driver driver = Driver.createDriver((DriverContext)driverContext, (Operator)buildOperator, (Operator[])new Operator[]{setBuilderOperator});
        while (!driver.isFinished()) {
            driver.processUntilBlocked();
        }
        ImmutableList probeTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder rowPagesBuilderProbe = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = rowPagesBuilderProbe.addSequencePage(4, 1).build();
        Optional probeHashChannel = hashEnabled ? Optional.of(probeTypes.size()) : Optional.empty();
        OperatorFactory joinOperatorFactory = HashSemiJoinOperator.createOperatorFactory((int)2, (PlanNodeId)new PlanNodeId("test"), (SetBuilderOperator.SetSupplier)setBuilderOperatorFactory.getSetProvider(), rowPagesBuilderProbe.getTypes(), (int)0, probeHashChannel);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, (Iterable)ImmutableList.of((Object)BooleanType.BOOLEAN))).row(new Object[]{1L, true}).row(new Object[]{2L, true}).row(new Object[]{3L, true}).row(new Object[]{4L, null}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, driverContext, probeInput, expected, hashEnabled, (List<Integer>)ImmutableList.of((Object)probeTypes.size()));
    }

    @Test
    public void testProbeSideNulls() {
        this.testProbeSideNulls(true);
        this.testProbeSideNulls(false);
    }

    private void testProbeSideNulls(boolean hashEnabled) {
        DriverContext driverContext = this.taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(0, new PlanNodeId("test"), ValuesOperator.class.getSimpleName());
        ImmutableList buildTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        ValuesOperator buildOperator = new ValuesOperator(operatorContext, rowPagesBuilder.row(0L).row(1L).row(3L).build());
        SetBuilderOperator.SetBuilderOperatorFactory setBuilderOperatorFactory = new SetBuilderOperator.SetBuilderOperatorFactory(1, new PlanNodeId("test"), (Type)buildTypes.get(0), 0, rowPagesBuilder.getHashChannel(), 10, new JoinCompiler(this.typeOperators), this.typeOperators);
        Operator setBuilderOperator = setBuilderOperatorFactory.createOperator(driverContext);
        Driver driver = Driver.createDriver((DriverContext)driverContext, (Operator)buildOperator, (Operator[])new Operator[]{setBuilderOperator});
        while (!driver.isFinished()) {
            driver.processUntilBlocked();
        }
        ImmutableList probeTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder rowPagesBuilderProbe = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = rowPagesBuilderProbe.row(0L).row(new Object[]{null}).row(1L).row(2L).build();
        Optional probeHashChannel = hashEnabled ? Optional.of(probeTypes.size()) : Optional.empty();
        OperatorFactory joinOperatorFactory = HashSemiJoinOperator.createOperatorFactory((int)2, (PlanNodeId)new PlanNodeId("test"), (SetBuilderOperator.SetSupplier)setBuilderOperatorFactory.getSetProvider(), rowPagesBuilderProbe.getTypes(), (int)0, probeHashChannel);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, (Iterable)ImmutableList.of((Object)BooleanType.BOOLEAN))).row(new Object[]{0L, true}).row(new Object[]{null, null}).row(new Object[]{1L, true}).row(new Object[]{2L, false}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, driverContext, probeInput, expected, hashEnabled, (List<Integer>)ImmutableList.of((Object)probeTypes.size()));
    }

    @Test
    public void testProbeAndBuildNulls() {
        this.testProbeAndBuildNulls(true);
        this.testProbeAndBuildNulls(false);
    }

    private void testProbeAndBuildNulls(boolean hashEnabled) {
        DriverContext driverContext = this.taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(0, new PlanNodeId("test"), ValuesOperator.class.getSimpleName());
        ImmutableList buildTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        ValuesOperator buildOperator = new ValuesOperator(operatorContext, rowPagesBuilder.row(0L).row(1L).row(new Object[]{null}).row(3L).build());
        SetBuilderOperator.SetBuilderOperatorFactory setBuilderOperatorFactory = new SetBuilderOperator.SetBuilderOperatorFactory(1, new PlanNodeId("test"), (Type)buildTypes.get(0), 0, rowPagesBuilder.getHashChannel(), 10, new JoinCompiler(this.typeOperators), this.typeOperators);
        Operator setBuilderOperator = setBuilderOperatorFactory.createOperator(driverContext);
        Driver driver = Driver.createDriver((DriverContext)driverContext, (Operator)buildOperator, (Operator[])new Operator[]{setBuilderOperator});
        while (!driver.isFinished()) {
            driver.processUntilBlocked();
        }
        ImmutableList probeTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder rowPagesBuilderProbe = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = rowPagesBuilderProbe.row(0L).row(new Object[]{null}).row(1L).row(2L).build();
        Optional probeHashChannel = hashEnabled ? Optional.of(probeTypes.size()) : Optional.empty();
        OperatorFactory joinOperatorFactory = HashSemiJoinOperator.createOperatorFactory((int)2, (PlanNodeId)new PlanNodeId("test"), (SetBuilderOperator.SetSupplier)setBuilderOperatorFactory.getSetProvider(), rowPagesBuilderProbe.getTypes(), (int)0, probeHashChannel);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)driverContext.getSession(), (Iterable)Iterables.concat((Iterable)probeTypes, (Iterable)ImmutableList.of((Object)BooleanType.BOOLEAN))).row(new Object[]{0L, true}).row(new Object[]{null, null}).row(new Object[]{1L, true}).row(new Object[]{2L, null}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, driverContext, probeInput, expected, hashEnabled, (List<Integer>)ImmutableList.of((Object)probeTypes.size()));
    }

    @Test
    public void testMemoryLimit() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.testMemoryLimit(true)).isInstanceOf(ExceededMemoryLimitException.class)).hasMessageMatching("Query exceeded per-node memory limit of.*");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.testMemoryLimit(false)).isInstanceOf(ExceededMemoryLimitException.class)).hasMessageMatching("Query exceeded per-node memory limit of.*");
    }

    private void testMemoryLimit(boolean hashEnabled) {
        DriverContext driverContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION, (DataSize)DataSize.ofBytes((long)100L)).addPipelineContext(0, true, true, false).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(0, new PlanNodeId("test"), ValuesOperator.class.getSimpleName());
        ImmutableList buildTypes = ImmutableList.of((Object)BigintType.BIGINT);
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        ValuesOperator buildOperator = new ValuesOperator(operatorContext, rowPagesBuilder.addSequencePage(10000, 20).build());
        SetBuilderOperator.SetBuilderOperatorFactory setBuilderOperatorFactory = new SetBuilderOperator.SetBuilderOperatorFactory(1, new PlanNodeId("test"), (Type)buildTypes.get(0), 0, rowPagesBuilder.getHashChannel(), 10, new JoinCompiler(this.typeOperators), this.typeOperators);
        Operator setBuilderOperator = setBuilderOperatorFactory.createOperator(driverContext);
        Driver driver = Driver.createDriver((DriverContext)driverContext, (Operator)buildOperator, (Operator[])new Operator[]{setBuilderOperator});
        while (!driver.isFinished()) {
            driver.processUntilBlocked();
        }
    }
}

