/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import io.trino.RowPagesBuilder;
import io.trino.SequencePageBuilder;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.operator.DriverContext;
import io.trino.operator.LimitOperator;
import io.trino.operator.OperatorAssertion;
import io.trino.operator.OperatorFactory;
import io.trino.spi.Page;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.MaterializedResult;
import io.trino.testing.TestingTaskContext;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_METHOD)
public class TestLimitOperator {
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private DriverContext driverContext;

    @BeforeEach
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));
        this.driverContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true, false).addDriverContext();
    }

    @AfterEach
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testLimitWithPageAlignment() {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).addSequencePage(3, 1).addSequencePage(2, 4).addSequencePage(2, 6).build();
        LimitOperator.LimitOperatorFactory operatorFactory = new LimitOperator.LimitOperatorFactory(0, new PlanNodeId("test"), 5L);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT}).page(SequencePageBuilder.createSequencePage((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), 3, 1)).page(SequencePageBuilder.createSequencePage((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), 2, 4)).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testLimitWithBlockView() {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).addSequencePage(3, 1).addSequencePage(2, 4).addSequencePage(2, 6).build();
        LimitOperator.LimitOperatorFactory operatorFactory = new LimitOperator.LimitOperatorFactory(0, new PlanNodeId("test"), 6L);
        List<Page> expected = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).addSequencePage(3, 1).addSequencePage(2, 4).addSequencePage(1, 6).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), this.driverContext, input, expected);
    }
}

