/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import io.trino.execution.TaskId;
import io.trino.operator.DirectExchangeBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class TestingDirectExchangeBuffer
implements DirectExchangeBuffer {
    private ListenableFuture<Void> blocked = Futures.immediateVoidFuture();
    private final Set<TaskId> allTasks = new HashSet<TaskId>();
    private final ListMultimap<TaskId, Slice> pages = ArrayListMultimap.create();
    private final Set<TaskId> finishedTasks = new HashSet<TaskId>();
    private final ListMultimap<TaskId, Throwable> failedTasks = ArrayListMultimap.create();
    private boolean noMoreTasks;
    private boolean finished;
    private final long remainingBufferCapacityInBytes;
    private final Map<TaskId, SettableFuture<Void>> taskFinished = new HashMap<TaskId, SettableFuture<Void>>();
    private final Map<TaskId, SettableFuture<Void>> taskFailed = new HashMap<TaskId, SettableFuture<Void>>();

    public TestingDirectExchangeBuffer(DataSize bufferCapacity) {
        this.remainingBufferCapacityInBytes = bufferCapacity.toBytes();
    }

    public synchronized ListenableFuture<Void> isBlocked() {
        return this.blocked;
    }

    public synchronized void setBlocked(ListenableFuture<Void> blocked) {
        this.blocked = Objects.requireNonNull(blocked, "blocked is null");
    }

    public synchronized Slice pollPage() {
        return null;
    }

    public synchronized void addTask(TaskId taskId) {
        Preconditions.checkState((boolean)this.allTasks.add(taskId), (String)"task is already present: %s", (Object)taskId);
    }

    public synchronized Set<TaskId> getAllTasks() {
        return ImmutableSet.copyOf(this.allTasks);
    }

    public synchronized void addPages(TaskId taskId, List<Slice> pages) {
        Preconditions.checkState((boolean)this.allTasks.contains(taskId), (String)"task is expected to be present: %s", (Object)taskId);
        this.pages.putAll((Object)taskId, pages);
    }

    public synchronized ListMultimap<TaskId, Slice> getPages() {
        return ImmutableListMultimap.copyOf(this.pages);
    }

    public synchronized void taskFinished(TaskId taskId) {
        Preconditions.checkState((boolean)this.allTasks.contains(taskId), (String)"task is expected to be present: %s", (Object)taskId);
        Preconditions.checkState((boolean)this.finishedTasks.add(taskId), (String)"task is already finished: %s", (Object)taskId);
        this.taskFinished.computeIfAbsent(taskId, key -> SettableFuture.create()).set(null);
    }

    public synchronized Set<TaskId> getFinishedTasks() {
        return ImmutableSet.copyOf(this.finishedTasks);
    }

    public synchronized ListenableFuture<Void> whenTaskFinished(TaskId taskId) {
        return (ListenableFuture)this.taskFinished.computeIfAbsent(taskId, key -> SettableFuture.create());
    }

    public synchronized void taskFailed(TaskId taskId, Throwable t) {
        Preconditions.checkState((boolean)this.allTasks.contains(taskId), (String)"task is expected to be present: %s", (Object)taskId);
        Preconditions.checkState((!this.finishedTasks.contains(taskId) ? 1 : 0) != 0, (String)"task is already finished: %s", (Object)taskId);
        this.failedTasks.put((Object)taskId, (Object)t);
        this.taskFailed.computeIfAbsent(taskId, key -> SettableFuture.create()).set(null);
    }

    public synchronized ListMultimap<TaskId, Throwable> getFailedTasks() {
        return ImmutableListMultimap.copyOf(this.failedTasks);
    }

    public synchronized ListenableFuture<Void> whenTaskFailed(TaskId taskId) {
        return (ListenableFuture)this.taskFailed.computeIfAbsent(taskId, key -> SettableFuture.create());
    }

    public synchronized void noMoreTasks() {
        this.noMoreTasks = true;
    }

    public synchronized boolean isNoMoreTasks() {
        return this.noMoreTasks;
    }

    public synchronized boolean isFinished() {
        return this.finished;
    }

    public boolean isFailed() {
        return false;
    }

    public synchronized void setFinished(boolean finished) {
        this.finished = finished;
    }

    public synchronized long getRemainingCapacityInBytes() {
        return this.remainingBufferCapacityInBytes;
    }

    public synchronized long getRetainedSizeInBytes() {
        return 0L;
    }

    public synchronized long getMaxRetainedSizeInBytes() {
        return 0L;
    }

    public synchronized int getBufferedPageCount() {
        return 0;
    }

    public long getSpilledBytes() {
        return 0L;
    }

    public int getSpilledPageCount() {
        return 0;
    }

    public synchronized void close() {
        this.finished = true;
    }
}

