/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.SequencePageBuilder;
import io.trino.spi.Page;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TestingTaskBuffer {
    private static final List<Type> TYPES = ImmutableList.of((Object)VarcharType.VARCHAR);
    public static final Page PAGE = SequencePageBuilder.createSequencePage(TYPES, 10, 100);
    private final List<Page> buffer = new ArrayList<Page>();
    private int acknowledgedPages;
    private boolean closed;

    public synchronized void addPages(int pages, boolean close) {
        this.addPages(Collections.nCopies(pages, PAGE), close);
    }

    public synchronized void addPage(Page page, boolean close) {
        this.addPages((Iterable<Page>)ImmutableList.of((Object)page), close);
    }

    public synchronized void addPages(Iterable<Page> pages, boolean close) {
        Iterables.addAll(this.buffer, pages);
        if (close) {
            this.closed = true;
        }
    }

    public synchronized Page getPage(int pageSequenceId) {
        this.acknowledgedPages = Math.max(this.acknowledgedPages, pageSequenceId);
        if (pageSequenceId >= this.buffer.size()) {
            return null;
        }
        return this.buffer.get(pageSequenceId);
    }

    public synchronized boolean isFinished() {
        return this.closed && this.acknowledgedPages == this.buffer.size();
    }
}

