/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import io.trino.operator.aggregation.AbstractTestApproximateCountDistinct;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.jupiter.api.Test;

public class TestApproximateCountDistinctBoolean
extends AbstractTestApproximateCountDistinct {
    @Override
    protected Type getValueType() {
        return BooleanType.BOOLEAN;
    }

    @Override
    protected Object randomValue() {
        return ThreadLocalRandom.current().nextBoolean();
    }

    @Test
    public void testNonEmptyInputs() {
        this.assertCount(Booleans.asList((boolean[])new boolean[]{true}), 0.0, 1L);
        this.assertCount(Booleans.asList((boolean[])new boolean[]{false}), 0.0, 1L);
        this.assertCount(Booleans.asList((boolean[])new boolean[]{true, false}), 0.0, 2L);
        this.assertCount(Booleans.asList((boolean[])new boolean[]{true, true, true}), 0.0, 1L);
        this.assertCount(Booleans.asList((boolean[])new boolean[]{false, false, false}), 0.0, 1L);
        this.assertCount(Booleans.asList((boolean[])new boolean[]{true, false, true, false}), 0.0, 2L);
    }

    @Test
    public void testNoInput() {
        this.assertCount((List<?>)ImmutableList.of(), 0.0, 0L);
    }

    @Override
    protected int getUniqueValuesCount() {
        return 2;
    }
}

