/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.trino.operator.aggregation.AbstractTestAggregationFunction;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.util.StructuralTestUtil;
import java.util.List;

public class TestArrayMinAggregation
extends AbstractTestAggregationFunction {
    @Override
    protected Block[] getSequenceBlocks(int start, int length) {
        ArrayType arrayType = new ArrayType((Type)BigintType.BIGINT);
        ArrayBlockBuilder blockBuilder = arrayType.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            arrayType.writeObject((BlockBuilder)blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)BigintType.BIGINT, i));
        }
        return new Block[]{blockBuilder.build()};
    }

    @Override
    protected List<Long> getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        return ImmutableList.of((Object)start);
    }

    @Override
    protected String getFunctionName() {
        return "min";
    }

    @Override
    protected List<Type> getFunctionParameterTypes() {
        return ImmutableList.of((Object)new ArrayType((Type)BigintType.BIGINT));
    }
}

