/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.ExceededMemoryLimitException;
import io.trino.RowPagesBuilder;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.connector.CatalogServiceProvider;
import io.trino.execution.NodeTaskMap;
import io.trino.execution.StageId;
import io.trino.execution.TaskId;
import io.trino.execution.TaskStateMachine;
import io.trino.execution.scheduler.NodeScheduler;
import io.trino.execution.scheduler.NodeSchedulerConfig;
import io.trino.execution.scheduler.NodeSelectorFactory;
import io.trino.execution.scheduler.UniformNodeSelectorFactory;
import io.trino.metadata.InMemoryNodeManager;
import io.trino.metadata.InternalNode;
import io.trino.metadata.InternalNodeManager;
import io.trino.operator.Driver;
import io.trino.operator.DriverContext;
import io.trino.operator.JoinOperatorType;
import io.trino.operator.Operator;
import io.trino.operator.OperatorAssertion;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactories;
import io.trino.operator.OperatorFactory;
import io.trino.operator.ProcessorContext;
import io.trino.operator.TaskContext;
import io.trino.operator.ValuesOperator;
import io.trino.operator.WorkProcessor;
import io.trino.operator.WorkProcessorOperator;
import io.trino.operator.WorkProcessorOperatorAdapter;
import io.trino.operator.WorkProcessorOperatorFactory;
import io.trino.operator.index.PageBuffer;
import io.trino.operator.index.PageBufferOperator;
import io.trino.operator.join.HashBuilderOperator;
import io.trino.operator.join.JoinBridgeManager;
import io.trino.operator.join.JoinTestUtils;
import io.trino.operator.join.LookupSourceFactory;
import io.trino.operator.join.LookupSourceProvider;
import io.trino.operator.join.PartitionedLookupSourceFactory;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import io.trino.spiller.GenericPartitioningSpillerFactory;
import io.trino.spiller.PartitioningSpillerFactory;
import io.trino.spiller.SingleStreamSpillerFactory;
import io.trino.sql.planner.NodePartitioningManager;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.MaterializedResult;
import io.trino.testing.TestingTaskContext;
import io.trino.util.FinalizerService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestHashJoinOperator {
    private static final int PARTITION_COUNT = 4;
    private static final SingleStreamSpillerFactory SINGLE_STREAM_SPILLER_FACTORY = new JoinTestUtils.DummySpillerFactory();
    private static final PartitioningSpillerFactory PARTITIONING_SPILLER_FACTORY = new GenericPartitioningSpillerFactory(SINGLE_STREAM_SPILLER_FACTORY);
    private static final TypeOperators TYPE_OPERATORS = new TypeOperators();
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
    private final ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));
    private final NodePartitioningManager nodePartitioningManager = new NodePartitioningManager(new NodeScheduler((NodeSelectorFactory)new UniformNodeSelectorFactory((InternalNodeManager)new InMemoryNodeManager(new InternalNode[0]), new NodeSchedulerConfig().setIncludeCoordinator(true), new NodeTaskMap(new FinalizerService()))), TYPE_OPERATORS, CatalogServiceProvider.fail());

    @AfterAll
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testInnerJoin() {
        this.testInnerJoin(true, true, true);
        this.testInnerJoin(true, true, false);
        this.testInnerJoin(true, false, true);
        this.testInnerJoin(true, false, false);
        this.testInnerJoin(false, true, true);
        this.testInnerJoin(false, true, false);
        this.testInnerJoin(false, false, true);
        this.testInnerJoin(false, false, false);
    }

    private void testInnerJoin(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT)).addSequencePage(10, 20, 30, 40);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
        List<Page> probeInput = probePages.addSequencePage(1000, 0, 1000, 2000).build();
        OperatorFactory joinOperatorFactory = JoinTestUtils.innerJoinOperatorFactory(lookupSourceFactory, probePages, PARTITIONING_SPILLER_FACTORY, false);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probePages.getTypesWithoutHash(), buildPages.getTypesWithoutHash())).row(new Object[]{"20", 1020L, 2020L, "20", 30L, 40L}).row(new Object[]{"21", 1021L, 2021L, "21", 31L, 41L}).row(new Object[]{"22", 1022L, 2022L, "22", 32L, 42L}).row(new Object[]{"23", 1023L, 2023L, "23", 33L, 43L}).row(new Object[]{"24", 1024L, 2024L, "24", 34L, 44L}).row(new Object[]{"25", 1025L, 2025L, "25", 35L, 45L}).row(new Object[]{"26", 1026L, 2026L, "26", 36L, 46L}).row(new Object[]{"27", 1027L, 2027L, "27", 37L, 47L}).row(new Object[]{"28", 1028L, 2028L, "28", 38L, 48L}).row(new Object[]{"29", 1029L, 2029L, "29", 39L, 49L}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test
    public void testInnerJoinWithRunLengthEncodedProbe() {
        TaskContext taskContext = this.createTaskContext();
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(false, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR)).addSequencePage(10, 20).addSequencePage(10, 21);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, false, taskContext, buildPages, Optional.empty(), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(false, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR));
        ImmutableList probeInput = ImmutableList.of((Object)new Page(new Block[]{RunLengthEncodedBlock.create((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"20"), (int)2)}), (Object)new Page(new Block[]{RunLengthEncodedBlock.create((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"-1"), (int)2)}), (Object)new Page(new Block[]{RunLengthEncodedBlock.create((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"21"), (int)2)}));
        OperatorFactory joinOperatorFactory = JoinTestUtils.innerJoinOperatorFactory(lookupSourceFactory, probePages, PARTITIONING_SPILLER_FACTORY, false);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probePages.getTypesWithoutHash(), buildPages.getTypesWithoutHash())).row(new Object[]{"20", "20"}).row(new Object[]{"20", "20"}).row(new Object[]{"21", "21"}).row(new Object[]{"21", "21"}).row(new Object[]{"21", "21"}).row(new Object[]{"21", "21"}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), (List<Page>)probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test
    public void testUnwrapsLazyBlocks() {
        TaskContext taskContext = this.createTaskContext();
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        JoinTestUtils.TestInternalJoinFilterFunction filterFunction = new JoinTestUtils.TestInternalJoinFilterFunction((leftPosition, leftPage, rightPosition, rightPage) -> {
            rightPage.getBlock(1).getLoadedBlock();
            return true;
        });
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(false, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addSequencePage(1, 0);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, true, taskContext, buildPages, Optional.of(filterFunction), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(false, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
        List probeInput = probePages.addSequencePage(1, 0, 0).build();
        probeInput = (List)probeInput.stream().map(page -> new Page(new Block[]{page.getBlock(0), new LazyBlock(1, () -> page.getBlock(1))})).collect(ImmutableList.toImmutableList());
        OperatorFactory joinOperatorFactory = OperatorFactories.spillingJoin((JoinOperatorType)JoinOperatorType.innerJoin((boolean)false, (boolean)false), (int)0, (PlanNodeId)new PlanNodeId("test"), lookupSourceFactory, probePages.getTypes(), (List)Ints.asList((int[])new int[]{0}), (OptionalInt)JoinTestUtils.getHashChannelAsInt(probePages), Optional.empty(), (OptionalInt)OptionalInt.of(1), (PartitioningSpillerFactory)PARTITIONING_SPILLER_FACTORY, (TypeOperators)TYPE_OPERATORS);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        Operator operator = joinOperatorFactory.createOperator(driverContext);
        Assertions.assertThat((boolean)operator.needsInput()).isTrue();
        operator.addInput((Page)probeInput.get(0));
        operator.finish();
        Page output = operator.getOutput();
        Assertions.assertThat((Object)output.getBlock(1)).isNotInstanceOf(LazyBlock.class);
    }

    @Test
    public void testYield() {
        TaskContext taskContext = this.createTaskContext();
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        AtomicInteger filterFunctionCalls = new AtomicInteger();
        JoinTestUtils.TestInternalJoinFilterFunction filterFunction = new JoinTestUtils.TestInternalJoinFilterFunction((leftPosition, leftPage, rightPosition, rightPage) -> {
            filterFunctionCalls.incrementAndGet();
            driverContext.getYieldSignal().forceYieldForTesting();
            return true;
        });
        int entries = 40;
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(true, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addSequencePage(entries, 42);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, true, taskContext, buildPages, Optional.of(filterFunction), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(false, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)BigintType.BIGINT));
        List<Page> probeInput = probePages.addSequencePage(100, 0).build();
        OperatorFactory joinOperatorFactory = OperatorFactories.spillingJoin((JoinOperatorType)JoinOperatorType.innerJoin((boolean)false, (boolean)false), (int)0, (PlanNodeId)new PlanNodeId("test"), lookupSourceFactory, probePages.getTypes(), (List)Ints.asList((int[])new int[]{0}), (OptionalInt)JoinTestUtils.getHashChannelAsInt(probePages), Optional.empty(), (OptionalInt)OptionalInt.of(1), (PartitioningSpillerFactory)PARTITIONING_SPILLER_FACTORY, (TypeOperators)TYPE_OPERATORS);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        Operator operator = joinOperatorFactory.createOperator(driverContext);
        Assertions.assertThat((boolean)operator.needsInput()).isTrue();
        operator.addInput(probeInput.get(0));
        operator.finish();
        for (int i = 0; i < entries; ++i) {
            driverContext.getYieldSignal().setWithDelay(5L * TimeUnit.SECONDS.toNanos(1L), driverContext.getYieldExecutor());
            filterFunctionCalls.set(0);
            Assertions.assertThat((Object)operator.getOutput()).isNull();
            ((AbstractIntegerAssert)Assertions.assertThat((int)filterFunctionCalls.get()).describedAs("Expected join to stop processing (yield) after calling filter function once", new Object[0])).isEqualTo(1);
            driverContext.getYieldSignal().reset();
        }
        driverContext.getYieldSignal().setWithDelay(5L * TimeUnit.SECONDS.toNanos(1L), driverContext.getYieldExecutor());
        Page output = null;
        for (int i = 0; output == null && i < 5; ++i) {
            output = operator.getOutput();
        }
        Assertions.assertThat(output).isNotNull();
        driverContext.getYieldSignal().reset();
        Assertions.assertThat((int)output.getPositionCount()).isEqualTo(entries);
    }

    @Test
    public void testInnerJoinWithSpill() throws Exception {
        UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)false, (Object)true).iterator();
        while (unmodifiableIterator.hasNext()) {
            boolean probeHashEnabled = (Boolean)unmodifiableIterator.next();
            this.innerJoinWithSpill(probeHashEnabled, Collections.nCopies(4, WhenSpill.NEVER), SINGLE_STREAM_SPILLER_FACTORY, PARTITIONING_SPILLER_FACTORY);
            this.innerJoinWithSpill(probeHashEnabled, Collections.nCopies(4, WhenSpill.DURING_BUILD), SINGLE_STREAM_SPILLER_FACTORY, PARTITIONING_SPILLER_FACTORY);
            this.innerJoinWithSpill(probeHashEnabled, Collections.nCopies(4, WhenSpill.AFTER_BUILD), SINGLE_STREAM_SPILLER_FACTORY, PARTITIONING_SPILLER_FACTORY);
            this.innerJoinWithSpill(probeHashEnabled, Collections.nCopies(4, WhenSpill.DURING_USAGE), SINGLE_STREAM_SPILLER_FACTORY, PARTITIONING_SPILLER_FACTORY);
            this.innerJoinWithSpill(probeHashEnabled, TestHashJoinOperator.concat(Collections.singletonList(WhenSpill.DURING_BUILD), Collections.nCopies(3, WhenSpill.NEVER)), SINGLE_STREAM_SPILLER_FACTORY, PARTITIONING_SPILLER_FACTORY);
            this.innerJoinWithSpill(probeHashEnabled, TestHashJoinOperator.concat(Collections.singletonList(WhenSpill.AFTER_BUILD), Collections.nCopies(3, WhenSpill.NEVER)), SINGLE_STREAM_SPILLER_FACTORY, PARTITIONING_SPILLER_FACTORY);
            this.innerJoinWithSpill(probeHashEnabled, TestHashJoinOperator.concat(Collections.singletonList(WhenSpill.DURING_USAGE), Collections.nCopies(3, WhenSpill.NEVER)), SINGLE_STREAM_SPILLER_FACTORY, PARTITIONING_SPILLER_FACTORY);
            this.innerJoinWithSpill(probeHashEnabled, TestHashJoinOperator.concat(Arrays.asList(WhenSpill.DURING_BUILD, WhenSpill.AFTER_BUILD), Collections.nCopies(2, WhenSpill.NEVER)), SINGLE_STREAM_SPILLER_FACTORY, PARTITIONING_SPILLER_FACTORY);
            this.innerJoinWithSpill(probeHashEnabled, TestHashJoinOperator.concat(Arrays.asList(WhenSpill.DURING_BUILD, WhenSpill.DURING_USAGE), Collections.nCopies(2, WhenSpill.NEVER)), SINGLE_STREAM_SPILLER_FACTORY, PARTITIONING_SPILLER_FACTORY);
        }
    }

    @Test
    public void testInnerJoinWithFailingSpill() {
        UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)false, (Object)true).iterator();
        while (unmodifiableIterator.hasNext()) {
            boolean probeHashEnabled = (Boolean)unmodifiableIterator.next();
            this.testInnerJoinWithFailingSpill(probeHashEnabled, Collections.nCopies(4, WhenSpill.DURING_USAGE));
            this.testInnerJoinWithFailingSpill(probeHashEnabled, Collections.nCopies(4, WhenSpill.DURING_BUILD));
            this.testInnerJoinWithFailingSpill(probeHashEnabled, Collections.nCopies(4, WhenSpill.AFTER_BUILD));
            this.testInnerJoinWithFailingSpill(probeHashEnabled, TestHashJoinOperator.concat(Collections.singletonList(WhenSpill.DURING_USAGE), Collections.nCopies(3, WhenSpill.NEVER)));
            this.testInnerJoinWithFailingSpill(probeHashEnabled, TestHashJoinOperator.concat(Collections.singletonList(WhenSpill.DURING_BUILD), Collections.nCopies(3, WhenSpill.NEVER)));
            this.testInnerJoinWithFailingSpill(probeHashEnabled, TestHashJoinOperator.concat(Collections.singletonList(WhenSpill.AFTER_BUILD), Collections.nCopies(3, WhenSpill.NEVER)));
            this.testInnerJoinWithFailingSpill(probeHashEnabled, TestHashJoinOperator.concat(Arrays.asList(WhenSpill.DURING_BUILD, WhenSpill.AFTER_BUILD), Collections.nCopies(2, WhenSpill.NEVER)));
            this.testInnerJoinWithFailingSpill(probeHashEnabled, TestHashJoinOperator.concat(Arrays.asList(WhenSpill.DURING_BUILD, WhenSpill.DURING_USAGE), Collections.nCopies(2, WhenSpill.NEVER)));
        }
    }

    private void testInnerJoinWithFailingSpill(boolean probeHashEnabled, List<WhenSpill> whenSpill) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.innerJoinWithSpill(probeHashEnabled, whenSpill, new JoinTestUtils.DummySpillerFactory().failSpill(), (PartitioningSpillerFactory)new GenericPartitioningSpillerFactory((SingleStreamSpillerFactory)new JoinTestUtils.DummySpillerFactory()))).isInstanceOf(RuntimeException.class)).hasMessage("Spill failed");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.innerJoinWithSpill(probeHashEnabled, whenSpill, new JoinTestUtils.DummySpillerFactory(), (PartitioningSpillerFactory)new GenericPartitioningSpillerFactory((SingleStreamSpillerFactory)new JoinTestUtils.DummySpillerFactory().failSpill()))).isInstanceOf(RuntimeException.class)).hasMessage("Spill failed");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.innerJoinWithSpill(probeHashEnabled, whenSpill, new JoinTestUtils.DummySpillerFactory().failUnspill(), (PartitioningSpillerFactory)new GenericPartitioningSpillerFactory((SingleStreamSpillerFactory)new JoinTestUtils.DummySpillerFactory()))).isInstanceOf(RuntimeException.class)).hasMessage("Unspill failed");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.innerJoinWithSpill(probeHashEnabled, whenSpill, new JoinTestUtils.DummySpillerFactory(), (PartitioningSpillerFactory)new GenericPartitioningSpillerFactory((SingleStreamSpillerFactory)new JoinTestUtils.DummySpillerFactory().failUnspill()))).isInstanceOf(RuntimeException.class)).hasMessage("Unspill failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerJoinWithSpill(boolean probeHashEnabled, List<WhenSpill> whenSpill, SingleStreamSpillerFactory buildSpillerFactory, PartitioningSpillerFactory joinSpillerFactory) throws Exception {
        TaskStateMachine taskStateMachine = new TaskStateMachine(new TaskId(new StageId("query", 0), 0, 0), (Executor)this.executor);
        TaskContext taskContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION, (TaskStateMachine)taskStateMachine);
        DriverContext joinDriverContext = taskContext.addPipelineContext(2, true, true, false).addDriverContext();
        AtomicBoolean called = new AtomicBoolean(false);
        JoinTestUtils.TestInternalJoinFilterFunction filterFunction = new JoinTestUtils.TestInternalJoinFilterFunction((leftPosition, leftPage, rightPosition, rightPage) -> {
            called.set(true);
            joinDriverContext.getYieldSignal().forceYieldForTesting();
            return true;
        });
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(false, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT)).addSequencePage(4, 20, 200).addSequencePage(4, 20, 200).addSequencePage(4, 30, 300).addSequencePage(4, 40, 400);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, true, taskContext, buildPages, Optional.of(filterFunction), true, buildSpillerFactory);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactoryManager = buildSideSetup.getLookupSourceFactoryManager();
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT)).row("20", 123000L).row("20", 123000L).pageBreak().addSequencePage(20, 0, 123000).addSequencePage(10, 30, 123000);
        OperatorFactory joinOperatorFactory = JoinTestUtils.innerJoinOperatorFactory(lookupSourceFactoryManager, probePages, joinSpillerFactory);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        List<Driver> buildDrivers = buildSideSetup.getBuildDrivers();
        int buildOperatorCount = buildDrivers.size();
        Preconditions.checkState((buildOperatorCount == whenSpill.size() ? 1 : 0) != 0);
        LookupSourceFactory lookupSourceFactory = (LookupSourceFactory)lookupSourceFactoryManager.getJoinBridge();
        try (Operator joinOperator = joinOperatorFactory.createOperator(joinDriverContext);){
            int i;
            ListenableFuture lookupSourceProvider = lookupSourceFactory.createLookupSourceProvider();
            ArrayList<Boolean> revoked = new ArrayList<Boolean>(Collections.nCopies(buildOperatorCount, false));
            while (!lookupSourceProvider.isDone()) {
                for (i = 0; i < buildOperatorCount; ++i) {
                    TestHashJoinOperator.checkErrors(taskStateMachine);
                    buildDrivers.get(i).processForNumberOfIterations(1);
                    HashBuilderOperator buildOperator = buildSideSetup.getBuildOperators().get(i);
                    if (whenSpill.get(i) != WhenSpill.DURING_BUILD || buildOperator.getOperatorContext().getReservedRevocableBytes() <= 0L) continue;
                    Preconditions.checkState((!lookupSourceProvider.isDone() ? 1 : 0) != 0, (Object)"Too late, LookupSource already done");
                    TestHashJoinOperator.revokeMemory(buildOperator);
                    revoked.set(i, true);
                }
            }
            ((LookupSourceProvider)MoreFutures.getFutureValue((Future)lookupSourceProvider)).close();
            ((ListAssert)Assertions.assertThat(revoked).describedAs("Some operators not spilled before LookupSource built", new Object[0])).isEqualTo(whenSpill.stream().map(WhenSpill.DURING_BUILD::equals).collect(ImmutableList.toImmutableList()));
            for (i = 0; i < buildOperatorCount; ++i) {
                if (whenSpill.get(i) != WhenSpill.AFTER_BUILD) continue;
                TestHashJoinOperator.revokeMemory(buildSideSetup.getBuildOperators().get(i));
            }
            for (Driver buildDriver : buildDrivers) {
                JoinTestUtils.runDriverInThread(this.executor, buildDriver);
            }
            ValuesOperator.ValuesOperatorFactory valuesOperatorFactory = new ValuesOperator.ValuesOperatorFactory(17, new PlanNodeId("values"), probePages.build());
            PageBuffer pageBuffer = new PageBuffer(10);
            PageBufferOperator.PageBufferOperatorFactory pageBufferOperatorFactory = new PageBufferOperator.PageBufferOperatorFactory(18, new PlanNodeId("pageBuffer"), pageBuffer, "PageBuffer");
            Driver joinDriver = Driver.createDriver((DriverContext)joinDriverContext, (Operator)valuesOperatorFactory.createOperator(joinDriverContext), (Operator[])new Operator[]{joinOperator, pageBufferOperatorFactory.createOperator(joinDriverContext)});
            while (!called.get()) {
                TestHashJoinOperator.processRow(joinDriver, taskStateMachine);
            }
            for (int i2 = 0; i2 < buildOperatorCount; ++i2) {
                if (whenSpill.get(i2) != WhenSpill.DURING_USAGE) continue;
                TestHashJoinOperator.triggerMemoryRevokingAndWait(buildSideSetup.getBuildOperators().get(i2), taskStateMachine);
            }
            while (!joinDriver.isFinished()) {
                TestHashJoinOperator.checkErrors(taskStateMachine);
                TestHashJoinOperator.processRow(joinDriver, taskStateMachine);
            }
            TestHashJoinOperator.checkErrors(taskStateMachine);
            List<Page> actualPages = TestHashJoinOperator.getPages(pageBuffer);
            MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probePages.getTypesWithoutHash(), buildPages.getTypesWithoutHash())).row(new Object[]{"20", 123000L, "20", 200L}).row(new Object[]{"20", 123000L, "20", 200L}).row(new Object[]{"20", 123000L, "20", 200L}).row(new Object[]{"20", 123000L, "20", 200L}).row(new Object[]{"30", 123000L, "30", 300L}).row(new Object[]{"31", 123001L, "31", 301L}).row(new Object[]{"32", 123002L, "32", 302L}).row(new Object[]{"33", 123003L, "33", 303L}).build();
            Assertions.assertThat((List)TestHashJoinOperator.getProperColumns(joinOperator, TestHashJoinOperator.concat(probePages.getTypes(), buildPages.getTypes()), probePages, actualPages).getMaterializedRows()).containsExactlyInAnyOrderElementsOf((Iterable)expected.getMaterializedRows());
        }
        finally {
            joinOperatorFactory.noMoreOperators();
        }
    }

    private static void processRow(Driver joinDriver, TaskStateMachine taskStateMachine) {
        joinDriver.process(new Duration(1.0, TimeUnit.NANOSECONDS), 1);
        TestHashJoinOperator.checkErrors(taskStateMachine);
    }

    private static void checkErrors(TaskStateMachine taskStateMachine) {
        if (taskStateMachine.getFailureCauses().size() > 0) {
            Throwable exception = Objects.requireNonNull((Throwable)taskStateMachine.getFailureCauses().peek());
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    private static void revokeMemory(HashBuilderOperator operator) {
        MoreFutures.getFutureValue((Future)operator.startMemoryRevoke());
        operator.finishMemoryRevoke();
        Preconditions.checkState((operator.getState() == HashBuilderOperator.State.SPILLING_INPUT || operator.getState() == HashBuilderOperator.State.INPUT_SPILLED ? 1 : 0) != 0);
    }

    private static void triggerMemoryRevokingAndWait(HashBuilderOperator operator, TaskStateMachine taskStateMachine) throws Exception {
        operator.getOperatorContext().requestMemoryRevoking();
        while (operator.getOperatorContext().isMemoryRevokingRequested()) {
            TestHashJoinOperator.checkErrors(taskStateMachine);
            Thread.sleep(10L);
        }
        TestHashJoinOperator.checkErrors(taskStateMachine);
        Preconditions.checkState((operator.getState() == HashBuilderOperator.State.SPILLING_INPUT || operator.getState() == HashBuilderOperator.State.INPUT_SPILLED ? 1 : 0) != 0);
    }

    private static List<Page> getPages(PageBuffer pageBuffer) {
        ArrayList<Page> result = new ArrayList<Page>();
        Page page = pageBuffer.poll();
        while (page != null) {
            result.add(page);
            page = pageBuffer.poll();
        }
        return result;
    }

    private static MaterializedResult getProperColumns(Operator joinOperator, List<Type> types, RowPagesBuilder probePages, List<Page> actualPages) {
        if (probePages.getHashChannel().isPresent()) {
            ImmutableList hashChannels = ImmutableList.of((Object)probePages.getHashChannel().get());
            actualPages = OperatorAssertion.dropChannel(actualPages, (List<Integer>)hashChannels);
            types = OperatorAssertion.without(types, (Collection<Integer>)hashChannels);
        }
        return OperatorAssertion.toMaterializedResult(joinOperator.getOperatorContext().getSession(), types, actualPages);
    }

    @Test
    @Timeout(value=30L)
    public void testBuildGracefulSpill() throws Exception {
        TaskStateMachine taskStateMachine = new TaskStateMachine(new TaskId(new StageId("query", 0), 0, 0), (Executor)this.executor);
        TaskContext taskContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION, (TaskStateMachine)taskStateMachine);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(false, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT)).addSequencePage(4, 20, 200);
        JoinTestUtils.DummySpillerFactory buildSpillerFactory = new JoinTestUtils.DummySpillerFactory();
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, true, taskContext, buildPages, Optional.empty(), true, buildSpillerFactory);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactoryManager = buildSideSetup.getLookupSourceFactoryManager();
        PartitionedLookupSourceFactory lookupSourceFactory = (PartitionedLookupSourceFactory)lookupSourceFactoryManager.getJoinBridge();
        lookupSourceFactory.finishProbeOperator(OptionalInt.of(1));
        HashBuilderOperator hashBuilderOperator = buildSideSetup.getBuildOperators().get(0);
        hashBuilderOperator.startMemoryRevoke().get();
        hashBuilderOperator.finishMemoryRevoke();
        hashBuilderOperator.finish();
        hashBuilderOperator.isBlocked().get();
        lookupSourceFactory.destroy();
        Assertions.assertThat((boolean)hashBuilderOperator.isFinished()).isTrue();
    }

    @Test
    public void testInnerJoinWithNullProbe() {
        this.testInnerJoinWithNullProbe(true, true, true);
        this.testInnerJoinWithNullProbe(true, true, false);
        this.testInnerJoinWithNullProbe(true, false, true);
        this.testInnerJoinWithNullProbe(true, false, false);
        this.testInnerJoinWithNullProbe(false, true, true);
        this.testInnerJoinWithNullProbe(false, true, false);
        this.testInnerJoinWithNullProbe(false, false, true);
        this.testInnerJoinWithNullProbe(false, false, false);
    }

    private void testInnerJoinWithNullProbe(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes).row("a").row("b").row("c");
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("a").row(new Object[]{null}).row(new Object[]{null}).row("a").row("b").build();
        OperatorFactory joinOperatorFactory = JoinTestUtils.innerJoinOperatorFactory(lookupSourceFactory, probePages, PARTITIONING_SPILLER_FACTORY);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildPages.getTypesWithoutHash())).row(new Object[]{"a", "a"}).row(new Object[]{"a", "a"}).row(new Object[]{"b", "b"}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test
    public void testInnerJoinWithOutputSingleMatch() {
        this.testInnerJoinWithOutputSingleMatch(true, true, true);
        this.testInnerJoinWithOutputSingleMatch(true, true, false);
        this.testInnerJoinWithOutputSingleMatch(true, false, true);
        this.testInnerJoinWithOutputSingleMatch(true, false, false);
        this.testInnerJoinWithOutputSingleMatch(false, true, true);
        this.testInnerJoinWithOutputSingleMatch(false, true, false);
        this.testInnerJoinWithOutputSingleMatch(false, false, true);
        this.testInnerJoinWithOutputSingleMatch(false, false, false);
    }

    private void testInnerJoinWithOutputSingleMatch(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes).row("a").row("a").row("b");
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("a").row("b").row("c").build();
        OperatorFactory joinOperatorFactory = JoinTestUtils.innerJoinOperatorFactory(lookupSourceFactory, probePages, PARTITIONING_SPILLER_FACTORY, true);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildTypes)).row(new Object[]{"a", "a"}).row(new Object[]{"b", "b"}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test
    public void testInnerJoinWithNullBuild() {
        this.testInnerJoinWithNullBuild(true, true, true);
        this.testInnerJoinWithNullBuild(true, true, false);
        this.testInnerJoinWithNullBuild(true, false, true);
        this.testInnerJoinWithNullBuild(true, false, false);
        this.testInnerJoinWithNullBuild(false, true, true);
        this.testInnerJoinWithNullBuild(false, true, false);
        this.testInnerJoinWithNullBuild(false, false, true);
        this.testInnerJoinWithNullBuild(false, false, false);
    }

    private void testInnerJoinWithNullBuild(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes).row("a").row(new Object[]{null}).row(new Object[]{null}).row("a").row("b");
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("a").row("b").row("c").build();
        OperatorFactory joinOperatorFactory = JoinTestUtils.innerJoinOperatorFactory(lookupSourceFactory, probePages, PARTITIONING_SPILLER_FACTORY, false);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildTypes)).row(new Object[]{"a", "a"}).row(new Object[]{"a", "a"}).row(new Object[]{"b", "b"}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test
    public void testInnerJoinWithNullOnBothSides() {
        this.testInnerJoinWithNullOnBothSides(true, true, true);
        this.testInnerJoinWithNullOnBothSides(true, true, false);
        this.testInnerJoinWithNullOnBothSides(true, false, true);
        this.testInnerJoinWithNullOnBothSides(true, false, false);
        this.testInnerJoinWithNullOnBothSides(false, true, true);
        this.testInnerJoinWithNullOnBothSides(false, true, false);
        this.testInnerJoinWithNullOnBothSides(false, false, true);
        this.testInnerJoinWithNullOnBothSides(false, false, false);
    }

    private void testInnerJoinWithNullOnBothSides(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes).row("a").row(new Object[]{null}).row(new Object[]{null}).row("a").row("b");
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("a").row("b").row(new Object[]{null}).row("c").build();
        OperatorFactory joinOperatorFactory = JoinTestUtils.innerJoinOperatorFactory(lookupSourceFactory, probePages, PARTITIONING_SPILLER_FACTORY);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildTypes)).row(new Object[]{"a", "a"}).row(new Object[]{"a", "a"}).row(new Object[]{"b", "b"}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test
    public void testProbeOuterJoin() {
        this.testProbeOuterJoin(true, true, true);
        this.testProbeOuterJoin(true, true, false);
        this.testProbeOuterJoin(true, false, true);
        this.testProbeOuterJoin(true, false, false);
        this.testProbeOuterJoin(false, true, true);
        this.testProbeOuterJoin(false, true, false);
        this.testProbeOuterJoin(false, false, true);
        this.testProbeOuterJoin(false, false, false);
    }

    private void testProbeOuterJoin(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT)).addSequencePage(10, 20, 30, 40);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.addSequencePage(15, 20, 1020, 2020).build();
        OperatorFactory joinOperatorFactory = this.probeOuterJoinOperatorFactory(lookupSourceFactory, probePages);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildTypes)).row(new Object[]{"20", 1020L, 2020L, "20", 30L, 40L}).row(new Object[]{"21", 1021L, 2021L, "21", 31L, 41L}).row(new Object[]{"22", 1022L, 2022L, "22", 32L, 42L}).row(new Object[]{"23", 1023L, 2023L, "23", 33L, 43L}).row(new Object[]{"24", 1024L, 2024L, "24", 34L, 44L}).row(new Object[]{"25", 1025L, 2025L, "25", 35L, 45L}).row(new Object[]{"26", 1026L, 2026L, "26", 36L, 46L}).row(new Object[]{"27", 1027L, 2027L, "27", 37L, 47L}).row(new Object[]{"28", 1028L, 2028L, "28", 38L, 48L}).row(new Object[]{"29", 1029L, 2029L, "29", 39L, 49L}).row(new Object[]{"30", 1030L, 2030L, null, null, null}).row(new Object[]{"31", 1031L, 2031L, null, null, null}).row(new Object[]{"32", 1032L, 2032L, null, null, null}).row(new Object[]{"33", 1033L, 2033L, null, null, null}).row(new Object[]{"34", 1034L, 2034L, null, null, null}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test
    public void testProbeOuterJoinWithFilterFunction() {
        this.testProbeOuterJoinWithFilterFunction(true, true, true);
        this.testProbeOuterJoinWithFilterFunction(true, true, false);
        this.testProbeOuterJoinWithFilterFunction(true, false, true);
        this.testProbeOuterJoinWithFilterFunction(true, false, false);
        this.testProbeOuterJoinWithFilterFunction(false, true, true);
        this.testProbeOuterJoinWithFilterFunction(false, true, false);
        this.testProbeOuterJoinWithFilterFunction(false, false, true);
        this.testProbeOuterJoinWithFilterFunction(false, false, false);
    }

    private void testProbeOuterJoinWithFilterFunction(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        JoinTestUtils.TestInternalJoinFilterFunction filterFunction = new JoinTestUtils.TestInternalJoinFilterFunction((leftPosition, leftPage, rightPosition, rightPage) -> BigintType.BIGINT.getLong(rightPage.getBlock(1), rightPosition) >= 1025L);
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT)).addSequencePage(10, 20, 30, 40);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.of(filterFunction), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.addSequencePage(15, 20, 1020, 2020).build();
        OperatorFactory joinOperatorFactory = this.probeOuterJoinOperatorFactory(lookupSourceFactory, probePages);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildTypes)).row(new Object[]{"20", 1020L, 2020L, null, null, null}).row(new Object[]{"21", 1021L, 2021L, null, null, null}).row(new Object[]{"22", 1022L, 2022L, null, null, null}).row(new Object[]{"23", 1023L, 2023L, null, null, null}).row(new Object[]{"24", 1024L, 2024L, null, null, null}).row(new Object[]{"25", 1025L, 2025L, "25", 35L, 45L}).row(new Object[]{"26", 1026L, 2026L, "26", 36L, 46L}).row(new Object[]{"27", 1027L, 2027L, "27", 37L, 47L}).row(new Object[]{"28", 1028L, 2028L, "28", 38L, 48L}).row(new Object[]{"29", 1029L, 2029L, "29", 39L, 49L}).row(new Object[]{"30", 1030L, 2030L, null, null, null}).row(new Object[]{"31", 1031L, 2031L, null, null, null}).row(new Object[]{"32", 1032L, 2032L, null, null, null}).row(new Object[]{"33", 1033L, 2033L, null, null, null}).row(new Object[]{"34", 1034L, 2034L, null, null, null}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test
    public void testOuterJoinWithNullProbe() {
        this.testOuterJoinWithNullProbe(true, true, true);
        this.testOuterJoinWithNullProbe(true, true, false);
        this.testOuterJoinWithNullProbe(true, false, true);
        this.testOuterJoinWithNullProbe(true, false, false);
        this.testOuterJoinWithNullProbe(false, true, true);
        this.testOuterJoinWithNullProbe(false, true, false);
        this.testOuterJoinWithNullProbe(false, false, true);
        this.testOuterJoinWithNullProbe(false, false, false);
    }

    private void testOuterJoinWithNullProbe(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes).row("a").row("b").row("c");
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("a").row(new Object[]{null}).row(new Object[]{null}).row("a").row("b").build();
        OperatorFactory joinOperatorFactory = this.probeOuterJoinOperatorFactory(lookupSourceFactory, probePages);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildTypes)).row(new Object[]{"a", "a"}).row(new Object[]{null, null}).row(new Object[]{null, null}).row(new Object[]{"a", "a"}).row(new Object[]{"b", "b"}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test
    public void testOuterJoinWithNullProbeAndFilterFunction() {
        this.testOuterJoinWithNullProbeAndFilterFunction(true, true, true);
        this.testOuterJoinWithNullProbeAndFilterFunction(true, true, false);
        this.testOuterJoinWithNullProbeAndFilterFunction(true, false, true);
        this.testOuterJoinWithNullProbeAndFilterFunction(true, false, false);
        this.testOuterJoinWithNullProbeAndFilterFunction(false, true, true);
        this.testOuterJoinWithNullProbeAndFilterFunction(false, true, false);
        this.testOuterJoinWithNullProbeAndFilterFunction(false, false, true);
        this.testOuterJoinWithNullProbeAndFilterFunction(false, false, false);
    }

    private void testOuterJoinWithNullProbeAndFilterFunction(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        JoinTestUtils.TestInternalJoinFilterFunction filterFunction = new JoinTestUtils.TestInternalJoinFilterFunction((leftPosition, leftPage, rightPosition, rightPage) -> VarcharType.VARCHAR.getSlice(rightPage.getBlock(0), rightPosition).toStringAscii().equals("a"));
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes).row("a").row("b").row("c");
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.of(filterFunction), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("a").row(new Object[]{null}).row(new Object[]{null}).row("a").row("b").build();
        OperatorFactory joinOperatorFactory = this.probeOuterJoinOperatorFactory(lookupSourceFactory, probePages);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildTypes)).row(new Object[]{"a", "a"}).row(new Object[]{null, null}).row(new Object[]{null, null}).row(new Object[]{"a", "a"}).row(new Object[]{"b", null}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test
    public void testOuterJoinWithNullBuild() {
        this.testOuterJoinWithNullBuild(true, true, true);
        this.testOuterJoinWithNullBuild(true, true, false);
        this.testOuterJoinWithNullBuild(true, false, true);
        this.testOuterJoinWithNullBuild(true, false, false);
        this.testOuterJoinWithNullBuild(false, true, true);
        this.testOuterJoinWithNullBuild(false, true, false);
        this.testOuterJoinWithNullBuild(false, false, true);
        this.testOuterJoinWithNullBuild(false, false, false);
    }

    private void testOuterJoinWithNullBuild(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR)).row("a").row(new Object[]{null}).row(new Object[]{null}).row("a").row("b");
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("a").row("b").row("c").build();
        OperatorFactory joinOperatorFactory = this.probeOuterJoinOperatorFactory(lookupSourceFactory, probePages);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildTypes)).row(new Object[]{"a", "a"}).row(new Object[]{"a", "a"}).row(new Object[]{"b", "b"}).row(new Object[]{"c", null}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test
    public void testOuterJoinWithNullBuildAndFilterFunction() {
        this.testOuterJoinWithNullBuildAndFilterFunction(true, true, true);
        this.testOuterJoinWithNullBuildAndFilterFunction(true, true, false);
        this.testOuterJoinWithNullBuildAndFilterFunction(true, false, true);
        this.testOuterJoinWithNullBuildAndFilterFunction(true, false, false);
        this.testOuterJoinWithNullBuildAndFilterFunction(false, true, true);
        this.testOuterJoinWithNullBuildAndFilterFunction(false, true, false);
        this.testOuterJoinWithNullBuildAndFilterFunction(false, false, true);
        this.testOuterJoinWithNullBuildAndFilterFunction(false, false, false);
    }

    private void testOuterJoinWithNullBuildAndFilterFunction(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        JoinTestUtils.TestInternalJoinFilterFunction filterFunction = new JoinTestUtils.TestInternalJoinFilterFunction((leftPosition, leftPage, rightPosition, rightPage) -> ImmutableSet.of((Object)"a", (Object)"c").contains((Object)VarcharType.VARCHAR.getSlice(rightPage.getBlock(0), rightPosition).toStringAscii()));
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR)).row("a").row(new Object[]{null}).row(new Object[]{null}).row("a").row("b");
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.of(filterFunction), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("a").row("b").row("c").build();
        OperatorFactory joinOperatorFactory = this.probeOuterJoinOperatorFactory(lookupSourceFactory, probePages);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildTypes)).row(new Object[]{"a", "a"}).row(new Object[]{"a", "a"}).row(new Object[]{"b", null}).row(new Object[]{"c", null}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test
    public void testOuterJoinWithNullOnBothSides() {
        this.testOuterJoinWithNullOnBothSides(true, true, true);
        this.testOuterJoinWithNullOnBothSides(true, true, false);
        this.testOuterJoinWithNullOnBothSides(true, false, true);
        this.testOuterJoinWithNullOnBothSides(true, false, false);
        this.testOuterJoinWithNullOnBothSides(false, true, true);
        this.testOuterJoinWithNullOnBothSides(false, true, false);
        this.testOuterJoinWithNullOnBothSides(false, false, true);
        this.testOuterJoinWithNullOnBothSides(false, false, false);
    }

    private void testOuterJoinWithNullOnBothSides(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR)).row("a").row(new Object[]{null}).row(new Object[]{null}).row("a").row("b");
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("a").row("b").row(new Object[]{null}).row("c").build();
        OperatorFactory joinOperatorFactory = this.probeOuterJoinOperatorFactory(lookupSourceFactory, probePages);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildPages.getTypesWithoutHash())).row(new Object[]{"a", "a"}).row(new Object[]{"a", "a"}).row(new Object[]{"b", "b"}).row(new Object[]{null, null}).row(new Object[]{"c", null}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test
    public void testOuterJoinWithNullOnBothSidesAndFilterFunction() {
        this.testOuterJoinWithNullOnBothSidesAndFilterFunction(true, true, true);
        this.testOuterJoinWithNullOnBothSidesAndFilterFunction(true, true, false);
        this.testOuterJoinWithNullOnBothSidesAndFilterFunction(true, false, true);
        this.testOuterJoinWithNullOnBothSidesAndFilterFunction(true, false, false);
        this.testOuterJoinWithNullOnBothSidesAndFilterFunction(false, true, true);
        this.testOuterJoinWithNullOnBothSidesAndFilterFunction(false, true, false);
        this.testOuterJoinWithNullOnBothSidesAndFilterFunction(false, false, true);
        this.testOuterJoinWithNullOnBothSidesAndFilterFunction(false, false, false);
    }

    private void testOuterJoinWithNullOnBothSidesAndFilterFunction(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        JoinTestUtils.TestInternalJoinFilterFunction filterFunction = new JoinTestUtils.TestInternalJoinFilterFunction((leftPosition, leftPage, rightPosition, rightPage) -> ImmutableSet.of((Object)"a", (Object)"c").contains((Object)VarcharType.VARCHAR.getSlice(rightPage.getBlock(0), rightPosition).toStringAscii()));
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR)).row("a").row(new Object[]{null}).row(new Object[]{null}).row("a").row("b");
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.of(filterFunction), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("a").row("b").row(new Object[]{null}).row("c").build();
        OperatorFactory joinOperatorFactory = this.probeOuterJoinOperatorFactory(lookupSourceFactory, probePages);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildPages.getTypesWithoutHash())).row(new Object[]{"a", "a"}).row(new Object[]{"a", "a"}).row(new Object[]{"b", null}).row(new Object[]{null, null}).row(new Object[]{"c", null}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test
    public void testMemoryLimit() {
        this.testMemoryLimit(true, true);
        this.testMemoryLimit(true, false);
        this.testMemoryLimit(false, true);
        this.testMemoryLimit(false, false);
    }

    private void testMemoryLimit(boolean parallelBuild, boolean buildHashEnabled) {
        TaskContext taskContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION, (DataSize)DataSize.ofBytes((long)100L));
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT)).addSequencePage(10, 20, 30, 40);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JoinTestUtils.buildLookupSource(this.executor, buildSideSetup)).isInstanceOf(ExceededMemoryLimitException.class)).hasMessageMatching("Query exceeded per-node memory limit of.*");
    }

    @Test
    public void testInnerJoinWithEmptyLookupSource() {
        this.testInnerJoinWithEmptyLookupSource(true, true, true);
        this.testInnerJoinWithEmptyLookupSource(true, true, false);
        this.testInnerJoinWithEmptyLookupSource(true, false, true);
        this.testInnerJoinWithEmptyLookupSource(true, false, false);
        this.testInnerJoinWithEmptyLookupSource(false, true, true);
        this.testInnerJoinWithEmptyLookupSource(false, true, false);
        this.testInnerJoinWithEmptyLookupSource(false, false, true);
        this.testInnerJoinWithEmptyLookupSource(false, false, false);
    }

    private void testInnerJoinWithEmptyLookupSource(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactoryManager = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        OperatorFactory joinOperatorFactory = OperatorFactories.spillingJoin((JoinOperatorType)JoinOperatorType.innerJoin((boolean)false, (boolean)false), (int)0, (PlanNodeId)new PlanNodeId("test"), lookupSourceFactoryManager, probePages.getTypes(), (List)Ints.asList((int[])new int[]{0}), (OptionalInt)JoinTestUtils.getHashChannelAsInt(probePages), Optional.empty(), (OptionalInt)OptionalInt.of(1), (PartitioningSpillerFactory)PARTITIONING_SPILLER_FACTORY, (TypeOperators)TYPE_OPERATORS);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        Operator operator = joinOperatorFactory.createOperator(taskContext.addPipelineContext(0, true, true, false).addDriverContext());
        List<Page> pages = probePages.row("test").build();
        operator.addInput(pages.get(0));
        Page outputPage = operator.getOutput();
        Assertions.assertThat((Object)outputPage).isNull();
    }

    @Test
    public void testLookupOuterJoinWithEmptyLookupSource() {
        this.testLookupOuterJoinWithEmptyLookupSource(true, true, true);
        this.testLookupOuterJoinWithEmptyLookupSource(true, true, false);
        this.testLookupOuterJoinWithEmptyLookupSource(true, false, true);
        this.testLookupOuterJoinWithEmptyLookupSource(true, false, false);
        this.testLookupOuterJoinWithEmptyLookupSource(false, true, true);
        this.testLookupOuterJoinWithEmptyLookupSource(false, true, false);
        this.testLookupOuterJoinWithEmptyLookupSource(false, false, true);
        this.testLookupOuterJoinWithEmptyLookupSource(false, false, false);
    }

    private void testLookupOuterJoinWithEmptyLookupSource(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactoryManager = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        OperatorFactory joinOperatorFactory = OperatorFactories.spillingJoin((JoinOperatorType)JoinOperatorType.lookupOuterJoin((boolean)false), (int)0, (PlanNodeId)new PlanNodeId("test"), lookupSourceFactoryManager, probePages.getTypes(), (List)Ints.asList((int[])new int[]{0}), (OptionalInt)JoinTestUtils.getHashChannelAsInt(probePages), Optional.empty(), (OptionalInt)OptionalInt.of(1), (PartitioningSpillerFactory)PARTITIONING_SPILLER_FACTORY, (TypeOperators)TYPE_OPERATORS);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        Operator operator = joinOperatorFactory.createOperator(taskContext.addPipelineContext(0, true, true, false).addDriverContext());
        List<Page> pages = probePages.row("test").build();
        operator.addInput(pages.get(0));
        Page outputPage = operator.getOutput();
        Assertions.assertThat((Object)outputPage).isNull();
    }

    @Test
    public void testProbeOuterJoinWithEmptyLookupSource() {
        this.testProbeOuterJoinWithEmptyLookupSource(true, true, true);
        this.testProbeOuterJoinWithEmptyLookupSource(true, true, false);
        this.testProbeOuterJoinWithEmptyLookupSource(true, false, true);
        this.testProbeOuterJoinWithEmptyLookupSource(true, false, false);
        this.testProbeOuterJoinWithEmptyLookupSource(false, true, true);
        this.testProbeOuterJoinWithEmptyLookupSource(false, true, false);
        this.testProbeOuterJoinWithEmptyLookupSource(false, false, true);
        this.testProbeOuterJoinWithEmptyLookupSource(false, false, false);
    }

    private void testProbeOuterJoinWithEmptyLookupSource(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactoryManager = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("a").row("b").row(new Object[]{null}).row("c").build();
        OperatorFactory joinOperatorFactory = OperatorFactories.spillingJoin((JoinOperatorType)JoinOperatorType.probeOuterJoin((boolean)false), (int)0, (PlanNodeId)new PlanNodeId("test"), lookupSourceFactoryManager, probePages.getTypes(), (List)Ints.asList((int[])new int[]{0}), (OptionalInt)JoinTestUtils.getHashChannelAsInt(probePages), Optional.empty(), (OptionalInt)OptionalInt.of(1), (PartitioningSpillerFactory)PARTITIONING_SPILLER_FACTORY, (TypeOperators)TYPE_OPERATORS);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildTypes)).row(new Object[]{"a", null}).row(new Object[]{"b", null}).row(new Object[]{null, null}).row(new Object[]{"c", null}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test
    public void testFullOuterJoinWithEmptyLookupSource() {
        this.testFullOuterJoinWithEmptyLookupSource(true, true, true);
        this.testFullOuterJoinWithEmptyLookupSource(true, true, false);
        this.testFullOuterJoinWithEmptyLookupSource(true, false, true);
        this.testFullOuterJoinWithEmptyLookupSource(true, false, false);
        this.testFullOuterJoinWithEmptyLookupSource(false, true, true);
        this.testFullOuterJoinWithEmptyLookupSource(false, true, false);
        this.testFullOuterJoinWithEmptyLookupSource(false, false, true);
        this.testFullOuterJoinWithEmptyLookupSource(false, false, false);
    }

    private void testFullOuterJoinWithEmptyLookupSource(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactoryManager = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.row("a").row("b").row(new Object[]{null}).row("c").build();
        OperatorFactory joinOperatorFactory = OperatorFactories.spillingJoin((JoinOperatorType)JoinOperatorType.fullOuterJoin(), (int)0, (PlanNodeId)new PlanNodeId("test"), lookupSourceFactoryManager, probePages.getTypes(), (List)Ints.asList((int[])new int[]{0}), (OptionalInt)JoinTestUtils.getHashChannelAsInt(probePages), Optional.empty(), (OptionalInt)OptionalInt.of(1), (PartitioningSpillerFactory)PARTITIONING_SPILLER_FACTORY, (TypeOperators)TYPE_OPERATORS);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildTypes)).row(new Object[]{"a", null}).row(new Object[]{"b", null}).row(new Object[]{null, null}).row(new Object[]{"c", null}).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test
    public void testInnerJoinWithNonEmptyLookupSourceAndEmptyProbe() {
        this.testInnerJoinWithNonEmptyLookupSourceAndEmptyProbe(true, true, true);
        this.testInnerJoinWithNonEmptyLookupSourceAndEmptyProbe(true, true, false);
        this.testInnerJoinWithNonEmptyLookupSourceAndEmptyProbe(true, false, true);
        this.testInnerJoinWithNonEmptyLookupSourceAndEmptyProbe(true, false, false);
        this.testInnerJoinWithNonEmptyLookupSourceAndEmptyProbe(false, true, true);
        this.testInnerJoinWithNonEmptyLookupSourceAndEmptyProbe(false, true, false);
        this.testInnerJoinWithNonEmptyLookupSourceAndEmptyProbe(false, false, true);
        this.testInnerJoinWithNonEmptyLookupSourceAndEmptyProbe(false, false, false);
    }

    private void testInnerJoinWithNonEmptyLookupSourceAndEmptyProbe(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes).row("a").row("b").row(new Object[]{null}).row("c");
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactoryManager = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        List<Page> probeInput = probePages.build();
        OperatorFactory joinOperatorFactory = OperatorFactories.spillingJoin((JoinOperatorType)JoinOperatorType.innerJoin((boolean)false, (boolean)false), (int)0, (PlanNodeId)new PlanNodeId("test"), lookupSourceFactoryManager, probePages.getTypes(), (List)Ints.asList((int[])new int[]{0}), (OptionalInt)JoinTestUtils.getHashChannelAsInt(probePages), Optional.empty(), (OptionalInt)OptionalInt.of(1), (PartitioningSpillerFactory)PARTITIONING_SPILLER_FACTORY, (TypeOperators)TYPE_OPERATORS);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)taskContext.getSession(), TestHashJoinOperator.concat(probeTypes, buildTypes)).build();
        OperatorAssertion.assertOperatorEquals(joinOperatorFactory, taskContext.addPipelineContext(0, true, true, false).addDriverContext(), probeInput, expected, true, TestHashJoinOperator.getHashChannels(probePages, buildPages));
    }

    @Test
    public void testInnerJoinWithBlockingLookupSourceAndEmptyProbe() throws Exception {
        this.testInnerJoinWithBlockingLookupSourceAndEmptyProbe(true, true, true);
        this.testInnerJoinWithBlockingLookupSourceAndEmptyProbe(true, true, false);
        this.testInnerJoinWithBlockingLookupSourceAndEmptyProbe(true, false, true);
        this.testInnerJoinWithBlockingLookupSourceAndEmptyProbe(true, false, false);
        this.testInnerJoinWithBlockingLookupSourceAndEmptyProbe(false, true, true);
        this.testInnerJoinWithBlockingLookupSourceAndEmptyProbe(false, true, false);
        this.testInnerJoinWithBlockingLookupSourceAndEmptyProbe(false, false, true);
        this.testInnerJoinWithBlockingLookupSourceAndEmptyProbe(false, false, false);
    }

    private void testInnerJoinWithBlockingLookupSourceAndEmptyProbe(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) throws Exception {
        TaskContext taskContext = this.createTaskContext();
        OperatorFactory joinOperatorFactory = this.createJoinOperatorFactoryWithBlockingLookupSource(taskContext, parallelBuild, probeHashEnabled, buildHashEnabled, true);
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        try (Operator joinOperator = joinOperatorFactory.createOperator(driverContext);){
            joinOperatorFactory.noMoreOperators();
            Assertions.assertThat((boolean)joinOperator.needsInput()).isFalse();
            joinOperator.finish();
            Assertions.assertThat((Object)joinOperator.getOutput()).isNull();
            Assertions.assertThat((boolean)joinOperator.isBlocked().isDone()).isFalse();
            Assertions.assertThat((boolean)joinOperator.isFinished()).isFalse();
        }
        taskContext = this.createTaskContext();
        joinOperatorFactory = this.createJoinOperatorFactoryWithBlockingLookupSource(taskContext, parallelBuild, probeHashEnabled, buildHashEnabled, false);
        driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        joinOperator = joinOperatorFactory.createOperator(driverContext);
        try {
            joinOperatorFactory.noMoreOperators();
            Assertions.assertThat((boolean)joinOperator.needsInput()).isTrue();
            joinOperator.finish();
            Assertions.assertThat((Object)joinOperator.getOutput()).isNull();
            Assertions.assertThat((Object)joinOperator.getOutput()).isNull();
            Assertions.assertThat((boolean)joinOperator.isBlocked().isDone()).isTrue();
            Assertions.assertThat((boolean)joinOperator.isFinished()).isTrue();
        }
        finally {
            if (joinOperator != null) {
                joinOperator.close();
            }
        }
    }

    @Test
    public void testInnerJoinWithBlockingLookupSource() throws Exception {
        this.testInnerJoinWithBlockingLookupSource(true, true, true);
        this.testInnerJoinWithBlockingLookupSource(true, true, false);
        this.testInnerJoinWithBlockingLookupSource(true, false, true);
        this.testInnerJoinWithBlockingLookupSource(true, false, false);
        this.testInnerJoinWithBlockingLookupSource(false, true, true);
        this.testInnerJoinWithBlockingLookupSource(false, true, false);
        this.testInnerJoinWithBlockingLookupSource(false, false, true);
        this.testInnerJoinWithBlockingLookupSource(false, false, false);
    }

    private void testInnerJoinWithBlockingLookupSource(boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled) throws Exception {
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)ImmutableList.of((Object)VarcharType.VARCHAR));
        Page probePage = (Page)Iterables.getOnlyElement(probePages.addSequencePage(1, 0).build());
        TaskContext taskContext = this.createTaskContext();
        OperatorFactory joinOperatorFactory = this.createJoinOperatorFactoryWithBlockingLookupSource(taskContext, parallelBuild, probeHashEnabled, buildHashEnabled, true);
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        try (Operator joinOperator = joinOperatorFactory.createOperator(driverContext);){
            joinOperatorFactory.noMoreOperators();
            Assertions.assertThat((boolean)joinOperator.needsInput()).isFalse();
            Assertions.assertThat((Object)joinOperator.getOutput()).isNull();
            Assertions.assertThat((boolean)joinOperator.isBlocked().isDone()).isFalse();
            Assertions.assertThat((boolean)joinOperator.isFinished()).isFalse();
        }
        taskContext = this.createTaskContext();
        joinOperatorFactory = this.createJoinOperatorFactoryWithBlockingLookupSource(taskContext, parallelBuild, probeHashEnabled, buildHashEnabled, false);
        driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        joinOperator = joinOperatorFactory.createOperator(driverContext);
        try {
            joinOperatorFactory.noMoreOperators();
            Assertions.assertThat((boolean)joinOperator.needsInput()).isTrue();
            Assertions.assertThat((Object)joinOperator.getOutput()).isNull();
            Assertions.assertThat((boolean)joinOperator.isBlocked().isDone()).isTrue();
            Assertions.assertThat((boolean)joinOperator.isFinished()).isFalse();
            joinOperator.addInput(probePage);
            Assertions.assertThat((Object)joinOperator.getOutput()).isNull();
            Assertions.assertThat((boolean)joinOperator.isBlocked().isDone()).isFalse();
            Assertions.assertThat((boolean)joinOperator.isFinished()).isFalse();
        }
        finally {
            if (joinOperator != null) {
                joinOperator.close();
            }
        }
    }

    @Test
    public void testInnerJoinLoadsPagesInOrder() {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(false, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        for (int i = 0; i < 100000; ++i) {
            buildPages.row("a");
        }
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, false, taskContext, buildPages, Optional.empty(), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactory = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)IntegerType.INTEGER, (Object)IntegerType.INTEGER);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(false, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        probePages.row("a", 1L, 2L);
        WorkProcessorOperatorFactory joinOperatorFactory = ((WorkProcessorOperatorAdapter.Factory)JoinTestUtils.innerJoinOperatorFactory(lookupSourceFactory, probePages, PARTITIONING_SPILLER_FACTORY, false)).getWorkProcessorOperatorFactory();
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        JoinTestUtils.buildLookupSource(this.executor, buildSideSetup);
        Page probePage = (Page)Iterables.getOnlyElement(probePages.build());
        AtomicInteger totalProbePages = new AtomicInteger();
        WorkProcessor inputPages = WorkProcessor.create(() -> {
            int probePageNumber = totalProbePages.incrementAndGet();
            if (probePageNumber == 5) {
                return WorkProcessor.ProcessState.finished();
            }
            return WorkProcessor.ProcessState.ofResult((Object)new Page(1, new Block[]{probePage.getBlock(0), new LazyBlock(1, () -> probePage.getBlock(1)), new LazyBlock(1, () -> {
                Assertions.assertThat((int)probePageNumber).isEqualTo(totalProbePages.get());
                return probePage.getBlock(2);
            })}));
        });
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(joinOperatorFactory.getOperatorId(), joinOperatorFactory.getPlanNodeId(), joinOperatorFactory.getOperatorType());
        WorkProcessorOperator joinOperator = joinOperatorFactory.create(new ProcessorContext(taskContext.getSession(), taskContext.getTaskMemoryContext(), operatorContext), inputPages);
        WorkProcessor outputPages = joinOperator.getOutputPages();
        int totalOutputPages = 0;
        for (int i = 0; i < 1000000; ++i) {
            if (!outputPages.process()) {
                driverContext.getYieldSignal().resetYieldForTesting();
                continue;
            }
            if (outputPages.isFinished()) break;
            Page page = (Page)outputPages.getResult();
            ++totalOutputPages;
            Assertions.assertThat((boolean)page.getBlock(1).isLoaded()).isFalse();
            page.getBlock(2).getLoadedBlock();
            driverContext.getYieldSignal().forceYieldForTesting();
        }
        Assertions.assertThat((totalOutputPages > totalProbePages.get() ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((boolean)outputPages.isFinished()).isTrue();
    }

    private OperatorFactory createJoinOperatorFactoryWithBlockingLookupSource(TaskContext taskContext, boolean parallelBuild, boolean probeHashEnabled, boolean buildHashEnabled, boolean waitForBuild) {
        ImmutableList buildTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder buildPages = RowPagesBuilder.rowPagesBuilder(buildHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)buildTypes);
        JoinTestUtils.BuildSideSetup buildSideSetup = JoinTestUtils.setupBuildSide(this.nodePartitioningManager, parallelBuild, taskContext, buildPages, Optional.empty(), false, SINGLE_STREAM_SPILLER_FACTORY);
        JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactoryManager = buildSideSetup.getLookupSourceFactoryManager();
        ImmutableList probeTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        RowPagesBuilder probePages = RowPagesBuilder.rowPagesBuilder(probeHashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), (Iterable<Type>)probeTypes);
        OperatorFactory joinOperatorFactory = OperatorFactories.spillingJoin((JoinOperatorType)JoinOperatorType.innerJoin((boolean)false, (boolean)waitForBuild), (int)0, (PlanNodeId)new PlanNodeId("test"), lookupSourceFactoryManager, probePages.getTypes(), (List)Ints.asList((int[])new int[]{0}), (OptionalInt)JoinTestUtils.getHashChannelAsInt(probePages), Optional.empty(), (OptionalInt)OptionalInt.of(1), (PartitioningSpillerFactory)PARTITIONING_SPILLER_FACTORY, (TypeOperators)TYPE_OPERATORS);
        JoinTestUtils.instantiateBuildDrivers(buildSideSetup, taskContext);
        return joinOperatorFactory;
    }

    private TaskContext createTaskContext() {
        return TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION);
    }

    private static List<Integer> getHashChannels(RowPagesBuilder probe, RowPagesBuilder build) {
        ImmutableList.Builder hashChannels = ImmutableList.builder();
        if (probe.getHashChannel().isPresent()) {
            hashChannels.add((Object)probe.getHashChannel().get());
        }
        if (build.getHashChannel().isPresent()) {
            hashChannels.add((Object)(probe.getTypes().size() + build.getHashChannel().get()));
        }
        return hashChannels.build();
    }

    private OperatorFactory probeOuterJoinOperatorFactory(JoinBridgeManager<PartitionedLookupSourceFactory> lookupSourceFactoryManager, RowPagesBuilder probePages) {
        return OperatorFactories.spillingJoin((JoinOperatorType)JoinOperatorType.probeOuterJoin((boolean)false), (int)0, (PlanNodeId)new PlanNodeId("test"), lookupSourceFactoryManager, probePages.getTypes(), (List)Ints.asList((int[])new int[]{0}), (OptionalInt)JoinTestUtils.getHashChannelAsInt(probePages), Optional.empty(), (OptionalInt)OptionalInt.of(1), (PartitioningSpillerFactory)PARTITIONING_SPILLER_FACTORY, (TypeOperators)TYPE_OPERATORS);
    }

    private static <T> List<List<T>> product(List<List<T>> left, List<List<T>> right) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        for (List<T> l : left) {
            for (List<T> r : right) {
                result.add(TestHashJoinOperator.concat(l, r));
            }
        }
        return result;
    }

    private static <T> List<T> concat(List<T> initialElements, List<T> moreElements) {
        return ImmutableList.copyOf((Iterable)Iterables.concat(initialElements, moreElements));
    }

    private static enum WhenSpill {
        DURING_BUILD,
        AFTER_BUILD,
        DURING_USAGE,
        NEVER;

    }
}

