/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.block.BlockAssertions;
import io.trino.operator.output.PositionsAppenderFactory;
import io.trino.operator.output.UnnestingPositionsAppender;
import io.trino.spi.block.ArrayBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.PageBuilderStatus;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.type.BlockTypeOperators;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPositionsAppender {
    private static final PositionsAppenderFactory POSITIONS_APPENDER_FACTORY = new PositionsAppenderFactory(new BlockTypeOperators());

    @Test
    public void testMixedBlockTypes() {
        for (TestType type : TestType.values()) {
            ImmutableList input = ImmutableList.of((Object)TestPositionsAppender.input(TestPositionsAppender.emptyBlock(type), new int[0]), (Object)TestPositionsAppender.input(TestPositionsAppender.nullBlock(type, 3), 0, 2), (Object)TestPositionsAppender.input(TestPositionsAppender.notNullBlock(type, 3), 1, 2), (Object)TestPositionsAppender.input(TestPositionsAppender.partiallyNullBlock(type, 4), 0, 1, 2, 3), (Object)TestPositionsAppender.input(TestPositionsAppender.partiallyNullBlock(type, 4), new int[0]), (Object)TestPositionsAppender.input((Block)TestPositionsAppender.rleBlock(type, 4), 0, 2), (Object)TestPositionsAppender.input((Block)TestPositionsAppender.rleBlock(type, 2), 0, 1), (Object)TestPositionsAppender.input((Block)TestPositionsAppender.nullRleBlock(type, 4), 1, 2), (Object)TestPositionsAppender.input(TestPositionsAppender.dictionaryBlock(type, 4, 2, 0.0f), 0, 3), (Object)TestPositionsAppender.input(TestPositionsAppender.dictionaryBlock(type, 8, 4, 0.5f), 1, 3, 5), (Object)TestPositionsAppender.input(TestPositionsAppender.dictionaryBlock(type, 8, 4, 1.0f), 1, 3, 5), (Object)TestPositionsAppender.input((Block)TestPositionsAppender.rleBlock(TestPositionsAppender.dictionaryBlock(type, 1, 2, 0.0f), 3), 2), (Object[])new BlockView[]{TestPositionsAppender.input((Block)TestPositionsAppender.rleBlock(TestPositionsAppender.dictionaryBlock(TestPositionsAppender.notNullBlock(type, 2), new int[]{1}), 3), 2), TestPositionsAppender.input((Block)TestPositionsAppender.rleBlock(TestPositionsAppender.dictionaryBlock((Block)TestPositionsAppender.rleBlock(type, 4), 1), 3), 1), TestPositionsAppender.input(TestPositionsAppender.dictionaryBlock(TestPositionsAppender.dictionaryBlock(type, 5, 4, 0.5f), 3), 2), TestPositionsAppender.input(TestPositionsAppender.dictionaryBlock(TestPositionsAppender.dictionaryBlock(TestPositionsAppender.dictionaryBlock(type, 5, 4, 0.5f), 3), 3), 2), TestPositionsAppender.input(TestPositionsAppender.dictionaryBlock((Block)TestPositionsAppender.rleBlock(type, 4), 3), 0, 2), TestPositionsAppender.input(TestPositionsAppender.notNullBlock(type, 4).getRegion(2, 2), 0, 1), TestPositionsAppender.input(TestPositionsAppender.partiallyNullBlock(type, 4).getRegion(2, 2), 0, 1), TestPositionsAppender.input((Block)TestPositionsAppender.rleBlock(TestPositionsAppender.notNullBlock(type, 4).getRegion(2, 1), 3), 1)});
            TestPositionsAppender.testAppend(type, (List<BlockView>)input);
        }
    }

    @Test
    public void testNullRle() {
        for (TestType type : TestType.values()) {
            TestPositionsAppender.testNullRle(type.getType(), TestPositionsAppender.nullBlock(type, 2));
            TestPositionsAppender.testNullRle(type.getType(), (Block)TestPositionsAppender.nullRleBlock(type, 2));
            TestPositionsAppender.testNullRle(type.getType(), TestPositionsAppender.createRandomBlockForType(type, 4, 0.5f));
        }
    }

    @Test
    public void testRleSwitchToFlat() {
        for (TestType type : TestType.values()) {
            ImmutableList inputs = ImmutableList.of((Object)TestPositionsAppender.input((Block)TestPositionsAppender.rleBlock(type, 3), 0, 1), (Object)TestPositionsAppender.input(TestPositionsAppender.notNullBlock(type, 2), 0, 1));
            TestPositionsAppender.testAppend(type, (List<BlockView>)inputs);
            ImmutableList dictionaryInputs = ImmutableList.of((Object)TestPositionsAppender.input((Block)TestPositionsAppender.rleBlock(type, 3), 0, 1), (Object)TestPositionsAppender.input(TestPositionsAppender.dictionaryBlock(type, 2, 4, 0.0f), 0, 1));
            TestPositionsAppender.testAppend(type, (List<BlockView>)dictionaryInputs);
        }
    }

    @Test
    public void testFlatAppendRle() {
        for (TestType type : TestType.values()) {
            ImmutableList inputs = ImmutableList.of((Object)TestPositionsAppender.input(TestPositionsAppender.notNullBlock(type, 2), 0, 1), (Object)TestPositionsAppender.input((Block)TestPositionsAppender.rleBlock(type, 3), 0, 1));
            TestPositionsAppender.testAppend(type, (List<BlockView>)inputs);
            ImmutableList dictionaryInputs = ImmutableList.of((Object)TestPositionsAppender.input(TestPositionsAppender.dictionaryBlock(type, 2, 4, 0.0f), 0, 1), (Object)TestPositionsAppender.input((Block)TestPositionsAppender.rleBlock(type, 3), 0, 1));
            TestPositionsAppender.testAppend(type, (List<BlockView>)dictionaryInputs);
        }
    }

    @Test
    public void testMultipleRleBlocksWithDifferentValues() {
        this.testMultipleRleBlocksWithDifferentValues(TestType.BIGINT, (Block)BlockAssertions.createLongsBlock(0), (Block)BlockAssertions.createLongsBlock(1));
        this.testMultipleRleBlocksWithDifferentValues(TestType.BOOLEAN, (Block)BlockAssertions.createBooleansBlock(true), (Block)BlockAssertions.createBooleansBlock(false));
        this.testMultipleRleBlocksWithDifferentValues(TestType.INTEGER, (Block)BlockAssertions.createIntsBlock(0), (Block)BlockAssertions.createIntsBlock(1));
        this.testMultipleRleBlocksWithDifferentValues(TestType.CHAR_10, (Block)BlockAssertions.createStringsBlock("0"), (Block)BlockAssertions.createStringsBlock("1"));
        this.testMultipleRleBlocksWithDifferentValues(TestType.VARCHAR, (Block)BlockAssertions.createStringsBlock("0"), (Block)BlockAssertions.createStringsBlock("1"));
        this.testMultipleRleBlocksWithDifferentValues(TestType.DOUBLE, (Block)BlockAssertions.createDoublesBlock(0.0), (Block)BlockAssertions.createDoublesBlock(1.0));
        this.testMultipleRleBlocksWithDifferentValues(TestType.SMALLINT, (Block)BlockAssertions.createSmallintsBlock(0), (Block)BlockAssertions.createSmallintsBlock(1));
        this.testMultipleRleBlocksWithDifferentValues(TestType.TINYINT, (Block)BlockAssertions.createTinyintsBlock(0), (Block)BlockAssertions.createTinyintsBlock(1));
        this.testMultipleRleBlocksWithDifferentValues(TestType.VARBINARY, (Block)BlockAssertions.createSlicesBlock(Slices.allocate((int)8)), (Block)BlockAssertions.createSlicesBlock(Slices.allocate((int)8).getOutput().appendLong(1L).slice()));
        this.testMultipleRleBlocksWithDifferentValues(TestType.LONG_DECIMAL, (Block)BlockAssertions.createLongDecimalsBlock("0"), (Block)BlockAssertions.createLongDecimalsBlock("1"));
        this.testMultipleRleBlocksWithDifferentValues(TestType.ARRAY_BIGINT, (Block)BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)0L))), (Block)BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)1L))));
        this.testMultipleRleBlocksWithDifferentValues(TestType.LONG_TIMESTAMP, (Block)BlockAssertions.createLongTimestampBlock(TimestampType.createTimestampType((int)9), new LongTimestamp(0L, 0)), (Block)BlockAssertions.createLongTimestampBlock(TimestampType.createTimestampType((int)9), new LongTimestamp(1L, 0)));
        this.testMultipleRleBlocksWithDifferentValues(TestType.VARCHAR_WITH_TEST_BLOCK, TestPositionsAppender.adapt((Block)BlockAssertions.createStringsBlock("0")), TestPositionsAppender.adapt((Block)BlockAssertions.createStringsBlock("1")));
    }

    private void testMultipleRleBlocksWithDifferentValues(TestType type, Block value1, Block value2) {
        ImmutableList input = ImmutableList.of((Object)TestPositionsAppender.input((Block)TestPositionsAppender.rleBlock(value1, 3), 0, 1), (Object)TestPositionsAppender.input((Block)TestPositionsAppender.rleBlock(value2, 3), 0, 1));
        TestPositionsAppender.testAppend(type, (List<BlockView>)input);
    }

    @Test
    public void testMultipleRleWithTheSameValueProduceRle() {
        for (TestType type : TestType.values()) {
            UnnestingPositionsAppender positionsAppender = POSITIONS_APPENDER_FACTORY.create(type.getType(), 10, 0x100000L);
            Block value = TestPositionsAppender.notNullBlock(type, 1);
            positionsAppender.append(TestPositionsAppender.allPositions(3), (Block)TestPositionsAppender.rleBlock(value, 3));
            positionsAppender.append(TestPositionsAppender.allPositions(2), (Block)TestPositionsAppender.rleBlock(value, 2));
            Block actual = positionsAppender.build();
            Assertions.assertThat((int)actual.getPositionCount()).isEqualTo(5);
            Assertions.assertThat((Object)actual).isInstanceOf(RunLengthEncodedBlock.class);
        }
    }

    @Test
    public void testRleAppendForComplexTypeWithNullElement() {
        this.testRleAppendForComplexTypeWithNullElement(TestType.ROW_BIGINT_VARCHAR, (Block)RowBlock.fromFieldBlocks((int)1, (Block[])new Block[]{TestPositionsAppender.nullBlock((Type)BigintType.BIGINT, 1), TestPositionsAppender.nullBlock((Type)VarcharType.VARCHAR, 1)}));
        this.testRleAppendForComplexTypeWithNullElement(TestType.ARRAY_BIGINT, (Block)ArrayBlock.fromElementBlock((int)1, Optional.empty(), (int[])new int[]{0, 1}, (Block)TestPositionsAppender.nullBlock((Type)BigintType.BIGINT, 1)));
    }

    private void testRleAppendForComplexTypeWithNullElement(TestType type, Block value) {
        Preconditions.checkArgument((value.getPositionCount() == 1 ? 1 : 0) != 0);
        UnnestingPositionsAppender positionsAppender = POSITIONS_APPENDER_FACTORY.create(type.getType(), 10, 0x100000L);
        positionsAppender.append(TestPositionsAppender.allPositions(3), (Block)TestPositionsAppender.rleBlock(value, 3));
        positionsAppender.append(TestPositionsAppender.allPositions(2), (Block)TestPositionsAppender.rleBlock(value, 2));
        Block actual = positionsAppender.build();
        Assertions.assertThat((int)actual.getPositionCount()).isEqualTo(5);
        Assertions.assertThat((Object)actual).isInstanceOf(RunLengthEncodedBlock.class);
        BlockAssertions.assertBlockEquals(type.getType(), actual, RunLengthEncodedBlock.create((Block)value, (int)5));
    }

    @Test
    public void testRleAppendedWithSinglePositionDoesNotProduceRle() {
        for (TestType type : TestType.values()) {
            UnnestingPositionsAppender positionsAppender = POSITIONS_APPENDER_FACTORY.create(type.getType(), 10, 0x100000L);
            Block value = TestPositionsAppender.notNullBlock(type, 1);
            positionsAppender.append(TestPositionsAppender.allPositions(3), (Block)TestPositionsAppender.rleBlock(value, 3));
            positionsAppender.append(TestPositionsAppender.allPositions(2), (Block)TestPositionsAppender.rleBlock(value, 2));
            positionsAppender.append(0, (Block)TestPositionsAppender.rleBlock(value, 2));
            Block actual = positionsAppender.build();
            Assertions.assertThat((int)actual.getPositionCount()).isEqualTo(6);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)(actual instanceof RunLengthEncodedBlock)).describedAs(actual.getClass().getSimpleName(), new Object[0])).isFalse();
        }
    }

    @Test
    public void testMultipleTheSameDictionariesProduceDictionary() {
        for (TestType type : TestType.values()) {
            UnnestingPositionsAppender positionsAppender = POSITIONS_APPENDER_FACTORY.create(type.getType(), 10, 0x100000L);
            TestPositionsAppender.testMultipleTheSameDictionariesProduceDictionary(type, positionsAppender);
            TestPositionsAppender.testMultipleTheSameDictionariesProduceDictionary(type, positionsAppender);
        }
    }

    private static void testMultipleTheSameDictionariesProduceDictionary(TestType type, UnnestingPositionsAppender positionsAppender) {
        Block dictionary = TestPositionsAppender.createRandomBlockForType(type, 4, 0.0f);
        positionsAppender.append(TestPositionsAppender.allPositions(3), BlockAssertions.createRandomDictionaryBlock(dictionary, 3));
        positionsAppender.append(TestPositionsAppender.allPositions(2), BlockAssertions.createRandomDictionaryBlock(dictionary, 2));
        Block actual = positionsAppender.build();
        Assertions.assertThat((int)actual.getPositionCount()).isEqualTo(5);
        Assertions.assertThat((Object)actual).isInstanceOf(DictionaryBlock.class);
        Assertions.assertThat((Object)((DictionaryBlock)actual).getDictionary()).isEqualTo((Object)dictionary);
    }

    @Test
    public void testDictionarySwitchToFlat() {
        for (TestType type : TestType.values()) {
            ImmutableList inputs = ImmutableList.of((Object)TestPositionsAppender.input(TestPositionsAppender.dictionaryBlock(type, 3, 4, 0.0f), 0, 1), (Object)TestPositionsAppender.input(TestPositionsAppender.notNullBlock(type, 2), 0, 1));
            TestPositionsAppender.testAppend(type, (List<BlockView>)inputs);
        }
    }

    @Test
    public void testFlatAppendDictionary() {
        for (TestType type : TestType.values()) {
            ImmutableList inputs = ImmutableList.of((Object)TestPositionsAppender.input(TestPositionsAppender.notNullBlock(type, 2), 0, 1), (Object)TestPositionsAppender.input(TestPositionsAppender.dictionaryBlock(type, 3, 4, 0.0f), 0, 1));
            TestPositionsAppender.testAppend(type, (List<BlockView>)inputs);
        }
    }

    @Test
    public void testDictionaryAppendDifferentDictionary() {
        for (TestType type : TestType.values()) {
            ImmutableList dictionaryInputs = ImmutableList.of((Object)TestPositionsAppender.input(TestPositionsAppender.dictionaryBlock(type, 3, 4, 0.0f), 0, 1), (Object)TestPositionsAppender.input(TestPositionsAppender.dictionaryBlock(type, 2, 4, 0.0f), 0, 1));
            TestPositionsAppender.testAppend(type, (List<BlockView>)dictionaryInputs);
        }
    }

    @Test
    public void testDictionarySingleThenFlat() {
        for (TestType type : TestType.values()) {
            BlockView firstInput = TestPositionsAppender.input(TestPositionsAppender.dictionaryBlock(type, 1, 4, 0.0f), 0);
            BlockView secondInput = TestPositionsAppender.input(TestPositionsAppender.dictionaryBlock(type, 2, 4, 0.0f), 0, 1);
            UnnestingPositionsAppender positionsAppender = POSITIONS_APPENDER_FACTORY.create(type.getType(), 10, 0x100000L);
            long initialRetainedSize = positionsAppender.getRetainedSizeInBytes();
            firstInput.positions().forEach(position -> positionsAppender.append(position, firstInput.block()));
            positionsAppender.append(secondInput.positions(), secondInput.block());
            TestPositionsAppender.assertBuildResult(type, (List<BlockView>)ImmutableList.of((Object)firstInput, (Object)secondInput), positionsAppender, initialRetainedSize);
        }
    }

    @Test
    public void testConsecutiveBuilds() {
        for (TestType type : TestType.values()) {
            UnnestingPositionsAppender positionsAppender = POSITIONS_APPENDER_FACTORY.create(type.getType(), 10, 0x100000L);
            positionsAppender.append(TestPositionsAppender.positions(new int[0]), TestPositionsAppender.emptyBlock(type));
            Assertions.assertThat((int)positionsAppender.build().getPositionCount()).isEqualTo(0);
            Block block = TestPositionsAppender.createRandomBlockForType(type, 2, 0.5f);
            int nullPosition = block.isNull(0) ? 0 : 1;
            positionsAppender.append(TestPositionsAppender.positions(nullPosition), block);
            Block actualNullBlock = positionsAppender.build();
            Assertions.assertThat((int)actualNullBlock.getPositionCount()).isEqualTo(1);
            Assertions.assertThat((boolean)actualNullBlock.isNull(0)).isTrue();
            positionsAppender.append(TestPositionsAppender.allPositions(2), block);
            BlockAssertions.assertBlockEquals(type.getType(), positionsAppender.build(), block);
            RunLengthEncodedBlock rleBlock = TestPositionsAppender.rleBlock(type, 10);
            positionsAppender.append(TestPositionsAppender.allPositions(10), (Block)rleBlock);
            BlockAssertions.assertBlockEquals(type.getType(), positionsAppender.build(), (Block)rleBlock);
            RunLengthEncodedBlock nullRleBlock = TestPositionsAppender.nullRleBlock(type, 10);
            positionsAppender.append(TestPositionsAppender.allPositions(10), (Block)nullRleBlock);
            BlockAssertions.assertBlockEquals(type.getType(), positionsAppender.build(), (Block)nullRleBlock);
            Block dictionaryBlock = TestPositionsAppender.dictionaryBlock(type, 10, 5, 0.0f);
            positionsAppender.append(TestPositionsAppender.allPositions(10), dictionaryBlock);
            BlockAssertions.assertBlockEquals(type.getType(), positionsAppender.build(), dictionaryBlock);
            Assertions.assertThat((int)positionsAppender.build().getPositionCount()).isEqualTo(0);
        }
    }

    @Test
    public void testSliceRle() {
        UnnestingPositionsAppender positionsAppender = POSITIONS_APPENDER_FACTORY.create((Type)VarcharType.VARCHAR, 10, 0x100000L);
        positionsAppender.appendRle(TestPositionsAppender.singleValueBlock("some value"), 1);
        ValueBlock emptyStringBlock = TestPositionsAppender.singleValueBlock("");
        for (int i = 0; i < 1000; ++i) {
            positionsAppender.appendRle(emptyStringBlock, 2000);
        }
    }

    @Test
    public void testRowWithNestedFields() {
        RowType type = RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT, VarcharType.VARCHAR});
        RowBlock rowBLock = RowBlock.fromFieldBlocks((int)2, (Block[])new Block[]{TestPositionsAppender.notNullBlock(TestType.BIGINT, 2), TestPositionsAppender.dictionaryBlock(TestType.BIGINT, 2, 2, 0.5f), TestPositionsAppender.rleBlock(TestType.VARCHAR, 2)});
        UnnestingPositionsAppender positionsAppender = POSITIONS_APPENDER_FACTORY.create((Type)type, 10, 0x100000L);
        positionsAppender.append(TestPositionsAppender.allPositions(2), (Block)rowBLock);
        Block actual = positionsAppender.build();
        BlockAssertions.assertBlockEquals((Type)type, actual, (Block)rowBLock);
    }

    private static ValueBlock singleValueBlock(String value) {
        VariableWidthBlockBuilder blockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 1);
        VarcharType.VARCHAR.writeSlice((BlockBuilder)blockBuilder, Slices.utf8Slice((String)value));
        return blockBuilder.buildValueBlock();
    }

    private static IntArrayList allPositions(int count) {
        return new IntArrayList(IntStream.range(0, count).toArray());
    }

    private static BlockView input(Block block, int ... positions) {
        return new BlockView(block, new IntArrayList(positions));
    }

    private static IntArrayList positions(int ... positions) {
        return new IntArrayList(positions);
    }

    private static Block dictionaryBlock(Block dictionary, int positionCount) {
        return BlockAssertions.createRandomDictionaryBlock(dictionary, positionCount);
    }

    private static Block dictionaryBlock(Block dictionary, int[] ids) {
        return DictionaryBlock.create((int)ids.length, (Block)dictionary, (int[])ids);
    }

    private static Block dictionaryBlock(TestType type, int positionCount, int dictionarySize, float nullRate) {
        Block dictionary = TestPositionsAppender.createRandomBlockForType(type, dictionarySize, nullRate);
        return BlockAssertions.createRandomDictionaryBlock(dictionary, positionCount);
    }

    private static RunLengthEncodedBlock rleBlock(Block value, int positionCount) {
        Preconditions.checkArgument((positionCount >= 2 ? 1 : 0) != 0);
        return (RunLengthEncodedBlock)RunLengthEncodedBlock.create((Block)value, (int)positionCount);
    }

    private static RunLengthEncodedBlock rleBlock(TestType type, int positionCount) {
        Preconditions.checkArgument((positionCount >= 2 ? 1 : 0) != 0);
        Block rleValue = TestPositionsAppender.createRandomBlockForType(type, 1, 0.0f);
        return (RunLengthEncodedBlock)RunLengthEncodedBlock.create((Block)rleValue, (int)positionCount);
    }

    private static RunLengthEncodedBlock nullRleBlock(TestType type, int positionCount) {
        Preconditions.checkArgument((positionCount >= 2 ? 1 : 0) != 0);
        Block rleValue = TestPositionsAppender.nullBlock(type, 1);
        return (RunLengthEncodedBlock)RunLengthEncodedBlock.create((Block)rleValue, (int)positionCount);
    }

    private static Block partiallyNullBlock(TestType type, int positionCount) {
        return TestPositionsAppender.createRandomBlockForType(type, positionCount, 0.5f);
    }

    private static Block notNullBlock(TestType type, int positionCount) {
        return TestPositionsAppender.createRandomBlockForType(type, positionCount, 0.0f);
    }

    private static Block nullBlock(TestType type, int positionCount) {
        BlockBuilder blockBuilder = type.getType().createBlockBuilder(null, positionCount);
        for (int i = 0; i < positionCount; ++i) {
            blockBuilder.appendNull();
        }
        return type.adapt(blockBuilder.build());
    }

    private static Block nullBlock(Type type, int positionCount) {
        BlockBuilder blockBuilder = type.createBlockBuilder(null, positionCount);
        for (int i = 0; i < positionCount; ++i) {
            blockBuilder.appendNull();
        }
        return blockBuilder.build();
    }

    private static Block emptyBlock(TestType type) {
        return type.adapt(type.getType().createBlockBuilder(null, 0).build());
    }

    private static Block createRandomBlockForType(TestType type, int positionCount, float nullRate) {
        return type.adapt((Block)BlockAssertions.createRandomBlockForType(type.getType(), positionCount, nullRate));
    }

    private static void testNullRle(Type type, Block source) {
        UnnestingPositionsAppender positionsAppender = POSITIONS_APPENDER_FACTORY.create(type, 10, 0x100000L);
        IntArrayList positions = new IntArrayList(source.getPositionCount());
        for (int i = 0; i < source.getPositionCount(); ++i) {
            if (!source.isNull(i)) continue;
            positions.add(i);
        }
        positionsAppender.append(positions, source);
        positionsAppender.append(positions, source);
        Block actual = positionsAppender.build();
        Assertions.assertThat((boolean)actual.isNull(0)).isTrue();
        Assertions.assertThat((int)actual.getPositionCount()).isEqualTo(positions.size() * 2);
        Assertions.assertThat((Object)actual).isInstanceOf(RunLengthEncodedBlock.class);
    }

    private static void testAppend(TestType type, List<BlockView> inputs) {
        TestPositionsAppender.testAppendBatch(type, inputs);
        TestPositionsAppender.testAppendSingle(type, inputs);
    }

    private static void testAppendBatch(TestType type, List<BlockView> inputs) {
        UnnestingPositionsAppender positionsAppender = POSITIONS_APPENDER_FACTORY.create(type.getType(), 10, 0x100000L);
        long initialRetainedSize = positionsAppender.getRetainedSizeInBytes();
        inputs.forEach(input -> positionsAppender.append(input.positions(), input.block()));
        TestPositionsAppender.assertBuildResult(type, inputs, positionsAppender, initialRetainedSize);
    }

    private static void assertBuildResult(TestType type, List<BlockView> inputs, UnnestingPositionsAppender positionsAppender, long initialRetainedSize) {
        long sizeInBytes = positionsAppender.getSizeInBytes();
        Assertions.assertThat((long)positionsAppender.getRetainedSizeInBytes()).isGreaterThanOrEqualTo(sizeInBytes);
        Block actual = positionsAppender.build();
        TestPositionsAppender.assertBlockIsValid(actual, sizeInBytes, type.getType(), inputs);
        Assertions.assertThat((long)positionsAppender.getSizeInBytes()).isEqualTo(0L);
        Assertions.assertThat((long)positionsAppender.getRetainedSizeInBytes()).isEqualTo(initialRetainedSize);
        Block secondBlock = positionsAppender.build();
        Assertions.assertThat((int)secondBlock.getPositionCount()).isEqualTo(0);
    }

    private static void testAppendSingle(TestType type, List<BlockView> inputs) {
        UnnestingPositionsAppender positionsAppender = POSITIONS_APPENDER_FACTORY.create(type.getType(), 10, 0x100000L);
        long initialRetainedSize = positionsAppender.getRetainedSizeInBytes();
        inputs.forEach(input -> input.positions().forEach(position -> positionsAppender.append(position, input.block())));
        long sizeInBytes = positionsAppender.getSizeInBytes();
        Assertions.assertThat((long)positionsAppender.getRetainedSizeInBytes()).isGreaterThanOrEqualTo(sizeInBytes);
        Block actual = positionsAppender.build();
        TestPositionsAppender.assertBlockIsValid(actual, sizeInBytes, type.getType(), inputs);
        Assertions.assertThat((long)positionsAppender.getSizeInBytes()).isEqualTo(0L);
        Assertions.assertThat((long)positionsAppender.getRetainedSizeInBytes()).isEqualTo(initialRetainedSize);
        Block secondBlock = positionsAppender.build();
        Assertions.assertThat((int)secondBlock.getPositionCount()).isEqualTo(0);
    }

    private static void assertBlockIsValid(Block actual, long sizeInBytes, Type type, List<BlockView> inputs) {
        PageBuilderStatus pageBuilderStatus = new PageBuilderStatus();
        BlockBuilderStatus blockBuilderStatus = pageBuilderStatus.createBlockBuilderStatus();
        Block expected = TestPositionsAppender.buildBlock(type, inputs, blockBuilderStatus);
        BlockAssertions.assertBlockEquals(type, actual, expected);
        Assertions.assertThat((long)sizeInBytes).isEqualTo(pageBuilderStatus.getSizeInBytes());
    }

    private static Block buildBlock(Type type, List<BlockView> inputs, BlockBuilderStatus blockBuilderStatus) {
        BlockBuilder blockBuilder = type.createBlockBuilder(blockBuilderStatus, 10);
        for (BlockView input : inputs) {
            IntListIterator intListIterator = input.positions().iterator();
            while (intListIterator.hasNext()) {
                int position = (Integer)intListIterator.next();
                type.appendTo(input.block(), position, blockBuilder);
            }
        }
        return blockBuilder.build();
    }

    private static Function<Block, Block> adaptation() {
        return TestPositionsAppender::adapt;
    }

    private static Block adapt(Block block) {
        if (block instanceof RunLengthEncodedBlock) {
            Preconditions.checkArgument((block.getPositionCount() == 0 || block.isNull(0) ? 1 : 0) != 0);
            return RunLengthEncodedBlock.create((Block)new VariableWidthBlock(1, Slices.EMPTY_SLICE, new int[]{0, 0}, Optional.of(new boolean[]{true})), (int)block.getPositionCount());
        }
        VariableWidthBlock variableWidthBlock = (VariableWidthBlock)block;
        int[] offsets = new int[variableWidthBlock.getPositionCount() + 1];
        boolean[] valueIsNull = new boolean[variableWidthBlock.getPositionCount()];
        boolean hasNullValue = false;
        for (int i = 0; i < variableWidthBlock.getPositionCount(); ++i) {
            if (variableWidthBlock.isNull(i)) {
                valueIsNull[i] = true;
                hasNullValue = true;
                offsets[i + 1] = offsets[i];
                continue;
            }
            offsets[i + 1] = offsets[i] + variableWidthBlock.getSliceLength(i);
        }
        return new VariableWidthBlock(variableWidthBlock.getPositionCount(), variableWidthBlock.getRawSlice(), offsets, hasNullValue ? Optional.of(valueIsNull) : Optional.empty());
    }

    private static enum TestType {
        BIGINT((Type)BigintType.BIGINT),
        BOOLEAN((Type)BooleanType.BOOLEAN),
        INTEGER((Type)IntegerType.INTEGER),
        CHAR_10((Type)CharType.createCharType((int)10)),
        VARCHAR((Type)VarcharType.createUnboundedVarcharType()),
        DOUBLE((Type)DoubleType.DOUBLE),
        SMALLINT((Type)SmallintType.SMALLINT),
        TINYINT((Type)TinyintType.TINYINT),
        VARBINARY((Type)VarbinaryType.VARBINARY),
        LONG_DECIMAL((Type)DecimalType.createDecimalType((int)19)),
        LONG_TIMESTAMP((Type)TimestampType.createTimestampType((int)9)),
        ROW_BIGINT_VARCHAR((Type)RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR})),
        ARRAY_BIGINT((Type)new ArrayType((Type)BigintType.BIGINT)),
        VARCHAR_WITH_TEST_BLOCK((Type)VarcharType.VARCHAR, TestPositionsAppender.adaptation());

        private final Type type;
        private final Function<Block, Block> blockAdaptation;

        private TestType(Type type) {
            this(type, Function.identity());
        }

        private TestType(Type type, Function<Block, Block> blockAdaptation) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.blockAdaptation = Objects.requireNonNull(blockAdaptation, "blockAdaptation is null");
        }

        public Block adapt(Block block) {
            return this.blockAdaptation.apply(block);
        }

        public Type getType() {
            return this.type;
        }
    }

    private record BlockView(Block block, IntArrayList positions) {
        private BlockView {
            Objects.requireNonNull(block, "block is null");
            Objects.requireNonNull(positions, "positions is null");
        }
    }
}

