/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.operator.scalar.ChoicesSpecializedSqlScalarFunction;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestParametricScalarFunctionImplementationValidation {
    private static final MethodHandle STATE_FACTORY = Reflection.methodHandle(TestParametricScalarFunctionImplementationValidation.class, (String)"createState", (Class[])new Class[0]);

    @Test
    public void testConnectorSessionPosition() {
        MethodHandle validFunctionMethodHandle = Reflection.methodHandle(TestParametricScalarFunctionImplementationValidation.class, (String)"validConnectorSessionParameterPosition", (Class[])new Class[]{ConnectorSession.class, Long.TYPE, Long.TYPE});
        BoundSignature signature = new BoundSignature(GlobalFunctionCatalog.builtinFunctionName((String)"test"), (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
        ChoicesSpecializedSqlScalarFunction validFunction = new ChoicesSpecializedSqlScalarFunction(signature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), validFunctionMethodHandle);
        Assertions.assertThat((Object)((ChoicesSpecializedSqlScalarFunction.ScalarImplementationChoice)validFunction.getChoices().get(0)).getMethodHandle()).isEqualTo((Object)validFunctionMethodHandle);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new ChoicesSpecializedSqlScalarFunction(signature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), Reflection.methodHandle(TestParametricScalarFunctionImplementationValidation.class, (String)"invalidConnectorSessionParameterPosition", (Class[])new Class[]{Long.TYPE, Long.TYPE, ConnectorSession.class}))).isInstanceOf(IllegalArgumentException.class)).hasMessage("ConnectorSession must be the first argument when instanceFactory is not present");
        MethodHandle validFunctionWithInstanceFactoryMethodHandle = Reflection.methodHandle(TestParametricScalarFunctionImplementationValidation.class, (String)"validConnectorSessionParameterPosition", (Class[])new Class[]{Object.class, ConnectorSession.class, Long.TYPE, Long.TYPE});
        ChoicesSpecializedSqlScalarFunction validFunctionWithInstanceFactory = new ChoicesSpecializedSqlScalarFunction(signature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), validFunctionWithInstanceFactoryMethodHandle, Optional.of(STATE_FACTORY));
        Assertions.assertThat((Object)((ChoicesSpecializedSqlScalarFunction.ScalarImplementationChoice)validFunctionWithInstanceFactory.getChoices().get(0)).getMethodHandle()).isEqualTo((Object)validFunctionWithInstanceFactoryMethodHandle);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new ChoicesSpecializedSqlScalarFunction(signature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), Reflection.methodHandle(TestParametricScalarFunctionImplementationValidation.class, (String)"invalidConnectorSessionParameterPosition", (Class[])new Class[]{Object.class, Long.TYPE, Long.TYPE, ConnectorSession.class}), Optional.of(STATE_FACTORY))).isInstanceOf(IllegalArgumentException.class)).hasMessage("ConnectorSession must be the second argument when instanceFactory is present");
    }

    public static Object createState() {
        return null;
    }

    public static long validConnectorSessionParameterPosition(ConnectorSession session, long arg1, long arg2) {
        return arg1 + arg2;
    }

    public static long validConnectorSessionParameterPosition(Object state, ConnectorSession session, long arg1, long arg2) {
        return arg1 + arg2;
    }

    public static long invalidConnectorSessionParameterPosition(long arg1, long arg2, ConnectorSession session) {
        return arg1 + arg2;
    }

    public static long invalidConnectorSessionParameterPosition(Object state, long arg1, long arg2, ConnectorSession session) {
        return arg1 + arg2;
    }
}

